/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.tools.javac.Main;
import factory.ImageFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import model.board.BoardInitializeData;
import model.board.GameKt;
import model.event.GameSettingsUpdateEvent;
import model.player.Player;
import model.player.PlayerType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import service.DelayerService;
import service.GameSettingsScreenService;
import service.server.Server;
import view.component.AllInputVerifiers;
import view.component.AllInputVerifiersKt;
import view.component.GuiConstantsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001BB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0018\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0002J\b\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020 H\u0002J\b\u0010)\u001a\u00020 H\u0002J\b\u0010*\u001a\u00020 H\u0002J\b\u0010+\u001a\u00020 H\u0002J\b\u0010,\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020 H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u0011H\u0002J\b\u00101\u001a\u00020 H\u0002J\b\u00102\u001a\u00020 H\u0002J\u0016\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002J\u0018\u00108\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0002J\b\u00109\u001a\u00020 H\u0002J\u0010\u0010:\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010;\u001a\u00020 J \u0010<\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0005H\u0002J\u001a\u0010>\u001a\u00020 2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\r0@J\f\u0010A\u001a\u00020 *\u00020\u001cH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lview/GameSettingsScreen;", "", "frame", "Ljavax/swing/JFrame;", "isServer", "", "(Ljavax/swing/JFrame;Z)V", "addBotButton", "Ljavax/swing/JButton;", "addHumanButton", "allPlayerNameFields", "", "Ljavax/swing/JLabel;", "Lmodel/player/PlayerType;", "allSettingsPane", "Ljavax/swing/JSplitPane;", "botPlayingTimeField", "Ljavax/swing/JTextField;", "explosionTimeDecrementField", "explosionTimeField", "frameWith", "", "hasInitialized", "mainServer", "Lservice/server/Server;", "nameInputField", "numberOfWalls", "playerDisplayGrid", "Ljavax/swing/JPanel;", "xField", "yField", "addButtons", "", "playerDisplay", "addPlayer", "name", "", "playerType", "addPlayerDisplay", "addTitle", "editBotButton", "editBotPlayingTimeField", "editExplosionTimeDecrementField", "editExplosionTimeDefaultField", "editHumanButton", "editNameField", "editNumberOfWalls", "editUserInputField", "field", "editXField", "editYField", "getBoardData", "Lmodel/board/BoardInitializeData;", "players", "", "Lmodel/player/Player;", "getDisconnectButton", "giveUpdatesToServer", "setIconImage", "start", "updateNames", "isDisconnecting", "updatePlayers", "namesOfPlayers", "", "createInputFields", "FrameListener", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nGameSettingsScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameSettingsScreen.kt\nview/GameSettingsScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,464:1\n1549#2:465\n1620#2,3:466\n1238#2,4:472\n1747#2,3:478\n1238#2,4:483\n1747#2,3:487\n1747#2,3:490\n1#3:469\n457#4:470\n403#4:471\n457#4:481\n403#4:482\n215#5,2:476\n*S KotlinDebug\n*F\n+ 1 GameSettingsScreen.kt\nview/GameSettingsScreen\n*L\n401#1:465\n401#1:466,3\n416#1:472,4\n126#1:478,3\n138#1:483,4\n277#1:487,3\n334#1:490,3\n416#1:470\n416#1:471\n138#1:481\n138#1:482\n426#1:476,2\n*E\n"})
public final class GameSettingsScreen {
    @NotNull
    private final JFrame frame;
    private final boolean isServer;
    @NotNull
    private final JTextField nameInputField;
    @NotNull
    private final JTextField xField;
    @NotNull
    private final JTextField yField;
    @NotNull
    private final JTextField numberOfWalls;
    @NotNull
    private final JTextField explosionTimeField;
    @NotNull
    private final JTextField explosionTimeDecrementField;
    @NotNull
    private final JTextField botPlayingTimeField;
    @NotNull
    private final JButton addHumanButton;
    @NotNull
    private final JButton addBotButton;
    @NotNull
    private final Map<JLabel, PlayerType> allPlayerNameFields;
    @NotNull
    private final JPanel playerDisplayGrid;
    @Nullable
    private Server mainServer;
    private int frameWith;
    private boolean hasInitialized;
    @NotNull
    private final JSplitPane allSettingsPane;

    public GameSettingsScreen(@NotNull JFrame frame, boolean isServer) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        this.frame = frame;
        this.isServer = isServer;
        this.nameInputField = new JTextField("newname");
        this.xField = new JTextField();
        this.yField = new JTextField();
        this.numberOfWalls = new JTextField();
        this.explosionTimeField = new JTextField();
        this.explosionTimeDecrementField = new JTextField();
        this.botPlayingTimeField = new JTextField();
        this.addHumanButton = new JButton("add Human");
        this.addBotButton = new JButton("add Bot");
        this.allPlayerNameFields = new LinkedHashMap();
        this.playerDisplayGrid = new JPanel(new GridLayout(GameKt.getMAX_PLAYERS(), 1, 0, 30));
        this.frameWith = this.frame.getBounds().width;
        this.allSettingsPane = new JSplitPane();
    }

    /*
     * Unable to fully structure code
     */
    public final void start() {
        this.frame.getContentPane().removeAll();
        this.frame.repaint();
        if (this.isServer && this.mainServer == null) {
            this.mainServer = new Server((Function3<? super String, ? super PlayerType, ? super Boolean, Unit>)new Function3<String, PlayerType, Boolean, Unit>((Object)this){

                public final void invoke(@NotNull String p0, @NotNull PlayerType p1, boolean p2) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    Intrinsics.checkNotNullParameter((Object)((Object)p1), "p1");
                    GameSettingsScreen.access$updateNames((GameSettingsScreen)this.receiver, p0, p1, p2);
                }
            });
        } else if (this.mainServer != null) {
            v0 = this.mainServer;
            Intrinsics.checkNotNull(v0);
            v0.stopGameRunningFlag();
        }
        this.frame.setLayout(new BorderLayout());
        this.setIconImage(this.frame);
        this.allSettingsPane.setDividerSize(0);
        if (this.mainServer != null) {
            this.allSettingsPane.setDividerLocation(this.frameWith - 300);
            this.allSettingsPane.setOrientation(1);
        } else {
            this.allSettingsPane.setDividerLocation(this.frameWith);
        }
        playerDisplay = new JPanel(new BorderLayout());
        this.addTitle(playerDisplay);
        this.addPlayerDisplay();
        scrollPane = new JScrollPane(this.playerDisplayGrid);
        scrollPane.setBorder(null);
        playerDisplay.add((Component)scrollPane, "Center");
        this.addButtons(playerDisplay);
        playerDisplay.setBackground(Color.white);
        this.frame.getContentPane().setBackground(Color.white);
        this.allSettingsPane.setLeftComponent(playerDisplay);
        if (this.mainServer != null) {
            settings = new JPanel(new GridLayout(15, 1));
            this.createInputFields(settings);
            settings.setMinimumSize(new Dimension(200, 750));
            settings.setMaximumSize(new Dimension(200, 1000));
            scrollPaneRight = new JScrollPane(settings);
            scrollPaneRight.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
            this.allSettingsPane.setRightComponent(scrollPaneRight);
        }
        this.frame.add((Component)this.allSettingsPane, "Center");
        this.frame.addComponentListener(new FrameListener());
        if (this.mainServer == null) ** GOTO lbl-1000
        v1 = this.mainServer;
        v2 = v1 != null ? !v1.hasGameStarted() : false;
        if (v2) {
            v3 = this.mainServer;
            Intrinsics.checkNotNull(v3);
            v3.start();
        } else if (this.mainServer != null) {
            v4 = this.mainServer;
            Intrinsics.checkNotNull(v4);
            v4.start();
        }
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
        this.frame.repaint();
        this.hasInitialized = true;
    }

    private final void addButtons(JPanel playerDisplay) {
        JPanel okayCloseButtons = new JPanel(new GridLayout(1, 2, 30, 0));
        okayCloseButtons.setBorder(new EmptyBorder(50, 50, 50, (this.frameWith - 300) / 2));
        okayCloseButtons.setAlignmentX(0.0f);
        Server server2 = this.mainServer;
        if (server2 != null) {
            Server server3 = server2;
            boolean bl = false;
            JButton playButton = new JButton("play");
            playButton.setFont(new Font("Text", 0, 18));
            playButton.setFocusPainted(false);
            playButton.setBackground(new Color(230, 230, 230));
            playButton.addActionListener(arg_0 -> GameSettingsScreen.addButtons$lambda$3$lambda$2(this, server3, arg_0));
            okayCloseButtons.add(playButton);
        }
        JButton closeButton = new JButton("close");
        closeButton.setBackground(new Color(230, 230, 230));
        closeButton.setFont(new Font("Text", 0, 18));
        closeButton.setFocusPainted(false);
        closeButton.addActionListener(GameSettingsScreen::addButtons$lambda$4);
        okayCloseButtons.add(closeButton);
        if (this.mainServer == null) {
            okayCloseButtons.add(GuiConstantsKt.getBIG_HORIZONTAL_DISTANCE());
        }
        playerDisplay.add((Component)okayCloseButtons, "South");
        okayCloseButtons.setBackground(Color.WHITE);
    }

    private final void addTitle(JPanel playerDisplay) {
        JLabel titel = new JLabel("Players:");
        titel.setFont(new Font("Text", 0, 40));
        titel.setBorder(new EmptyBorder(0, 30, 0, 0));
        playerDisplay.add((Component)titel, "North");
    }

    private final BoardInitializeData getBoardData(List<? extends Player> players) {
        int xDimension = AllInputVerifiersKt.getIntByValue(this.xField);
        int yDimension = AllInputVerifiersKt.getIntByValue(this.yField);
        int walls = AllInputVerifiersKt.getIntByValue(this.numberOfWalls);
        model.board.Dimension dimension = new model.board.Dimension(xDimension, yDimension);
        return new BoardInitializeData(dimension, walls, players);
    }

    private final void createInputFields(JPanel $this$createInputFields) {
        JLabel titel = new JLabel("Settings:");
        titel.setFont(new Font("Titel", 0, 35));
        $this$createInputFields.add(titel);
        this.editNameField();
        $this$createInputFields.add(this.nameInputField);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 20, 0));
        buttonPanel.setBackground(Color.white);
        buttonPanel.setBorder(new EmptyBorder(15, 10, 0, 10));
        this.editHumanButton();
        buttonPanel.add(this.addHumanButton);
        this.editBotButton();
        buttonPanel.add(this.addBotButton);
        $this$createInputFields.add(buttonPanel);
        this.editXField();
        JLabel lengthLabel = new JLabel("Board length:");
        lengthLabel.setFont(GuiConstantsKt.getLABEL_FONT());
        $this$createInputFields.add(lengthLabel);
        $this$createInputFields.add(this.xField);
        this.editYField();
        JLabel widthLabel = new JLabel("Board width:");
        widthLabel.setFont(GuiConstantsKt.getLABEL_FONT());
        $this$createInputFields.add(widthLabel);
        $this$createInputFields.add(this.yField);
        this.editNumberOfWalls();
        JLabel numberOfWallsLabel = new JLabel("Number Of walls:");
        numberOfWallsLabel.setFont(GuiConstantsKt.getLABEL_FONT());
        $this$createInputFields.add(numberOfWallsLabel);
        $this$createInputFields.add(this.numberOfWalls);
        this.editExplosionTimeDefaultField();
        JLabel explosionTime = new JLabel("Explosion time start:");
        explosionTime.setFont(GuiConstantsKt.getLABEL_FONT());
        $this$createInputFields.add(explosionTime);
        $this$createInputFields.add(this.explosionTimeField);
        this.editExplosionTimeDecrementField();
        JLabel explosionDecrementLabel = new JLabel("Explosion decrement:");
        explosionDecrementLabel.setFont(GuiConstantsKt.getLABEL_FONT());
        $this$createInputFields.add(explosionDecrementLabel);
        $this$createInputFields.add(this.explosionTimeDecrementField);
        this.editBotPlayingTimeField();
        JLabel botPlayTime = new JLabel("Bot play time:");
        botPlayTime.setFont(GuiConstantsKt.getLABEL_FONT());
        $this$createInputFields.add(botPlayTime);
        $this$createInputFields.add(this.botPlayingTimeField);
        $this$createInputFields.setBackground(Color.WHITE);
        $this$createInputFields.setBorder(new EmptyBorder(0, 10, 0, 10));
    }

    private final void editNameField() {
        this.nameInputField.setFont(GuiConstantsKt.getUSER_INPUT_FONT());
        this.nameInputField.setBackground(GuiConstantsKt.getLIGHT_GRAY());
        this.nameInputField.addKeyListener(new KeyListener(this){
            final /* synthetic */ GameSettingsScreen this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyTyped(@Nullable KeyEvent e) {
                this.painColor();
            }

            public void keyPressed(@Nullable KeyEvent e) {
                this.painColor();
            }

            public void keyReleased(@Nullable KeyEvent e) {
                this.painColor();
            }

            /*
             * WARNING - void declaration
             */
            private final void painColor() {
                boolean bl;
                block5: {
                    void $this$any$iv;
                    Iterable iterable = GameSettingsScreen.access$getAllPlayerNameFields$p(this.this$0).keySet();
                    GameSettingsScreen gameSettingsScreen = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            JLabel it = (JLabel)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getText(), GameSettingsScreen.access$getNameInputField$p(gameSettingsScreen).getText())) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    GameSettingsScreen.access$getNameInputField$p(this.this$0).setForeground(Color.black);
                } else {
                    GameSettingsScreen.access$getNameInputField$p(this.this$0).setForeground(Color.red);
                }
            }
        });
    }

    private final void editBotButton() {
        this.addBotButton.setBackground(new Color(230, 230, 230));
        this.addBotButton.addActionListener(arg_0 -> GameSettingsScreen.editBotButton$lambda$6(this, arg_0));
    }

    private final void addPlayer(String name, PlayerType playerType) {
        ImageIcon imageIcon;
        JLabel nameField = new JLabel(name);
        nameField.setFont(new Font("Arial", 0, 24));
        nameField.setOpaque(true);
        nameField.setBackground(Color.white);
        this.allPlayerNameFields.put(nameField, playerType);
        JPanel playerPanel = new JPanel(new BorderLayout());
        playerPanel.add((Component)nameField, "Center");
        playerPanel.add((Component)this.getDisconnectButton(name, playerType), "East");
        playerPanel.setBackground(Color.white);
        switch (WhenMappings.$EnumSwitchMapping$0[playerType.ordinal()]) {
            case 1: {
                imageIcon = new ImageIcon(ImageFactory.INSTANCE.getBotIcon());
                break;
            }
            case 2: {
                imageIcon = new ImageIcon(ImageFactory.INSTANCE.getHumanIcon());
                break;
            }
            case 3: {
                imageIcon = new ImageIcon(ImageFactory.INSTANCE.getNetworkIcon());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ImageIcon icon = imageIcon;
        Image image = icon.getImage().getScaledInstance(45, 45, 45);
        JLabel imageLable = new JLabel(new ImageIcon(image));
        imageLable.setBorder(new EmptyBorder(0, 0, 0, 40));
        playerPanel.add((Component)imageLable, "West");
        this.playerDisplayGrid.add(playerPanel);
        this.playerDisplayGrid.revalidate();
        this.playerDisplayGrid.repaint();
        this.giveUpdatesToServer();
    }

    private final JButton getDisconnectButton(String name, PlayerType playerType) {
        JButton button = new JButton("X");
        button.setForeground(Color.white);
        button.setBackground(Color.red);
        button.setFont(new Font("Arial", 1, 30));
        button.setFocusPainted(false);
        button.setEnabled(true);
        button.addActionListener(arg_0 -> GameSettingsScreen.getDisconnectButton$lambda$7(playerType, this, name, arg_0));
        return button;
    }

    private final void editHumanButton() {
        this.addHumanButton.setBackground(new Color(230, 230, 230));
        this.addHumanButton.addActionListener(arg_0 -> GameSettingsScreen.editHumanButton$lambda$9(this, arg_0));
    }

    private final void editBotPlayingTimeField() {
        this.botPlayingTimeField.setText("5");
        this.editUserInputField(this.botPlayingTimeField);
    }

    private final void editExplosionTimeDecrementField() {
        this.explosionTimeDecrementField.setText("1");
        this.editUserInputField(this.explosionTimeDecrementField);
    }

    private final void editExplosionTimeDefaultField() {
        this.explosionTimeField.setText("100");
        this.editUserInputField(this.explosionTimeField);
    }

    private final void editUserInputField(JTextField field) {
        field.setFont(GuiConstantsKt.getUSER_INPUT_FONT());
        field.setBackground(GuiConstantsKt.getLIGHT_GRAY());
        field.setFocusable(this.mainServer != null);
    }

    private final void addPlayerDisplay() {
        this.playerDisplayGrid.setBackground(Color.white);
        this.playerDisplayGrid.setBorder(new EmptyBorder(10, 30, 10, 30));
    }

    private final void editNumberOfWalls() {
        this.numberOfWalls.setText("0");
        this.numberOfWalls.setFont(GuiConstantsKt.getUSER_INPUT_FONT());
        this.numberOfWalls.setBackground(GuiConstantsKt.getLIGHT_GRAY());
        this.numberOfWalls.addKeyListener(new AllInputVerifiers.NumberOfWallsKeyListener(this.numberOfWalls, this.xField, this.yField));
        this.numberOfWalls.setFocusable(this.mainServer != null);
    }

    private final void editYField() {
        this.yField.setText("6");
        this.yField.setFont(GuiConstantsKt.getUSER_INPUT_FONT());
        this.yField.setBackground(GuiConstantsKt.getLIGHT_GRAY());
        this.yField.addKeyListener(new AllInputVerifiers.BoardSizeVerifier(this.yField));
        this.yField.setFocusable(this.mainServer != null);
    }

    private final void editXField() {
        this.xField.setText("11");
        this.xField.setFont(GuiConstantsKt.getUSER_INPUT_FONT());
        this.xField.setBackground(GuiConstantsKt.getLIGHT_GRAY());
        this.xField.addKeyListener(new AllInputVerifiers.BoardSizeVerifier(this.xField));
        this.xField.setFocusable(this.mainServer != null);
    }

    private final void setIconImage(JFrame frame) {
        URL fileName = Main.class.getClassLoader().getResource("BombIcon.png");
        BufferedImage bombPictureIcon = ImageIO.read(fileName);
        frame.setIconImage(bombPictureIcon);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateNames(String name, PlayerType playerType, boolean isDisconnecting) {
        if (isDisconnecting) {
            Object v0;
            int index;
            block7: {
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.allPlayerNameFields.keySet();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JLabel jLabel = (JLabel)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getText());
                }
                index = ((List)destination$iv$iv).indexOf(name);
                $this$mapTo$iv$iv = this.allPlayerNameFields.entrySet();
                for (Object e : $this$mapTo$iv$iv) {
                    Map.Entry it = (Map.Entry)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(((JLabel)it.getKey()).getText(), name)) continue;
                    v0 = e;
                    break block7;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry != null) {
                Map.Entry it = entry;
                boolean bl = false;
                this.allPlayerNameFields.remove(it.getKey());
            }
            if (index >= 0) {
                this.playerDisplayGrid.remove(index);
                this.playerDisplayGrid.revalidate();
                this.playerDisplayGrid.repaint();
                Server server2 = this.mainServer;
                if (server2 != null) {
                    server2.removePlayerFromMap(name);
                }
                this.giveUpdatesToServer();
            }
        } else {
            this.addPlayer(name, playerType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void giveUpdatesToServer() {
        block1: {
            void $this$mapKeysTo$iv$iv;
            Map<JLabel, PlayerType> $this$mapKeys$iv = this.allPlayerNameFields;
            boolean $i$f$mapKeys = false;
            Map<JLabel, PlayerType> map2 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = ((JLabel)it.getKey()).getText();
                Map map4 = map3;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map4.put(string, entry);
            }
            Map namesOfPlayers = destination$iv$iv;
            Server server2 = this.mainServer;
            if (server2 == null) break block1;
            server2.handle(new GameSettingsUpdateEvent(namesOfPlayers));
        }
    }

    public final void updatePlayers(@NotNull Map<String, ? extends PlayerType> namesOfPlayers) {
        Intrinsics.checkNotNullParameter(namesOfPlayers, "namesOfPlayers");
        this.allPlayerNameFields.clear();
        this.playerDisplayGrid.removeAll();
        Map<String, ? extends PlayerType> $this$forEach$iv = namesOfPlayers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends PlayerType>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            ImageIcon imageIcon;
            Map.Entry<String, ? extends PlayerType> element$iv;
            Map.Entry<String, ? extends PlayerType> it = element$iv = iterator2.next();
            boolean bl = false;
            JLabel nameField = new JLabel(it.getKey());
            nameField.setFont(new Font("Arial", 0, 24));
            this.allPlayerNameFields.put(nameField, it.getValue());
            this.playerDisplayGrid.add(nameField);
            JPanel playerPanel = new JPanel(new BorderLayout());
            playerPanel.add((Component)nameField, "Center");
            switch (WhenMappings.$EnumSwitchMapping$0[it.getValue().ordinal()]) {
                case 1: {
                    imageIcon = new ImageIcon(ImageFactory.INSTANCE.getBotIcon());
                    break;
                }
                case 2: {
                    imageIcon = new ImageIcon(ImageFactory.INSTANCE.getHumanIcon());
                    break;
                }
                case 3: {
                    imageIcon = new ImageIcon(ImageFactory.INSTANCE.getNetworkIcon());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ImageIcon icon = imageIcon;
            Image image = icon.getImage().getScaledInstance(45, 45, 45);
            JLabel imageLable = new JLabel(new ImageIcon(image));
            imageLable.setBorder(new EmptyBorder(0, 0, 0, 40));
            playerPanel.add((Component)imageLable, "West");
            nameField.setOpaque(true);
            nameField.setBackground(Color.white);
            playerPanel.setBackground(Color.white);
            imageLable.setBackground(Color.white);
            playerPanel.add((Component)imageLable, "West");
            this.playerDisplayGrid.add(playerPanel);
            this.playerDisplayGrid.revalidate();
            this.playerDisplayGrid.repaint();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void addButtons$lambda$3$lambda$2(GameSettingsScreen this$0, Server $server, ActionEvent it) {
        boolean areRightAmountOfPlayers;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($server, "$server");
        int n = GameKt.getMAX_PLAYERS();
        int n2 = this$0.allPlayerNameFields.size();
        boolean bl = 2 <= n2 ? n2 <= n : (areRightAmountOfPlayers = false);
        if (AllInputVerifiers.INSTANCE.getInputsAreValid$chain_reaction() && areRightAmountOfPlayers) {
            Iterator iterator2;
            boolean bl2;
            Object $this$any$iv;
            block8: {
                $this$any$iv = this$0.allPlayerNameFields.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        JLabel it2 = (JLabel)element$iv;
                        boolean bl3 = false;
                        String string = it2.getText();
                        Intrinsics.checkNotNullExpressionValue(string, "it.text");
                        if (!StringsKt.isBlank(string)) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) {
                void $this$mapKeysTo$iv$iv;
                void $this$mapKeys$iv;
                String string = this$0.explosionTimeField.getText();
                Intrinsics.checkNotNullExpressionValue(string, "explosionTimeField.text");
                int n3 = Integer.parseInt(string);
                String string2 = this$0.botPlayingTimeField.getText();
                Intrinsics.checkNotNullExpressionValue(string2, "botPlayingTimeField.text");
                int n4 = Integer.parseInt(string2);
                String string3 = this$0.explosionTimeDecrementField.getText();
                Intrinsics.checkNotNullExpressionValue(string3, "explosionTimeDecrementField.text");
                DelayerService.INSTANCE.bind(n3, n4, Integer.parseInt(string3));
                this$0.frame.getContentPane().removeAll();
                this$0.frame.repaint();
                $this$any$iv = this$0.allPlayerNameFields;
                GameSettingsScreenService gameSettingsScreenService = GameSettingsScreenService.INSTANCE;
                GameSettingsScreen gameSettingsScreen = this$0;
                JFrame jFrame = this$0.frame;
                Server server2 = $server;
                boolean $i$f$mapKeys = false;
                iterator2 = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                Iterator iterator3 = $this$associateByTo$iv$iv$iv.iterator();
                while (true) {
                    String string4;
                    void it$iv$iv;
                    Map map2;
                    if (!iterator3.hasNext()) {
                        map2 = destination$iv$iv;
                        server2.createGame(jFrame, gameSettingsScreen.getBoardData(gameSettingsScreenService.createAllPlayers(map2)));
                        return;
                    }
                    Object element$iv$iv$iv = iterator3.next();
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue(((JLabel)entry.getKey()).getText(), "it.key.text");
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map3 = map2;
                    boolean bl5 = false;
                    Object v = it$iv$iv.getValue();
                    map3.put(string4, v);
                }
            }
        }
        if (!areRightAmountOfPlayers) {
            JOptionPane.showMessageDialog(null, "Total of players amount can't be lower than 2!", "InputMismatch", 0);
            return;
        }
        if (AllInputVerifiers.INSTANCE.getInputsAreValid$chain_reaction()) return;
        JOptionPane.showMessageDialog(null, "Some Inputs are not valid!", "InputMismatch", 0);
    }

    private static final void addButtons$lambda$4(ActionEvent it) {
        System.exit(130);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void editBotButton$lambda$6(GameSettingsScreen this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.allPlayerNameFields.size() < 5) {
            boolean bl;
            String newName;
            block6: {
                newName = this$0.nameInputField.getText();
                Iterable $this$any$iv = this$0.allPlayerNameFields.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JLabel it2 = (JLabel)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it2.getText(), newName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                Intrinsics.checkNotNullExpressionValue(newName, "newName");
                this$0.addPlayer(newName, PlayerType.BOT);
            } else {
                this$0.nameInputField.setForeground(Color.red);
            }
        }
    }

    private static final void getDisconnectButton$lambda$7(PlayerType $playerType, GameSettingsScreen this$0, String $name, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$playerType, "$playerType");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($name, "$name");
        if ($playerType == PlayerType.NETWORK) {
            BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $name, null){
                int label;
                final /* synthetic */ GameSettingsScreen this$0;
                final /* synthetic */ String $name;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            Server server2 = GameSettingsScreen.access$getMainServer$p(this.this$0);
                            if (server2 == null) break;
                            this.label = 1;
                            Object object3 = server2.forceDisconnect(this.$name, this);
                            if (object3 == object2) {
                                return object2;
                            }
                            break;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            break;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
        this$0.updateNames($name, $playerType, true);
    }

    private static final void editHumanButton$lambda$9(GameSettingsScreen this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.allPlayerNameFields.size() < 5) {
            boolean bl;
            String newName;
            block6: {
                newName = this$0.nameInputField.getText();
                Iterable $this$any$iv = this$0.allPlayerNameFields.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JLabel it2 = (JLabel)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it2.getText(), newName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                Intrinsics.checkNotNullExpressionValue(newName, "newName");
                this$0.addPlayer(newName, PlayerType.HUMAN);
            } else {
                this$0.nameInputField.setForeground(Color.red);
            }
        }
    }

    public static final /* synthetic */ void access$updateNames(GameSettingsScreen $this, String name, PlayerType playerType, boolean isDisconnecting) {
        $this.updateNames(name, playerType, isDisconnecting);
    }

    public static final /* synthetic */ Map access$getAllPlayerNameFields$p(GameSettingsScreen $this) {
        return $this.allPlayerNameFields;
    }

    public static final /* synthetic */ JTextField access$getNameInputField$p(GameSettingsScreen $this) {
        return $this.nameInputField;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lview/GameSettingsScreen$FrameListener;", "Ljava/awt/event/ComponentAdapter;", "(Lview/GameSettingsScreen;)V", "componentResized", "", "e", "Ljava/awt/event/ComponentEvent;", "chain-reaction"})
    public final class FrameListener
    extends ComponentAdapter {
        @Override
        public void componentResized(@NotNull ComponentEvent e) {
            Intrinsics.checkNotNullParameter(e, "e");
            GameSettingsScreen.this.frameWith = e.getComponent().getWidth();
            if (GameSettingsScreen.this.mainServer != null) {
                GameSettingsScreen.this.allSettingsPane.setDividerLocation(GameSettingsScreen.this.frameWith - 300);
                GameSettingsScreen.this.allSettingsPane.repaint();
            } else {
                GameSettingsScreen.this.allSettingsPane.setDividerLocation(GameSettingsScreen.this.frameWith);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerType.values().length];
            try {
                nArray[PlayerType.BOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerType.HUMAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerType.NETWORK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

