/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import model.board.Board;
import model.board.BombToUpdate;
import model.board.Game;
import model.board.Position;
import model.figure.Bomb;
import model.figure.EmptyFigure;
import model.figure.Level;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import service.BoardExtensionsKt;
import service.BoardService;
import service.BombService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0014\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lservice/GameService;", "", "()V", "explode", "", "game", "Lmodel/board/Game;", "position", "Lmodel/board/Position;", "positionsForPlacing", "Ljava/util/Queue;", "handlePlaceBombAndExplosions", "", "Lmodel/board/BombToUpdate;", "fromPosition", "startNextRound", "updateBomb", "Lmodel/figure/Bomb;", "winner", "Lmodel/player/Player;", "addNeighbours", "board", "Lmodel/board/Board;", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nGameService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameService.kt\nservice/GameService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1#2:86\n1855#3,2:87\n*S KotlinDebug\n*F\n+ 1 GameService.kt\nservice/GameService\n*L\n78#1:87,2\n*E\n"})
public final class GameService {
    @NotNull
    public static final GameService INSTANCE = new GameService();

    private GameService() {
    }

    @Nullable
    public final Player winner(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        Player currentPlayer = game.getCurrent();
        Map<Player, Integer> bombCountByPlayer = BoardService.INSTANCE.countBombs(game.getBoard());
        boolean otherPlayersHaveNoBombs = bombCountByPlayer.size() == 1 && bombCountByPlayer.get(currentPlayer) != null;
        return otherPlayersHaveNoBombs && game.getRoundCounter() >= game.getPlayers().size() ? currentPlayer : null;
    }

    @NotNull
    public final List<BombToUpdate> handlePlaceBombAndExplosions(@NotNull Game game, @NotNull Position fromPosition) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(fromPosition, "fromPosition");
        List bombsToUpdate = new ArrayList();
        Queue positionsForPlacing = new LinkedList();
        positionsForPlacing.add(fromPosition);
        while (!((Collection)positionsForPlacing).isEmpty() && this.winner(game) == null) {
            Position position = (Position)positionsForPlacing.poll();
            Board board = game.getBoard();
            Intrinsics.checkNotNullExpressionValue(position, "position");
            if (BoardExtensionsKt.isWall(board, position)) continue;
            Bomb bomb = this.updateBomb(game, position);
            Object object = bomb;
            if (object != null && (object = object.getLevel()) != null) {
                Object it = object;
                boolean bl = false;
                if (game.getCurrent() != null) {
                    Player it1;
                    boolean bl2 = false;
                    BombToUpdate it2 = new BombToUpdate(it1, (Level)((Object)it), position);
                    boolean bl3 = false;
                    bombsToUpdate.add(it2);
                }
            }
            Bomb bomb2 = bomb;
            boolean bl = bomb2 != null ? bomb2.isAboutToExplode() : false;
            if (!bl) continue;
            this.explode(game, position, positionsForPlacing);
        }
        return bombsToUpdate;
    }

    private final void explode(Game game, Position position, Queue<Position> positionsForPlacing) {
        game.getBoard().setFigure(position, EmptyFigure.INSTANCE);
        this.addNeighbours(positionsForPlacing, game.getBoard(), position);
    }

    private final Bomb updateBomb(Game game, Position position) {
        Bomb newBomb;
        block2: {
            Bomb bomb;
            Player player = game.getCurrent();
            if (player != null) {
                Player it = player;
                boolean bl = false;
                bomb = BombService.INSTANCE.updateBomb(it, game.getBoard(), position);
            } else {
                bomb = null;
            }
            Bomb bomb2 = newBomb = bomb;
            if (bomb2 == null) break block2;
            Bomb it = bomb2;
            boolean bl = false;
            game.getBoard().setFigure(position, it);
        }
        return newBomb;
    }

    public final void startNextRound(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        game.startNextRound();
        Map<Player, Integer> playerBombCounterMap = BoardService.INSTANCE.countBombs(game.getBoard());
        while (playerBombCounterMap.get(game.getCurrent()) == null && game.getRoundCounter() >= game.getPlayers().size()) {
            game.startNextRound();
        }
    }

    private final void addNeighbours(Queue<Position> $this$addNeighbours, Board board, Position position) {
        List<Position> neighbourPositions = position.getNeighbours(board.getDimension());
        Iterable $this$forEach$iv = neighbourPositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Position currentPosition = (Position)element$iv;
            boolean bl = false;
            $this$addNeighbours.offer(currentPosition);
        }
    }
}

