/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import model.board.Game;
import model.board.Position;
import model.event.BombsToUpdateEvent;
import model.player.Bot;
import model.player.Human;
import model.player.Network;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import service.BoardService;
import service.DelayerService;
import service.GameService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J\"\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a8\u0006\u0010"}, d2={"Lservice/GameProgressService;", "", "()V", "play", "Lmodel/player/Player;", "game", "Lmodel/board/Game;", "clickedPosition", "Lmodel/board/Position;", "updateAll", "Lkotlin/Function1;", "Lmodel/event/BombsToUpdateEvent;", "", "playOnClick", "position", "start", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nGameProgressService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameProgressService.kt\nservice/GameProgressService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class GameProgressService {
    @NotNull
    public static final GameProgressService INSTANCE = new GameProgressService();

    private GameProgressService() {
    }

    public final void start(@NotNull Game game, @NotNull Function1<? super BombsToUpdateEvent, Unit> updateAll) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(updateAll, "updateAll");
        if (game.getPlayers().get(0) instanceof Bot) {
            Object v0;
            block3: {
                Iterable iterable = game.getPlayers();
                for (Object t : iterable) {
                    Player it = (Player)t;
                    boolean bl = false;
                    if (!(it instanceof Human || it instanceof Network)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if (v0 != null) {
                this.play(game, BoardService.INSTANCE.getRandomValidNextPosition(game), updateAll);
            }
        }
    }

    @Nullable
    public final Player play(@NotNull Game game, @NotNull Position clickedPosition, @NotNull Function1<? super BombsToUpdateEvent, Unit> updateAll) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(clickedPosition, "clickedPosition");
        Intrinsics.checkNotNullParameter(updateAll, "updateAll");
        Player winner2 = null;
        do {
            Position position;
            if (game.getCurrent() instanceof Bot) {
                DelayerService.INSTANCE.botDelay();
                position = BoardService.INSTANCE.getRandomValidNextPosition(game);
            } else {
                position = clickedPosition;
            }
            Position position2 = position;
            BombsToUpdateEvent newUpdate = this.playOnClick(game, position2);
            updateAll.invoke(newUpdate);
            winner2 = GameService.INSTANCE.winner(game);
        } while (game.getCurrent() instanceof Bot && winner2 == null);
        return winner2;
    }

    private final BombsToUpdateEvent playOnClick(Game game, Position position) {
        List<Object> bombToUpdateList = CollectionsKt.emptyList();
        if (BoardService.INSTANCE.isValidForNextAction(game, position)) {
            bombToUpdateList = GameService.INSTANCE.handlePlaceBombAndExplosions(game, position);
            GameService.INSTANCE.startNextRound(game);
        }
        return new BombsToUpdateEvent(bombToUpdateList, game.getCurrent(), false, false, null, 28, null);
    }
}

