/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.Comparator;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.requests.ClassRequest;
import org.junit.internal.requests.FilterRequest;
import org.junit.internal.requests.OrderingRequest;
import org.junit.internal.requests.SortingRequest;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Ordering;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Request {
    public static Request method(Class<?> clazz, String methodName) {
        Description method2 = Description.createTestDescription(clazz, methodName);
        return Request.aClass(clazz).filterWith(method2);
    }

    public static Request aClass(Class<?> clazz) {
        return new ClassRequest(clazz);
    }

    public static Request classWithoutSuiteMethod(Class<?> clazz) {
        return new ClassRequest(clazz, false);
    }

    public static Request classes(Computer computer, Class<?> ... classes2) {
        try {
            AllDefaultPossibilitiesBuilder builder2 = new AllDefaultPossibilitiesBuilder();
            Runner suite = computer.getSuite(builder2, classes2);
            return Request.runner(suite);
        }
        catch (InitializationError e) {
            return Request.runner(new ErrorReportingRunner(e, classes2));
        }
    }

    public static Request classes(Class<?> ... classes2) {
        return Request.classes(JUnitCore.defaultComputer(), classes2);
    }

    public static Request errorReport(Class<?> klass, Throwable cause) {
        return Request.runner(new ErrorReportingRunner(klass, cause));
    }

    public static Request runner(final Runner runner) {
        return new Request(){

            public Runner getRunner() {
                return runner;
            }
        };
    }

    public abstract Runner getRunner();

    public Request filterWith(Filter filter2) {
        return new FilterRequest(this, filter2);
    }

    public Request filterWith(Description desiredDescription) {
        return this.filterWith(Filter.matchMethodDescription(desiredDescription));
    }

    public Request sortWith(Comparator<Description> comparator2) {
        return new SortingRequest(this, comparator2);
    }

    public Request orderWith(Ordering ordering) {
        return new OrderingRequest(this, ordering);
    }
}

