/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.config;

import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

@API(status=API.Status.EXPERIMENTAL, since="1.3")
public class PrefixedConfigurationParameters
implements ConfigurationParameters {
    private final ConfigurationParameters delegate;
    private final String prefix;

    public PrefixedConfigurationParameters(ConfigurationParameters delegate2, String prefix) {
        this.delegate = Preconditions.notNull(delegate2, "delegate must not be null");
        this.prefix = Preconditions.notBlank(prefix, "prefix must not be null or blank");
    }

    @Override
    public Optional<String> get(String key2) {
        return this.delegate.get(this.prefixed(key2));
    }

    @Override
    public Optional<Boolean> getBoolean(String key2) {
        return this.delegate.getBoolean(this.prefixed(key2));
    }

    @Override
    public <T> Optional<T> get(String key2, Function<String, T> transformer) {
        return this.delegate.get(this.prefixed(key2), transformer);
    }

    private String prefixed(String key2) {
        return this.prefix + key2;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

