/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.record;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.BooleanString;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.Format;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.AnnotationHelper;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Context;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataProcessingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.NormalizedString;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldConversionMapping;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSet;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.record.MetaData;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.record.RecordMetaData;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.Conversion;

class RecordMetaDataImpl<C extends Context>
implements RecordMetaData {
    final C context;
    private Map<Class, Conversion> conversionByType = new HashMap<Class, Conversion>();
    private Map<Class, Map<Annotation, Conversion>> conversionsByAnnotation = new HashMap<Class, Map<Annotation, Conversion>>();
    private Map<Integer, Annotation> annotationHashes = new HashMap<Integer, Annotation>();
    private MetaData[] indexMap;
    private FieldConversionMapping conversions = null;

    RecordMetaDataImpl(C context) {
        this.context = context;
    }

    private MetaData getMetaData(String name) {
        int index = this.context.indexOf(name);
        if (index == -1) {
            this.getValidatedHeaders();
            throw new IllegalArgumentException("Header name '" + name + "' not found. Available columns are: " + Arrays.asList(this.selectedHeaders()));
        }
        return this.getMetaData(index);
    }

    private NormalizedString[] getValidatedHeaders() {
        NormalizedString[] headers2 = NormalizedString.toIdentifierGroupArray(this.context.headers());
        if (headers2 == null || headers2.length == 0) {
            throw new IllegalStateException("No headers parsed from input nor provided in the user settings. Only index-based operations are available.");
        }
        return headers2;
    }

    private MetaData getMetaData(Enum<?> column) {
        NormalizedString[] headers2 = NormalizedString.toIdentifierGroupArray(this.context.headers());
        if (headers2 == null || headers2.length == 0) {
            throw new IllegalStateException("No headers parsed from input nor provided in the user settings. Only index-based operations are available.");
        }
        return this.getMetaData(this.context.indexOf(column));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData getMetaData(int index) {
        if (this.indexMap == null || this.indexMap.length < index + 1 || this.indexMap[index] == null) {
            RecordMetaDataImpl recordMetaDataImpl = this;
            synchronized (recordMetaDataImpl) {
                if (this.indexMap == null || this.indexMap.length < index + 1 || this.indexMap[index] == null) {
                    int startFrom = 0;
                    int lastIndex = index;
                    if (this.indexMap != null) {
                        startFrom = this.indexMap.length;
                        this.indexMap = Arrays.copyOf(this.indexMap, index + 1);
                    } else {
                        int[] indexes;
                        String[] headers2 = this.context.headers();
                        if (headers2 != null && lastIndex < headers2.length) {
                            lastIndex = headers2.length;
                        }
                        if ((indexes = this.context.extractedFieldIndexes()) != null) {
                            for (int i2 = 0; i2 < indexes.length; ++i2) {
                                if (lastIndex >= indexes[i2]) continue;
                                lastIndex = indexes[i2];
                            }
                        }
                        this.indexMap = new MetaData[lastIndex + 1];
                    }
                    for (int i3 = startFrom; i3 < lastIndex + 1; ++i3) {
                        this.indexMap[i3] = new MetaData(i3);
                    }
                }
            }
        }
        return this.indexMap[index];
    }

    @Override
    public int indexOf(Enum<?> column) {
        return this.getMetaData(column).index;
    }

    MetaData metadataOf(String headerName) {
        return this.getMetaData(headerName);
    }

    MetaData metadataOf(Enum<?> column) {
        return this.getMetaData(column);
    }

    MetaData metadataOf(int columnIndex) {
        return this.getMetaData(columnIndex);
    }

    @Override
    public int indexOf(String headerName) {
        return this.getMetaData((String)headerName).index;
    }

    @Override
    public Class<?> typeOf(Enum<?> column) {
        return this.getMetaData(column).type;
    }

    @Override
    public Class<?> typeOf(String headerName) {
        return this.getMetaData((String)headerName).type;
    }

    @Override
    public Class<?> typeOf(int columnIndex) {
        return this.getMetaData((int)columnIndex).type;
    }

    @Override
    public <T> void setDefaultValueOfColumns(T defaultValue, Enum<?> ... columns) {
        for (Enum<?> column : columns) {
            this.getMetaData(column).defaultValue = defaultValue;
        }
    }

    @Override
    public <T> void setDefaultValueOfColumns(T defaultValue, String ... headerNames) {
        for (String headerName : headerNames) {
            this.getMetaData((String)headerName).defaultValue = defaultValue;
        }
    }

    @Override
    public <T> void setDefaultValueOfColumns(T defaultValue, int ... columnIndexes) {
        for (int columnIndex : columnIndexes) {
            this.getMetaData((int)columnIndex).defaultValue = defaultValue;
        }
    }

    @Override
    public Object defaultValueOf(Enum<?> column) {
        return this.getMetaData(column).defaultValue;
    }

    @Override
    public Object defaultValueOf(String headerName) {
        return this.getMetaData((String)headerName).defaultValue;
    }

    @Override
    public Object defaultValueOf(int columnIndex) {
        return this.getMetaData((int)columnIndex).defaultValue;
    }

    private FieldConversionMapping getConversions() {
        if (this.conversions == null) {
            this.conversions = new FieldConversionMapping();
        }
        return this.conversions;
    }

    @Override
    public <T extends Enum<T>> FieldSet<T> convertFields(Class<T> enumType, Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldEnums(conversions);
    }

    @Override
    public FieldSet<String> convertFields(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldNames(conversions);
    }

    @Override
    public FieldSet<Integer> convertIndexes(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldIndexes(conversions);
    }

    @Override
    public String[] headers() {
        return this.context.headers();
    }

    @Override
    public String[] selectedHeaders() {
        return this.context.selectedHeaders();
    }

    String getValue(String[] data2, String headerName) {
        MetaData md = this.metadataOf(headerName);
        if (md.index >= data2.length) {
            return null;
        }
        return data2[md.index];
    }

    String getValue(String[] data2, int columnIndex) {
        MetaData md = this.metadataOf(columnIndex);
        return data2[md.index];
    }

    String getValue(String[] data2, Enum<?> column) {
        MetaData md = this.metadataOf(column);
        return data2[md.index];
    }

    private <T> T convert(MetaData md, String[] data2, Class<T> expectedType, Conversion[] conversions) {
        return expectedType.cast(RecordMetaDataImpl.convert(md, data2, conversions));
    }

    private Object convert(MetaData md, String[] data2, Object defaultValue, Conversion[] conversions) {
        Object out2 = RecordMetaDataImpl.convert(md, data2, conversions);
        return out2 == null ? defaultValue : out2;
    }

    private static Object convert(MetaData md, String[] data2, Conversion[] conversions) {
        String out2 = data2[md.index];
        for (int i2 = 0; i2 < conversions.length; ++i2) {
            out2 = conversions[i2].execute(out2);
        }
        return out2;
    }

    <T> T getValue(String[] data2, String headerName, T defaultValue, Conversion[] conversions) {
        return (T)this.convert(this.metadataOf(headerName), data2, defaultValue, conversions);
    }

    <T> T getValue(String[] data2, int columnIndex, T defaultValue, Conversion[] conversions) {
        return (T)this.convert(this.metadataOf(columnIndex), data2, defaultValue, conversions);
    }

    <T> T getValue(String[] data2, Enum<?> column, T defaultValue, Conversion[] conversions) {
        return (T)this.convert(this.metadataOf(column), data2, defaultValue, conversions);
    }

    <T> T getValue(String[] data2, String headerName, Class<T> expectedType, Conversion[] conversions) {
        return this.convert(this.metadataOf(headerName), data2, expectedType, conversions);
    }

    <T> T getValue(String[] data2, int columnIndex, Class<T> expectedType, Conversion[] conversions) {
        return this.convert(this.metadataOf(columnIndex), data2, expectedType, conversions);
    }

    <T> T getValue(String[] data2, Enum<?> column, Class<T> expectedType, Conversion[] conversions) {
        return this.convert(this.metadataOf(column), data2, expectedType, conversions);
    }

    private <T> T convert(MetaData md, String[] data2, Class<T> type2, T defaultValue, Annotation annotation) {
        Object out2;
        Object object = out2 = md.index < data2.length ? data2[md.index] : null;
        if (out2 == null) {
            Object object2 = out2 = defaultValue == null ? md.defaultValue : defaultValue;
        }
        if (annotation == null) {
            this.initializeMetadataConversions(data2, md);
            out2 = md.convert(out2);
            if (out2 == null) {
                Object object3 = out2 = defaultValue == null ? md.defaultValue : defaultValue;
            }
        }
        if (type2 != null) {
            Conversion conversion;
            if (out2 != null && type2.isAssignableFrom(out2.getClass())) {
                return (T)out2;
            }
            if (annotation == null) {
                conversion = this.conversionByType.get(type2);
                if (conversion == null) {
                    conversion = AnnotationHelper.getDefaultConversion(type2, null, null);
                    this.conversionByType.put(type2, conversion);
                }
            } else {
                Map<Annotation, Conversion> m = this.conversionsByAnnotation.get(type2);
                if (m == null) {
                    m = new HashMap<Annotation, Conversion>();
                    this.conversionsByAnnotation.put(type2, m);
                }
                if ((conversion = m.get(annotation)) == null) {
                    conversion = AnnotationHelper.getConversion(type2, annotation);
                    m.put(annotation, conversion);
                }
            }
            if (conversion == null) {
                if (type2 == String.class) {
                    if (out2 == null) {
                        return null;
                    }
                    return (T)(md.index < data2.length ? data2[md.index] : null);
                }
                String message2 = "";
                if (type2 == Date.class || type2 == Calendar.class) {
                    message2 = ". Need to specify format for date";
                }
                DataProcessingException exception = new DataProcessingException("Cannot convert '{value}' to " + type2.getName() + message2);
                exception.setValue(out2);
                exception.setErrorContentLength(this.context.errorContentLength());
                throw exception;
            }
            out2 = conversion.execute(out2);
        }
        if (type2 == null) {
            return (T)out2;
        }
        try {
            return type2.cast(out2);
        }
        catch (ClassCastException e) {
            DataProcessingException exception = new DataProcessingException("Cannot cast value '{value}' of type " + out2.getClass().toString() + " to " + type2.getName());
            exception.setValue(out2);
            exception.setErrorContentLength(this.context.errorContentLength());
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMetadataConversions(String[] data2, MetaData md) {
        if (this.conversions != null) {
            RecordMetaDataImpl recordMetaDataImpl = this;
            synchronized (recordMetaDataImpl) {
                String[] headers2 = this.headers();
                if (headers2 == null) {
                    headers2 = data2;
                }
                this.conversions.prepareExecution(false, headers2);
                md.setDefaultConversions(this.conversions.getConversions(md.index, md.type));
            }
        }
    }

    <T> T getObjectValue(String[] data2, String headerName, Class<T> type2, T defaultValue) {
        return this.convert(this.metadataOf(headerName), data2, type2, defaultValue, null);
    }

    <T> T getObjectValue(String[] data2, int columnIndex, Class<T> type2, T defaultValue) {
        return this.convert(this.metadataOf(columnIndex), data2, type2, defaultValue, null);
    }

    <T> T getObjectValue(String[] data2, Enum<?> column, Class<T> type2, T defaultValue) {
        return this.convert(this.metadataOf(column), data2, type2, defaultValue, null);
    }

    <T> T getObjectValue(String[] data2, String headerName, Class<T> type2, T defaultValue, String format, String ... formatOptions) {
        if (format == null) {
            return this.getObjectValue(data2, headerName, type2, defaultValue);
        }
        return this.convert(this.metadataOf(headerName), data2, type2, defaultValue, this.buildAnnotation(type2, format, formatOptions));
    }

    <T> T getObjectValue(String[] data2, int columnIndex, Class<T> type2, T defaultValue, String format, String ... formatOptions) {
        if (format == null) {
            return this.getObjectValue(data2, columnIndex, type2, defaultValue);
        }
        return this.convert(this.metadataOf(columnIndex), data2, type2, defaultValue, this.buildAnnotation(type2, format, formatOptions));
    }

    <T> T getObjectValue(String[] data2, Enum<?> column, Class<T> type2, T defaultValue, String format, String ... formatOptions) {
        if (format == null) {
            return this.getObjectValue(data2, column, type2, defaultValue);
        }
        return this.convert(this.metadataOf(column), data2, type2, defaultValue, this.buildAnnotation(type2, format, formatOptions));
    }

    static Annotation buildBooleanStringAnnotation(final String[] trueStrings, final String[] falseStrings) {
        return new BooleanString(){

            @Override
            public String[] trueStrings() {
                return trueStrings == null ? ArgumentUtils.EMPTY_STRING_ARRAY : trueStrings;
            }

            @Override
            public String[] falseStrings() {
                return falseStrings == null ? ArgumentUtils.EMPTY_STRING_ARRAY : falseStrings;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return BooleanString.class;
            }
        };
    }

    private static Annotation newFormatAnnotation(final String format, final String ... formatOptions) {
        return new Format(){

            @Override
            public String[] formats() {
                return new String[]{format};
            }

            @Override
            public String[] options() {
                return formatOptions;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Format.class;
            }
        };
    }

    <T> Annotation buildAnnotation(Class<T> type2, String args1, String ... args2) {
        Integer hash = type2.hashCode() * 31 + String.valueOf(args1).hashCode() + 31 * Arrays.toString(args2).hashCode();
        Annotation out2 = this.annotationHashes.get(hash);
        if (out2 == null) {
            if (type2 == Boolean.class || type2 == Boolean.TYPE) {
                String[] stringArray;
                if (args1 == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = args1;
                }
                out2 = RecordMetaDataImpl.buildBooleanStringAnnotation(stringArray, args2);
            } else {
                out2 = RecordMetaDataImpl.newFormatAnnotation(args1, args2);
            }
            this.annotationHashes.put(hash, out2);
        }
        return out2;
    }

    @Override
    public void setTypeOfColumns(Class<?> type2, Enum ... columns) {
        for (int i2 = 0; i2 < columns.length; ++i2) {
            this.getMetaData(columns[i2]).type = type2;
        }
    }

    @Override
    public void setTypeOfColumns(Class<?> type2, String ... headerNames) {
        for (int i2 = 0; i2 < headerNames.length; ++i2) {
            this.getMetaData((String)headerNames[i2]).type = type2;
        }
    }

    @Override
    public void setTypeOfColumns(Class<?> type2, int ... columnIndexes) {
        for (int i2 = 0; i2 < columnIndexes.length; ++i2) {
            this.getMetaData((int)columnIndexes[i2]).type = type2;
        }
    }

    @Override
    public boolean containsColumn(String headerName) {
        if (headerName == null) {
            return false;
        }
        return this.context.indexOf(headerName) != -1;
    }
}

