/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.input;

import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.ExpandingCharAppender;

public class ElasticCharAppender
extends ExpandingCharAppender {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private int defaultLength;

    public ElasticCharAppender(String emptyValue) {
        this(4096, emptyValue);
    }

    public ElasticCharAppender(int defaultLength, String emptyValue) {
        super(defaultLength, emptyValue, 0);
        this.defaultLength = defaultLength;
    }

    @Override
    public String getAndReset() {
        String out2 = super.getAndReset();
        if (this.chars.length > this.defaultLength) {
            this.chars = new char[this.defaultLength];
        }
        return out2;
    }

    @Override
    public char[] getCharsAndReset() {
        char[] out2 = super.getCharsAndReset();
        if (this.chars.length > this.defaultLength) {
            this.chars = new char[this.defaultLength];
        }
        return out2;
    }

    @Override
    public void reset() {
        if (this.chars.length > this.defaultLength) {
            this.chars = new char[this.defaultLength];
        }
        super.reset();
    }

    public String getTrimmedStringAndReset() {
        int start2;
        int length = this.index - this.whitespaceCount;
        for (start2 = 0; start2 < length && this.chars[start2] <= ' '; ++start2) {
        }
        if (start2 >= length) {
            return this.emptyValue;
        }
        while (this.chars[length - 1] <= ' ') {
            --length;
        }
        if ((length -= start2) <= 0) {
            return this.emptyValue;
        }
        String out2 = new String(this.chars, start2, length);
        this.reset();
        return out2;
    }

    public char[] getTrimmedCharsAndReset() {
        int start2;
        int length = this.index - this.whitespaceCount;
        for (start2 = 0; start2 < length && this.chars[start2] <= ' '; ++start2) {
        }
        if (start2 >= length) {
            return EMPTY_CHAR_ARRAY;
        }
        while (this.chars[length - 1] <= ' ') {
            --length;
        }
        if ((length -= start2) <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] out2 = new char[length];
        System.arraycopy(this.chars, start2, out2, 0, length);
        this.reset();
        return out2;
    }
}

