/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.NormalizedString;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSet;

public class FieldNameSelector
extends FieldSet<String>
implements FieldSelector,
Cloneable {
    public int getFieldIndex(String header) {
        return this.getFieldIndexes(new NormalizedString[]{NormalizedString.valueOf(header)})[0];
    }

    @Override
    public int[] getFieldIndexes(NormalizedString[] headers2) {
        if (headers2 == null) {
            return null;
        }
        Object[] normalizedHeader = headers2;
        ArrayList<NormalizedString> selection = NormalizedString.toArrayList(this.get());
        Object[] chosenFields = selection.toArray(new NormalizedString[0]);
        Object[] unknownFields = ArgumentUtils.findMissingElements(normalizedHeader, chosenFields);
        if (unknownFields.length > 0 && !selection.containsAll(Arrays.asList(normalizedHeader)) && unknownFields.length == chosenFields.length) {
            return new int[0];
        }
        int[] out2 = new int[selection.size()];
        Arrays.fill(out2, -1);
        int i2 = 0;
        for (NormalizedString chosenField : selection) {
            int[] indexes = ArgumentUtils.indexesOf(normalizedHeader, chosenField);
            if (indexes.length > 1) {
                out2 = Arrays.copyOf(out2, out2.length + indexes.length - 1);
            }
            if (indexes.length != 0) {
                for (int j = 0; j < indexes.length; ++j) {
                    out2[i2++] = indexes[j];
                }
                continue;
            }
            ++i2;
        }
        return out2;
    }

    @Override
    public int[] getFieldIndexes(String[] headers2) {
        return this.getFieldIndexes(NormalizedString.toIdentifierGroupArray(headers2));
    }
}

