/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.FieldMapping;

abstract class AbstractColumnMapping<K>
implements Cloneable {
    final String prefix;
    Map<K, Object> mapping;

    AbstractColumnMapping(String prefix, AbstractColumnMapping parent) {
        if (parent != null) {
            this.mapping = parent.mapping;
            this.prefix = parent.prefix.isEmpty() ? prefix : parent.prefix + '.' + prefix;
        } else {
            this.mapping = new LinkedHashMap<K, Object>();
            this.prefix = prefix;
        }
    }

    void mapToColumnName(K key2, String columnName) {
        this.mapping.put(key2, columnName);
    }

    void mapToColumn(K key2, Enum<?> column) {
        this.mapping.put(key2, column);
    }

    void mapToColumnIndex(K key2, int columnIndex) {
        this.mapping.put(key2, columnIndex);
    }

    void mapToColumnNames(Map<K, String> mappings) {
        this.mapping.putAll(mappings);
    }

    void mapToColumns(Map<K, Enum<?>> mappings) {
        this.mapping.putAll(mappings);
    }

    void mapToColumnIndexes(Map<K, Integer> mappings) {
        this.mapping.putAll(mappings);
    }

    boolean isMapped(K key2) {
        return this.getMappedColumn(key2) != null;
    }

    abstract K prefixKey(String var1, K var2);

    private Object getMappedColumn(K key2) {
        if (key2 == null) {
            return null;
        }
        key2 = this.prefixKey(this.prefix, key2);
        Object out2 = this.mapping.get(key2);
        return out2;
    }

    boolean updateFieldMapping(FieldMapping fieldMapping, K key2) {
        Object mappedColumn = this.getMappedColumn(key2);
        if (mappedColumn != null) {
            if (mappedColumn instanceof Enum) {
                mappedColumn = ((Enum)mappedColumn).name();
            }
            if (mappedColumn instanceof String) {
                fieldMapping.setFieldName((String)mappedColumn);
                fieldMapping.setIndex(-1);
                return true;
            }
            if (mappedColumn instanceof Integer) {
                fieldMapping.setIndex((Integer)mappedColumn);
                return true;
            }
            throw new IllegalStateException("Unexpected mapping of '" + key2 + "' to " + mappedColumn);
        }
        return false;
    }

    void extractPrefixes(Set<String> out2) {
        for (K key2 : this.mapping.keySet()) {
            String keyPrefix = this.getKeyPrefix(this.prefix, key2);
            if (keyPrefix == null) continue;
            out2.add(keyPrefix);
        }
    }

    abstract String getKeyPrefix(String var1, K var2);

    public AbstractColumnMapping<K> clone() {
        try {
            AbstractColumnMapping out2 = (AbstractColumnMapping)super.clone();
            out2.mapping = new LinkedHashMap<K, Object>(this.mapping);
            return out2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    abstract K findKey(String var1);

    void remove(String nameWithPrefix) {
        K key2;
        while ((key2 = this.findKey(nameWithPrefix)) != null) {
            if (this.mapping.remove(key2) != null) continue;
            return;
        }
    }
}

