/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.AbstractException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.CommonParserSettings;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.CommonSettings;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataProcessingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DefaultConversionProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DefaultParsingContext;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Format;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Internal;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.IterableResult;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.LineReader;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ParserOutput;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ParsingContext;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ProcessorErrorHandler;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.TextParsingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.AbstractCharInputReader;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.CharInputReader;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.DefaultCharInputReader;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.EOFException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.InputAnalysisProcess;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.LookaheadCharInputReader;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.iterators.RecordIterator;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.iterators.RowIterator;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.core.NoopProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.core.Processor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.record.Record;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.record.RecordMetaData;

public abstract class AbstractParser<T extends CommonParserSettings<?>> {
    protected final T settings;
    protected final ParserOutput output;
    private final long recordsToRead;
    protected final char comment;
    private final LineReader lineReader = new LineReader();
    protected ParsingContext context;
    protected Processor processor;
    protected CharInputReader input;
    protected char ch;
    private final ProcessorErrorHandler errorHandler;
    private final long rowsToSkip;
    protected final Map<Long, String> comments;
    protected String lastComment;
    private final boolean collectComments;
    private final int errorContentLength;
    private boolean extractingHeaders = false;
    private final boolean extractHeaders;
    protected final int whitespaceRangeStart;
    protected boolean ignoreTrailingWhitespace;
    protected boolean ignoreLeadingWhitespace;
    private final boolean processComments;

    public AbstractParser(T settings) {
        ((CommonSettings)settings).autoConfigure();
        this.settings = settings;
        this.errorContentLength = ((CommonSettings)settings).getErrorContentLength();
        this.ignoreTrailingWhitespace = ((CommonSettings)settings).getIgnoreTrailingWhitespaces();
        this.ignoreLeadingWhitespace = ((CommonSettings)settings).getIgnoreLeadingWhitespaces();
        this.output = new ParserOutput(this, (CommonParserSettings<?>)settings);
        this.processor = ((CommonParserSettings)settings).getProcessor();
        this.recordsToRead = ((CommonParserSettings)settings).getNumberOfRecordsToRead();
        this.comment = ((Format)((CommonSettings)settings).getFormat()).getComment();
        this.errorHandler = ((CommonSettings)settings).getProcessorErrorHandler();
        this.rowsToSkip = ((CommonParserSettings)settings).getNumberOfRowsToSkip();
        this.collectComments = ((CommonParserSettings)settings).isCommentCollectionEnabled();
        this.comments = this.collectComments ? new TreeMap() : Collections.emptyMap();
        this.extractHeaders = ((CommonParserSettings)settings).isHeaderExtractionEnabled();
        this.whitespaceRangeStart = ((CommonSettings)settings).getWhitespaceRangeStart();
        this.processComments = ((CommonParserSettings)settings).isCommentProcessingEnabled();
    }

    protected void processComment() {
        if (this.collectComments) {
            long line = this.input.lineCount();
            String comment = this.input.readComment();
            if (comment != null) {
                this.lastComment = comment;
                this.comments.put(line, this.lastComment);
            }
        } else {
            try {
                this.input.skipLines(1L);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse(Reader reader2) {
        this.beginParsing(reader2);
        try {
            while (!this.context.isStopped()) {
                String[] row;
                this.input.markRecordStart();
                this.ch = this.input.nextChar();
                if (this.processComments && this.inComment()) {
                    this.processComment();
                    continue;
                }
                if (this.output.pendingRecords.isEmpty()) {
                    this.parseRecord();
                }
                if ((row = this.output.rowParsed()) == null) continue;
                if (this.recordsToRead >= 0L && this.context.currentRecord() >= this.recordsToRead) {
                    this.context.stop();
                    if (this.recordsToRead == 0L) {
                        this.stopParsing();
                        return;
                    }
                }
                if (this.processor == NoopProcessor.instance) continue;
                this.rowProcessed(row);
            }
            this.stopParsing();
        }
        catch (EOFException ex) {
            try {
                this.handleEOF();
                while (!this.output.pendingRecords.isEmpty()) {
                    this.handleEOF();
                }
            }
            finally {
                this.stopParsing();
            }
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
        }
    }

    protected abstract void parseRecord();

    protected boolean consumeValueOnEOF() {
        return false;
    }

    private String[] handleEOF() {
        String[] row = null;
        try {
            boolean consumeValueOnEOF = this.consumeValueOnEOF();
            if (this.output.column != 0 || consumeValueOnEOF && !this.context.isStopped()) {
                if (this.output.appender.length() > 0 || consumeValueOnEOF) {
                    this.output.valueParsed();
                } else if (this.input.currentParsedContentLength() > 0) {
                    this.output.emptyParsed();
                }
                row = this.output.rowParsed();
            } else if (this.output.appender.length() > 0 || this.input.currentParsedContentLength() > 0) {
                if (this.output.appender.length() == 0) {
                    this.output.emptyParsed();
                } else {
                    this.output.valueParsed();
                }
                row = this.output.rowParsed();
            } else if (!this.output.pendingRecords.isEmpty()) {
                row = this.output.pendingRecords.poll();
            }
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
        if (row != null && this.processor != NoopProcessor.instance) {
            this.rowProcessed(row);
        }
        return row;
    }

    public final void beginParsing(Reader reader2) {
        this.output.reset();
        this.input = reader2 instanceof LineReader ? new DefaultCharInputReader(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparator(), ((Format)((CommonSettings)this.settings).getFormat()).getNormalizedNewline(), ((CommonParserSettings)this.settings).getInputBufferSize(), this.whitespaceRangeStart, true) : ((CommonParserSettings)this.settings).newCharInputReader(this.whitespaceRangeStart);
        this.input.enableNormalizeLineEndings(true);
        this.context = this.createParsingContext();
        if (this.processor instanceof DefaultConversionProcessor) {
            DefaultConversionProcessor conversionProcessor = (DefaultConversionProcessor)((Object)this.processor);
            conversionProcessor.errorHandler = this.errorHandler;
            conversionProcessor.context = this.context;
        }
        if (this.input instanceof AbstractCharInputReader) {
            AbstractCharInputReader inputReader = (AbstractCharInputReader)this.input;
            inputReader.addInputAnalysisProcess(this.getInputAnalysisProcess());
            for (InputAnalysisProcess p : ((CommonParserSettings)this.settings).getInputAnalysisProcesses()) {
                inputReader.addInputAnalysisProcess(p);
            }
        }
        try {
            this.input.start(reader2);
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
        this.input.skipLines(this.rowsToSkip);
        this.initialize();
        this.processor.processStarted(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extractHeadersIfRequired() {
        while (this.extractHeaders && this.output.parsedHeaders == null && !this.context.isStopped() && !this.extractingHeaders) {
            Processor userProvidedProcessor = this.processor;
            try {
                this.processor = NoopProcessor.instance;
                this.extractingHeaders = true;
                this.parseNext();
            }
            finally {
                this.extractingHeaders = false;
                this.processor = userProvidedProcessor;
            }
        }
    }

    protected ParsingContext createParsingContext() {
        DefaultParsingContext out2 = new DefaultParsingContext(this, this.errorContentLength);
        out2.stopped = false;
        return out2;
    }

    protected void initialize() {
    }

    protected InputAnalysisProcess getInputAnalysisProcess() {
        return null;
    }

    private String getParsedContent(CharSequence tmp) {
        return "Parsed content: " + AbstractException.restrictContent(this.errorContentLength, tmp);
    }

    private TextParsingException handleException(Throwable ex) {
        if (this.context != null) {
            this.context.stop();
        }
        if (ex instanceof DataProcessingException) {
            DataProcessingException error2 = (DataProcessingException)ex;
            error2.restrictContent(this.errorContentLength);
            error2.setContext(this.context);
            throw error2;
        }
        String message2 = ex.getClass().getName() + " - " + ex.getMessage();
        char[] chars = this.output.appender.getChars();
        if (chars != null) {
            String tmp;
            int length = this.output.appender.length();
            if (length > chars.length) {
                message2 = "Length of parsed input (" + length + ") exceeds the maximum number of characters defined in" + " your parser settings (" + ((CommonSettings)this.settings).getMaxCharsPerColumn() + "). ";
                length = chars.length;
            }
            if ((tmp = new String(chars)).contains("\n") || tmp.contains("\r")) {
                tmp = ArgumentUtils.displayLineSeparators(tmp, true);
                String lineSeparator = ArgumentUtils.displayLineSeparators(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparatorString(), false);
                message2 = message2 + "\nIdentified line separator characters in the parsed content. This may be the cause of the error. The line separator in your parser settings is set to '" + lineSeparator + "'. " + this.getParsedContent(tmp);
            }
            int nullCharacterCount = 0;
            int maxLength = length > 0x3FFFFFFF ? 0x3FFFFFFE : length;
            StringBuilder s = new StringBuilder(maxLength);
            for (int i2 = 0; i2 < maxLength; ++i2) {
                if (chars[i2] == '\u0000') {
                    s.append('\\');
                    s.append('0');
                    ++nullCharacterCount;
                    continue;
                }
                s.append(chars[i2]);
            }
            tmp = s.toString();
            if (nullCharacterCount > 0) {
                message2 = message2 + "\nIdentified " + nullCharacterCount + " null characters ('\u0000') on parsed content. This may " + "indicate the data is corrupt or its encoding is invalid. Parsed content:\n\t" + this.getParsedContent(tmp);
            }
        }
        if (ex instanceof ArrayIndexOutOfBoundsException) {
            try {
                int index = Integer.parseInt(ex.getMessage());
                if (index == ((CommonSettings)this.settings).getMaxCharsPerColumn()) {
                    message2 = message2 + "\nHint: Number of characters processed may have exceeded limit of " + index + " characters per column. Use settings.setMaxCharsPerColumn(int) to define the maximum number of characters a column can have";
                }
                if (index == ((CommonSettings)this.settings).getMaxColumns()) {
                    message2 = message2 + "\nHint: Number of columns processed may have exceeded limit of " + index + " columns. Use settings.setMaxColumns(int) to define the maximum number of columns your input can have";
                }
                message2 = message2 + "\nEnsure your configuration is correct, with delimiters, quotes and escape sequences that match the input format you are trying to parse";
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            if (!message2.isEmpty()) {
                message2 = message2 + "\n";
            }
            message2 = message2 + "Parser Configuration: " + ((CommonSettings)this.settings).toString();
        }
        catch (Exception t) {
            // empty catch block
        }
        if (this.errorContentLength == 0) {
            this.output.appender.reset();
        }
        TextParsingException out2 = new TextParsingException(this.context, message2, ex);
        out2.setErrorContentLength(this.errorContentLength);
        return out2;
    }

    private void stopParsing(Throwable error2) {
        if (error2 != null) {
            try {
                this.stopParsing();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (error2 instanceof DataProcessingException) {
                DataProcessingException ex = (DataProcessingException)error2;
                ex.setContext(this.context);
                throw ex;
            }
            if (error2 instanceof RuntimeException) {
                throw (RuntimeException)error2;
            }
            if (error2 instanceof Error) {
                throw (Error)error2;
            }
            throw new IllegalStateException(error2.getMessage(), error2);
        }
        this.stopParsing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopParsing() {
        try {
            this.ch = '\u0000';
            try {
                if (this.context != null) {
                    this.context.stop();
                }
            }
            finally {
                try {
                    if (this.processor != null) {
                        this.processor.processEnded(this.context);
                    }
                }
                finally {
                    if (this.output != null) {
                        this.output.appender.reset();
                    }
                    if (this.input != null) {
                        this.input.stop();
                    }
                }
            }
        }
        catch (Throwable error2) {
            throw this.handleException(error2);
        }
    }

    private <T> List<T> beginParseAll(boolean validateReader, Reader reader2, int expectedRowCount) {
        if (reader2 == null) {
            if (validateReader) {
                throw new IllegalStateException("Input reader must not be null");
            }
            if (this.context == null) {
                throw new IllegalStateException("Input not defined. Please call method 'beginParsing()' with a valid input.");
            }
            if (this.context.isStopped()) {
                return Collections.emptyList();
            }
        }
        ArrayList out2 = new ArrayList(expectedRowCount <= 0 ? 10000 : expectedRowCount);
        if (reader2 != null) {
            this.beginParsing(reader2);
        }
        return out2;
    }

    public List<String[]> parseAll(int expectedRowCount) {
        return this.internalParseAll(false, null, expectedRowCount);
    }

    public List<String[]> parseAll() {
        return this.internalParseAll(false, null, -1);
    }

    public List<Record> parseAllRecords(int expectedRowCount) {
        return this.internalParseAllRecords(false, null, expectedRowCount);
    }

    public List<Record> parseAllRecords() {
        return this.internalParseAllRecords(false, null, -1);
    }

    public final List<String[]> parseAll(Reader reader2) {
        return this.parseAll(reader2, 0);
    }

    public final List<String[]> parseAll(Reader reader2, int expectedRowCount) {
        return this.internalParseAll(true, reader2, expectedRowCount);
    }

    private final List<String[]> internalParseAll(boolean validateReader, Reader reader2, int expectedRowCount) {
        String[] row;
        List<String[]> out2 = this.beginParseAll(validateReader, reader2, expectedRowCount);
        while ((row = this.parseNext()) != null) {
            out2.add(row);
        }
        return out2;
    }

    protected boolean inComment() {
        return this.ch == this.comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] parseNext() {
        try {
            while (!this.context.isStopped()) {
                String[] row;
                this.input.markRecordStart();
                this.ch = this.input.nextChar();
                if (this.processComments && this.inComment()) {
                    this.processComment();
                    continue;
                }
                if (this.output.pendingRecords.isEmpty()) {
                    this.parseRecord();
                }
                if ((row = this.output.rowParsed()) != null) {
                    if (this.recordsToRead >= 0L && this.context.currentRecord() >= this.recordsToRead) {
                        this.context.stop();
                        if (this.recordsToRead == 0L) {
                            this.stopParsing();
                            return null;
                        }
                    }
                    if (this.processor != NoopProcessor.instance) {
                        this.rowProcessed(row);
                    }
                    return row;
                }
                if (!this.extractingHeaders) continue;
                return null;
            }
            if (this.output.column != 0) {
                return this.output.rowParsed();
            }
            this.stopParsing();
            return null;
        }
        catch (EOFException ex) {
            String[] row = this.handleEOF();
            if (this.output.pendingRecords.isEmpty()) {
                this.stopParsing();
            }
            return row;
        }
        catch (NullPointerException ex) {
            if (this.context == null) {
                throw new IllegalStateException("Cannot parse without invoking method beginParsing(Reader) first");
            }
            if (this.input != null) {
                this.stopParsing();
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
            return null;
        }
    }

    protected final void reloadHeaders() {
        this.output.initializeHeaders();
        if (this.context instanceof DefaultParsingContext) {
            ((DefaultParsingContext)this.context).reset();
        }
    }

    public final Record parseRecord(String line) {
        String[] values2 = this.parseLine(line);
        if (values2 == null) {
            return null;
        }
        return this.context.toRecord(values2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] parseLine(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        this.lineReader.setLine(line);
        if (this.context == null || this.context.isStopped()) {
            this.beginParsing(this.lineReader);
        } else if (this.input instanceof DefaultCharInputReader) {
            ((DefaultCharInputReader)this.input).reloadBuffer();
        } else if (this.input instanceof LookaheadCharInputReader) {
            ((LookaheadCharInputReader)this.input).reloadBuffer();
        }
        try {
            while (!this.context.isStopped()) {
                String[] row;
                this.input.markRecordStart();
                this.ch = this.input.nextChar();
                if (this.processComments && this.inComment()) {
                    this.processComment();
                    return null;
                }
                if (this.output.pendingRecords.isEmpty()) {
                    this.parseRecord();
                }
                if ((row = this.output.rowParsed()) == null) continue;
                if (this.processor != NoopProcessor.instance) {
                    this.rowProcessed(row);
                }
                return row;
            }
            return null;
        }
        catch (EOFException ex) {
            return this.handleEOF();
        }
        catch (NullPointerException ex) {
            if (this.input != null) {
                this.stopParsing(null);
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
            return null;
        }
    }

    private void rowProcessed(String[] row) {
        Internal.process(row, this.processor, this.context, this.errorHandler);
    }

    public final void parse(File file2) {
        this.parse(ArgumentUtils.newReader(file2));
    }

    public final void parse(File file2, String encoding) {
        this.parse(ArgumentUtils.newReader(file2, encoding));
    }

    public final void parse(File file2, Charset encoding) {
        this.parse(ArgumentUtils.newReader(file2, encoding));
    }

    public final void parse(InputStream input2) {
        this.parse(ArgumentUtils.newReader(input2));
    }

    public final void parse(InputStream input2, String encoding) {
        this.parse(ArgumentUtils.newReader(input2, encoding));
    }

    public final void parse(InputStream input2, Charset encoding) {
        this.parse(ArgumentUtils.newReader(input2, encoding));
    }

    public final void beginParsing(File file2) {
        this.beginParsing(ArgumentUtils.newReader(file2));
    }

    public final void beginParsing(File file2, String encoding) {
        this.beginParsing(ArgumentUtils.newReader(file2, encoding));
    }

    public final void beginParsing(File file2, Charset encoding) {
        this.beginParsing(ArgumentUtils.newReader(file2, encoding));
    }

    public final void beginParsing(InputStream input2) {
        this.beginParsing(ArgumentUtils.newReader(input2));
    }

    public final void beginParsing(InputStream input2, String encoding) {
        this.beginParsing(ArgumentUtils.newReader(input2, encoding));
    }

    public final void beginParsing(InputStream input2, Charset encoding) {
        this.beginParsing(ArgumentUtils.newReader(input2, encoding));
    }

    public final List<String[]> parseAll(File file2, int expectedRowCount) {
        return this.parseAll(ArgumentUtils.newReader(file2), expectedRowCount);
    }

    public final List<String[]> parseAll(File file2, String encoding, int expectedRowCount) {
        return this.parseAll(ArgumentUtils.newReader(file2, encoding), expectedRowCount);
    }

    public final List<String[]> parseAll(File file2, Charset encoding, int expectedRowCount) {
        return this.parseAll(ArgumentUtils.newReader(file2, encoding), expectedRowCount);
    }

    public final List<String[]> parseAll(InputStream input2, int expectedRowCount) {
        return this.parseAll(ArgumentUtils.newReader(input2), expectedRowCount);
    }

    public final List<String[]> parseAll(InputStream input2, String encoding, int expectedRowCount) {
        return this.parseAll(ArgumentUtils.newReader(input2, encoding), expectedRowCount);
    }

    public final List<String[]> parseAll(InputStream input2, Charset encoding, int expectedRowCount) {
        return this.parseAll(ArgumentUtils.newReader(input2, encoding), expectedRowCount);
    }

    public final List<String[]> parseAll(File file2) {
        return this.parseAll(ArgumentUtils.newReader(file2));
    }

    public final List<String[]> parseAll(File file2, String encoding) {
        return this.parseAll(ArgumentUtils.newReader(file2, encoding));
    }

    public final List<String[]> parseAll(File file2, Charset encoding) {
        return this.parseAll(ArgumentUtils.newReader(file2, encoding));
    }

    public final List<String[]> parseAll(InputStream input2) {
        return this.parseAll(ArgumentUtils.newReader(input2));
    }

    public final List<String[]> parseAll(InputStream input2, String encoding) {
        return this.parseAll(ArgumentUtils.newReader(input2, encoding));
    }

    public final List<String[]> parseAll(InputStream input2, Charset encoding) {
        return this.parseAll(ArgumentUtils.newReader(input2, encoding));
    }

    public final List<Record> parseAllRecords(File file2, int expectedRowCount) {
        return this.parseAllRecords(ArgumentUtils.newReader(file2), expectedRowCount);
    }

    public final List<Record> parseAllRecords(File file2, String encoding, int expectedRowCount) {
        return this.parseAllRecords(ArgumentUtils.newReader(file2, encoding), expectedRowCount);
    }

    public final List<Record> parseAllRecords(File file2, Charset encoding, int expectedRowCount) {
        return this.parseAllRecords(ArgumentUtils.newReader(file2, encoding), expectedRowCount);
    }

    public final List<Record> parseAllRecords(InputStream input2, int expectedRowCount) {
        return this.parseAllRecords(ArgumentUtils.newReader(input2), expectedRowCount);
    }

    public final List<Record> parseAllRecords(InputStream input2, String encoding, int expectedRowCount) {
        return this.parseAllRecords(ArgumentUtils.newReader(input2, encoding), expectedRowCount);
    }

    public final List<Record> parseAllRecords(InputStream input2, Charset encoding, int expectedRowCount) {
        return this.parseAllRecords(ArgumentUtils.newReader(input2, encoding), expectedRowCount);
    }

    public final List<Record> parseAllRecords(File file2) {
        return this.parseAllRecords(ArgumentUtils.newReader(file2));
    }

    public final List<Record> parseAllRecords(File file2, String encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(file2, encoding));
    }

    public final List<Record> parseAllRecords(File file2, Charset encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(file2, encoding));
    }

    public final List<Record> parseAllRecords(InputStream input2) {
        return this.parseAllRecords(ArgumentUtils.newReader(input2));
    }

    public final List<Record> parseAllRecords(InputStream input2, String encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(input2, encoding));
    }

    public final List<Record> parseAllRecords(InputStream input2, Charset encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(input2, encoding));
    }

    public final List<Record> parseAllRecords(Reader reader2, int expectedRowCount) {
        return this.internalParseAllRecords(true, reader2, expectedRowCount);
    }

    private List<Record> internalParseAllRecords(boolean validateReader, Reader reader2, int expectedRowCount) {
        Record record2;
        List<Record> out2 = this.beginParseAll(validateReader, reader2, expectedRowCount);
        if (this.context.isStopped()) {
            return out2;
        }
        while ((record2 = this.parseNextRecord()) != null) {
            out2.add(record2);
        }
        return out2;
    }

    public final List<Record> parseAllRecords(Reader reader2) {
        return this.parseAllRecords(reader2, 0);
    }

    public final Record parseNextRecord() {
        String[] row = this.parseNext();
        if (row != null) {
            return this.context.toRecord(row);
        }
        return null;
    }

    final Map<Long, String> getComments() {
        return this.comments;
    }

    final String getLastComment() {
        return this.lastComment;
    }

    final String[] getParsedHeaders() {
        this.extractHeadersIfRequired();
        return this.output.parsedHeaders;
    }

    public final ParsingContext getContext() {
        return this.context;
    }

    public final RecordMetaData getRecordMetadata() {
        if (this.context == null) {
            throw new IllegalStateException("Record metadata not available. The parser has not been started.");
        }
        return this.context.recordMetaData();
    }

    public final IterableResult<String[], ParsingContext> iterate(File input2, String encoding) {
        return this.iterate(input2, Charset.forName(encoding));
    }

    public final IterableResult<String[], ParsingContext> iterate(final File input2, final Charset encoding) {
        return new RowIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2, encoding);
            }
        };
    }

    public final IterableResult<String[], ParsingContext> iterate(final File input2) {
        return new RowIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2);
            }
        };
    }

    public final IterableResult<String[], ParsingContext> iterate(final Reader input2) {
        return new RowIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2);
            }
        };
    }

    public final IterableResult<String[], ParsingContext> iterate(InputStream input2, String encoding) {
        return this.iterate(input2, Charset.forName(encoding));
    }

    public final IterableResult<String[], ParsingContext> iterate(final InputStream input2, final Charset encoding) {
        return new RowIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2, encoding);
            }
        };
    }

    public final IterableResult<String[], ParsingContext> iterate(final InputStream input2) {
        return new RowIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2);
            }
        };
    }

    public final IterableResult<Record, ParsingContext> iterateRecords(File input2, String encoding) {
        return this.iterateRecords(input2, Charset.forName(encoding));
    }

    public final IterableResult<Record, ParsingContext> iterateRecords(final File input2, final Charset encoding) {
        return new RecordIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2, encoding);
            }
        };
    }

    public final IterableResult<Record, ParsingContext> iterateRecords(final File input2) {
        return new RecordIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2);
            }
        };
    }

    public final IterableResult<Record, ParsingContext> iterateRecords(final Reader input2) {
        return new RecordIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2);
            }
        };
    }

    public final IterableResult<Record, ParsingContext> iterateRecords(InputStream input2, String encoding) {
        return this.iterateRecords(input2, Charset.forName(encoding));
    }

    public final IterableResult<Record, ParsingContext> iterateRecords(final InputStream input2, final Charset encoding) {
        return new RecordIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2, encoding);
            }
        };
    }

    public final IterableResult<Record, ParsingContext> iterateRecords(final InputStream input2) {
        return new RecordIterator(this){

            @Override
            protected void beginParsing() {
                this.parser.beginParsing(input2);
            }
        };
    }
}

