/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumArgumentsProvider;
import org.junit.jupiter.params.provider.NullEnum;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@API(status=API.Status.STABLE, since="5.7")
@ArgumentsSource(value=EnumArgumentsProvider.class)
public @interface EnumSource {
    public Class<? extends Enum<?>> value() default NullEnum.class;

    public String[] names() default {};

    public Mode mode() default Mode.INCLUDE;

    public static enum Mode {
        INCLUDE(Mode::validateNames, (name, names2) -> names2.contains(name)),
        EXCLUDE(Mode::validateNames, (name, names2) -> !names2.contains(name)),
        MATCH_ALL(Mode::validatePatterns, (name, patterns) -> patterns.stream().allMatch(name::matches)),
        MATCH_ANY(Mode::validatePatterns, (name, patterns) -> patterns.stream().anyMatch(name::matches));

        private final Validator validator;
        private final BiPredicate<String, Set<String>> selector;

        private Mode(Validator validator, BiPredicate<String, Set<String>> selector) {
            this.validator = validator;
            this.selector = selector;
        }

        void validate(EnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names2) {
            Preconditions.notNull(enumSource, "EnumSource must not be null");
            Preconditions.notNull(names2, "names must not be null");
            this.validator.validate(enumSource, constants, names2);
        }

        boolean select(Enum<?> constant, Set<String> names2) {
            Preconditions.notNull(constant, "Enum constant must not be null");
            Preconditions.notNull(names2, "names must not be null");
            return this.selector.test(constant.name(), names2);
        }

        private static void validateNames(EnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names2) {
            Set allNames = constants.stream().map(Enum::name).collect(Collectors.toSet());
            Preconditions.condition(allNames.containsAll(names2), () -> "Invalid enum constant name(s) in " + enumSource + ". Valid names include: " + allNames);
        }

        private static void validatePatterns(EnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names2) {
            try {
                names2.forEach(Pattern::compile);
            }
            catch (PatternSyntaxException e) {
                throw new PreconditionViolationException("Pattern compilation failed for a regular expression supplied in " + enumSource, e);
            }
        }

        private static interface Validator {
            public void validate(EnumSource var1, Set<? extends Enum<?>> var2, Set<String> var3);
        }
    }
}

