/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;

@API(status=API.Status.INTERNAL, since="5.5")
public class InvocationInterceptorChain {
    public <T> T invoke(InvocationInterceptor.Invocation<T> invocation2, ExtensionRegistry extensionRegistry, InterceptorCall<T> call2) {
        List<InvocationInterceptor> interceptors = extensionRegistry.getExtensions(InvocationInterceptor.class);
        if (interceptors.isEmpty()) {
            return this.proceed(invocation2);
        }
        return this.chainAndInvoke(invocation2, call2, interceptors);
    }

    private <T> T chainAndInvoke(InvocationInterceptor.Invocation<T> invocation2, InterceptorCall<T> call2, List<InvocationInterceptor> interceptors) {
        ValidatingInvocation<T> validatingInvocation = new ValidatingInvocation<T>(invocation2, interceptors);
        InvocationInterceptor.Invocation<T> chainedInvocation = this.chainInterceptors(validatingInvocation, call2, interceptors);
        T result2 = this.proceed(chainedInvocation);
        validatingInvocation.verifyInvokedAtLeastOnce();
        return result2;
    }

    private <T> InvocationInterceptor.Invocation<T> chainInterceptors(InvocationInterceptor.Invocation<T> invocation2, InterceptorCall<T> call2, List<InvocationInterceptor> interceptors) {
        InvocationInterceptor.Invocation<T> result2 = invocation2;
        ListIterator<InvocationInterceptor> iterator2 = interceptors.listIterator(interceptors.size());
        while (iterator2.hasPrevious()) {
            InvocationInterceptor interceptor = iterator2.previous();
            result2 = new InterceptedInvocation<T>(result2, call2, interceptor);
        }
        return result2;
    }

    private <T> T proceed(InvocationInterceptor.Invocation<T> invocation2) {
        try {
            return invocation2.proceed();
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(t);
        }
    }

    @FunctionalInterface
    public static interface InterceptorCall<T> {
        public T apply(InvocationInterceptor var1, InvocationInterceptor.Invocation<T> var2) throws Throwable;

        public static InterceptorCall<Void> ofVoid(VoidInterceptorCall call2) {
            return (interceptorChain, invocation2) -> {
                call2.apply(interceptorChain, invocation2);
                return null;
            };
        }
    }

    private static class ValidatingInvocation<T>
    implements InvocationInterceptor.Invocation<T> {
        private static final Logger logger = LoggerFactory.getLogger(ValidatingInvocation.class);
        private final AtomicBoolean invokedOrSkipped = new AtomicBoolean();
        private final InvocationInterceptor.Invocation<T> delegate;
        private final List<InvocationInterceptor> interceptors;

        ValidatingInvocation(InvocationInterceptor.Invocation<T> delegate2, List<InvocationInterceptor> interceptors) {
            this.delegate = delegate2;
            this.interceptors = interceptors;
        }

        @Override
        public T proceed() throws Throwable {
            this.markInvokedOrSkipped();
            return this.delegate.proceed();
        }

        @Override
        public void skip() {
            logger.debug(() -> "The invocation is skipped");
            this.markInvokedOrSkipped();
            this.delegate.skip();
        }

        private void markInvokedOrSkipped() {
            if (!this.invokedOrSkipped.compareAndSet(false, true)) {
                this.fail("Chain of InvocationInterceptors called invocation multiple times instead of just once");
            }
        }

        void verifyInvokedAtLeastOnce() {
            if (!this.invokedOrSkipped.get()) {
                this.fail("Chain of InvocationInterceptors never called invocation");
            }
        }

        private void fail(String prefix) {
            String commaSeparatedInterceptorClasses = this.interceptors.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "));
            throw new JUnitException(prefix + ": " + commaSeparatedInterceptorClasses);
        }
    }

    private static class InterceptedInvocation<T>
    implements InvocationInterceptor.Invocation<T> {
        private final InvocationInterceptor.Invocation<T> invocation;
        private final InterceptorCall<T> call;
        private final InvocationInterceptor interceptor;

        InterceptedInvocation(InvocationInterceptor.Invocation<T> invocation2, InterceptorCall<T> call2, InvocationInterceptor interceptor) {
            this.invocation = invocation2;
            this.call = call2;
            this.interceptor = interceptor;
        }

        @Override
        public T proceed() throws Throwable {
            return this.call.apply(this.interceptor, this.invocation);
        }

        @Override
        public void skip() {
            this.invocation.skip();
        }
    }

    @FunctionalInterface
    public static interface VoidInterceptorCall {
        public void apply(InvocationInterceptor var1, InvocationInterceptor.Invocation<Void> var2) throws Throwable;
    }
}

