/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DynamicContainerTestDescriptor;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.DynamicTestTestDescriptor;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodSourceSupport;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.UriSource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestFactoryTestDescriptor
extends TestMethodTestDescriptor
implements Filterable {
    public static final String SEGMENT_TYPE = "test-factory";
    public static final String DYNAMIC_CONTAINER_SEGMENT_TYPE = "dynamic-container";
    public static final String DYNAMIC_TEST_SEGMENT_TYPE = "dynamic-test";
    private static final ExecutableInvoker.ReflectiveInterceptorCall<Method, Object> interceptorCall = InvocationInterceptor::interceptTestFactoryMethod;
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();
    private final DynamicDescendantFilter dynamicDescendantFilter = new DynamicDescendantFilter();

    public TestFactoryTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        super(uniqueId, testClass, testMethod, configuration);
    }

    @Override
    public DynamicDescendantFilter getDynamicDescendantFilter() {
        return this.dynamicDescendantFilter;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public boolean mayRegisterTests() {
        return true;
    }

    @Override
    protected void invokeTestMethod(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        ExtensionContext extensionContext = context.getExtensionContext();
        context.getThrowableCollector().execute(() -> {
            Object instance = extensionContext.getRequiredTestInstance();
            Object testFactoryMethodResult = executableInvoker.invoke(this.getTestMethod(), instance, extensionContext, (ExtensionRegistry)context.getExtensionRegistry(), interceptorCall);
            TestSource defaultTestSource = this.getSource().orElseThrow(() -> new JUnitException("Illegal state: TestSource must be present"));
            try (Stream<DynamicNode> dynamicNodeStream = this.toDynamicNodeStream(testFactoryMethodResult);){
                int index = 1;
                Iterator iterator2 = dynamicNodeStream.iterator();
                while (iterator2.hasNext()) {
                    DynamicNode dynamicNode = (DynamicNode)iterator2.next();
                    Optional<JupiterTestDescriptor> descriptor2 = TestFactoryTestDescriptor.createDynamicDescriptor(this, dynamicNode, index++, defaultTestSource, this.getDynamicDescendantFilter(), this.configuration);
                    descriptor2.ifPresent(dynamicTestExecutor::execute);
                }
            }
            catch (ClassCastException ex) {
                throw this.invalidReturnTypeException(ex);
            }
            dynamicTestExecutor.awaitFinished();
        });
    }

    private Stream<DynamicNode> toDynamicNodeStream(Object testFactoryMethodResult) {
        if (testFactoryMethodResult instanceof DynamicNode) {
            return Stream.of((DynamicNode)testFactoryMethodResult);
        }
        try {
            return CollectionUtils.toStream(testFactoryMethodResult);
        }
        catch (PreconditionViolationException ex) {
            throw this.invalidReturnTypeException(ex);
        }
    }

    private JUnitException invalidReturnTypeException(Throwable cause) {
        String message2 = String.format("@TestFactory method [%s] must return a single %2$s or a Stream, Collection, Iterable, Iterator, or array of %2$s.", this.getTestMethod().toGenericString(), DynamicNode.class.getName());
        return new JUnitException(message2, cause);
    }

    static Optional<JupiterTestDescriptor> createDynamicDescriptor(JupiterTestDescriptor parent, DynamicNode node, int index, TestSource defaultTestSource, DynamicDescendantFilter dynamicDescendantFilter, JupiterConfiguration configuration) {
        Supplier<JupiterTestDescriptor> descriptorCreator;
        UniqueId uniqueId;
        Optional<TestSource> customTestSource = node.getTestSourceUri().map(TestFactoryTestDescriptor::fromUri);
        TestSource source2 = customTestSource.orElse(defaultTestSource);
        if (node instanceof DynamicTest) {
            DynamicTest test = (DynamicTest)node;
            uniqueId = parent.getUniqueId().append(DYNAMIC_TEST_SEGMENT_TYPE, "#" + index);
            descriptorCreator = () -> new DynamicTestTestDescriptor(uniqueId, index, test, source2, configuration);
        } else {
            DynamicContainer container2 = (DynamicContainer)node;
            uniqueId = parent.getUniqueId().append(DYNAMIC_CONTAINER_SEGMENT_TYPE, "#" + index);
            descriptorCreator = () -> new DynamicContainerTestDescriptor(uniqueId, index, container2, source2, dynamicDescendantFilter, configuration);
        }
        if (dynamicDescendantFilter.test(uniqueId)) {
            JupiterTestDescriptor descriptor2 = descriptorCreator.get();
            descriptor2.setParent(parent);
            return Optional.of(descriptor2);
        }
        return Optional.empty();
    }

    static TestSource fromUri(URI uri2) {
        Preconditions.notNull(uri2, "URI must not be null");
        if ("classpath".equals(uri2.getScheme())) {
            return ClasspathResourceSource.from(uri2);
        }
        if ("class".equals(uri2.getScheme())) {
            return ClassSource.from(uri2);
        }
        if ("method".equals(uri2.getScheme())) {
            return MethodSourceSupport.from(uri2);
        }
        return UriSource.from(uri2);
    }

    @Override
    public void nodeSkipped(JupiterEngineExecutionContext context, TestDescriptor descriptor2, Node.SkipResult result2) {
    }

    @Override
    public void nodeFinished(JupiterEngineExecutionContext context, TestDescriptor descriptor2, TestExecutionResult result2) {
    }
}

