/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

@API(status=API.Status.INTERNAL, since="5.8")
public class EnumConfigurationParameterConverter<E extends Enum<E>> {
    private static final Logger logger = LoggerFactory.getLogger(EnumConfigurationParameterConverter.class);
    private final Class<E> enumType;
    private final String enumDisplayName;

    public EnumConfigurationParameterConverter(Class<E> enumType, String enumDisplayName) {
        this.enumType = enumType;
        this.enumDisplayName = enumDisplayName;
    }

    E get(ConfigurationParameters configParams, String key2, E defaultValue) {
        Preconditions.notNull(configParams, "ConfigurationParameters must not be null");
        return this.get(key2, configParams::get, defaultValue);
    }

    public E get(String key2, Function<String, Optional<String>> lookup2, E defaultValue) {
        Optional<String> value = lookup2.apply(key2);
        if (value.isPresent()) {
            String constantName = null;
            try {
                constantName = value.get().trim().toUpperCase(Locale.ROOT);
                E result2 = Enum.valueOf(this.enumType, constantName);
                logger.config(() -> String.format("Using %s '%s' set via the '%s' configuration parameter.", this.enumDisplayName, result2, key2));
                return result2;
            }
            catch (Exception ex) {
                String constant = constantName;
                logger.warn(() -> String.format("Invalid %s '%s' set via the '%s' configuration parameter. Falling back to the %s default value.", this.enumDisplayName, constant, key2, defaultValue.name()));
            }
        }
        return defaultValue;
    }
}

