/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ComparisonFailure;
import org.junit.function.ThrowingRunnable;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assert {
    protected Assert() {
    }

    public static void assertTrue(String message2, boolean condition) {
        if (!condition) {
            Assert.fail(message2);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, condition);
    }

    public static void assertFalse(String message2, boolean condition) {
        Assert.assertTrue(message2, !condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void fail(String message2) {
        if (message2 == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message2);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String message2, Object expected, Object actual) {
        if (Assert.equalsRegardingNull(expected, actual)) {
            return;
        }
        if (expected instanceof String && actual instanceof String) {
            String cleanMessage = message2 == null ? "" : message2;
            throw new ComparisonFailure(cleanMessage, (String)expected, (String)actual);
        }
        Assert.failNotEquals(message2, expected, actual);
    }

    private static boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return Assert.isEquals(expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message2, Object unexpected, Object actual) {
        if (Assert.equalsRegardingNull(unexpected, actual)) {
            Assert.failEquals(message2, actual);
        }
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    private static void failEquals(String message2, Object actual) {
        String formatted = "Values should be different. ";
        if (message2 != null) {
            formatted = message2 + ". ";
        }
        formatted = formatted + "Actual: " + actual;
        Assert.fail(formatted);
    }

    public static void assertNotEquals(String message2, long unexpected, long actual) {
        if (unexpected == actual) {
            Assert.failEquals(message2, actual);
        }
    }

    public static void assertNotEquals(long unexpected, long actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(String message2, double unexpected, double actual, double delta) {
        if (!Assert.doubleIsDifferent(unexpected, actual, delta)) {
            Assert.failEquals(message2, actual);
        }
    }

    public static void assertNotEquals(double unexpected, double actual, double delta) {
        Assert.assertNotEquals(null, unexpected, actual, delta);
    }

    public static void assertNotEquals(float unexpected, float actual, float delta) {
        Assert.assertNotEquals(null, unexpected, actual, delta);
    }

    public static void assertArrayEquals(String message2, Object[] expecteds, Object[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message2, boolean[] expecteds, boolean[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(boolean[] expecteds, boolean[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message2, byte[] expecteds, byte[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message2, char[] expecteds, char[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(char[] expecteds, char[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message2, short[] expecteds, short[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(short[] expecteds, short[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message2, int[] expecteds, int[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(int[] expecteds, int[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message2, long[] expecteds, long[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(long[] expecteds, long[] actuals) {
        Assert.assertArrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayEquals(String message2, double[] expecteds, double[] actuals, double delta) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(delta).arrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        Assert.assertArrayEquals(null, expecteds, actuals, delta);
    }

    public static void assertArrayEquals(String message2, float[] expecteds, float[] actuals, float delta) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(delta).arrayEquals(message2, expecteds, actuals);
    }

    public static void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        Assert.assertArrayEquals(null, expecteds, actuals, delta);
    }

    private static void internalArrayEquals(String message2, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        new ExactComparisonCriteria().arrayEquals(message2, expecteds, actuals);
    }

    public static void assertEquals(String message2, double expected, double actual, double delta) {
        if (Assert.doubleIsDifferent(expected, actual, delta)) {
            Assert.failNotEquals(message2, expected, actual);
        }
    }

    public static void assertEquals(String message2, float expected, float actual, float delta) {
        if (Assert.floatIsDifferent(expected, actual, delta)) {
            Assert.failNotEquals(message2, Float.valueOf(expected), Float.valueOf(actual));
        }
    }

    public static void assertNotEquals(String message2, float unexpected, float actual, float delta) {
        if (!Assert.floatIsDifferent(unexpected, actual, delta)) {
            Assert.failEquals(message2, Float.valueOf(actual));
        }
    }

    private static boolean doubleIsDifferent(double d1, double d2, double delta) {
        if (Double.compare(d1, d2) == 0) {
            return false;
        }
        return !(Math.abs(d1 - d2) <= delta);
    }

    private static boolean floatIsDifferent(float f1, float f2, float delta) {
        if (Float.compare(f1, f2) == 0) {
            return false;
        }
        return !(Math.abs(f1 - f2) <= delta);
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, long expected, long actual) {
        if (expected != actual) {
            Assert.failNotEquals(message2, expected, actual);
        }
    }

    @Deprecated
    public static void assertEquals(double expected, double actual) {
        Assert.assertEquals(null, expected, actual);
    }

    @Deprecated
    public static void assertEquals(String message2, double expected, double actual) {
        Assert.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertNotNull(String message2, Object object) {
        Assert.assertTrue(message2, object != null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNull(String message2, Object object) {
        if (object == null) {
            return;
        }
        Assert.failNotNull(message2, object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    private static void failNotNull(String message2, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        Assert.fail(formatted + "expected null, but was:<" + actual + ">");
    }

    public static void assertSame(String message2, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message2, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message2, Object unexpected, Object actual) {
        if (unexpected == actual) {
            Assert.failSame(message2);
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assert.assertNotSame(null, unexpected, actual);
    }

    private static void failSame(String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        Assert.fail(formatted + "expected not same");
    }

    private static void failNotSame(String message2, Object expected, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        Assert.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message2, Object expected, Object actual) {
        Assert.fail(Assert.format(message2, expected, actual));
    }

    static String format(String message2, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message2 != null && !"".equals(message2)) {
            formatted = message2 + " ";
        }
        if (Assert.equalsRegardingNull(expectedString = String.valueOf(expected), actualString = String.valueOf(actual))) {
            return formatted + "expected: " + Assert.formatClassAndValue(expected, expectedString) + " but was: " + Assert.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClass(Class<?> value) {
        String className = value.getCanonicalName();
        return className == null ? value.getName() : className;
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    @Deprecated
    public static void assertEquals(String message2, Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals(message2, expecteds, actuals);
    }

    @Deprecated
    public static void assertEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals(expecteds, actuals);
    }

    @Deprecated
    public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
        Assert.assertThat("", actual, matcher);
    }

    @Deprecated
    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        MatcherAssert.assertThat(reason, actual, matcher);
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedThrowable, ThrowingRunnable runnable) {
        return Assert.assertThrows(null, expectedThrowable, runnable);
    }

    public static <T extends Throwable> T assertThrows(String message2, Class<T> expectedThrowable, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable actualThrown) {
            Class<?> actualThrowable;
            String actual;
            if (expectedThrowable.isInstance(actualThrown)) {
                Throwable retVal = actualThrown;
                return (T)retVal;
            }
            String expected = Assert.formatClass(expectedThrowable);
            if (expected.equals(actual = Assert.formatClass(actualThrowable = actualThrown.getClass()))) {
                expected = expected + "@" + Integer.toHexString(System.identityHashCode(expectedThrowable));
                actual = actual + "@" + Integer.toHexString(System.identityHashCode(actualThrowable));
            }
            String mismatchMessage = Assert.buildPrefix(message2) + Assert.format("unexpected exception type thrown;", expected, actual);
            AssertionError assertionError = new AssertionError((Object)mismatchMessage);
            ((Throwable)((Object)assertionError)).initCause(actualThrown);
            throw assertionError;
        }
        String notThrownMessage = Assert.buildPrefix(message2) + String.format("expected %s to be thrown, but nothing was thrown", Assert.formatClass(expectedThrowable));
        throw new AssertionError((Object)notThrownMessage);
    }

    private static String buildPrefix(String message2) {
        return message2 != null && message2.length() != 0 ? message2 + ": " : "";
    }
}

