/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    static final Logger LOG;
    public static final Charset ENCODING;

    public UrlEncoded(UrlEncoded url2) {
        super(url2);
    }

    public UrlEncoded() {
    }

    public UrlEncoded(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String query, Charset charset) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, charset);
    }

    public String encode() {
        return this.encode(ENCODING, false);
    }

    public String encode(Charset charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(Charset charset, boolean equalsForNullValue) {
        return UrlEncoded.encode(this, charset, equalsForNullValue);
    }

    public static String encode(MultiMap<String> map2, Charset charset, boolean equalsForNullValue) {
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder result2 = new StringBuilder(128);
        boolean delim = false;
        for (Map.Entry entry : map2.entrySet()) {
            String key2 = (String)entry.getKey();
            List list = (List)entry.getValue();
            int s = list.size();
            if (delim) {
                result2.append('&');
            }
            if (s == 0) {
                result2.append(UrlEncoded.encodeString(key2, charset));
                if (equalsForNullValue) {
                    result2.append('=');
                }
            } else {
                for (int i2 = 0; i2 < s; ++i2) {
                    if (i2 > 0) {
                        result2.append('&');
                    }
                    String val = (String)list.get(i2);
                    result2.append(UrlEncoded.encodeString(key2, charset));
                    if (val != null) {
                        String str = val;
                        if (str.length() > 0) {
                            result2.append('=');
                            result2.append(UrlEncoded.encodeString(str, charset));
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result2.append('=');
                        continue;
                    }
                    if (!equalsForNullValue) continue;
                    result2.append('=');
                }
            }
            delim = true;
        }
        return result2.toString();
    }

    public static void decodeTo(String content2, MultiMap<String> map2, String charset) {
        UrlEncoded.decodeTo(content2, map2, charset == null ? null : Charset.forName(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content2, MultiMap<String> map2, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(content2, 0, content2.length(), map2);
            return;
        }
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            String value;
            String key2 = null;
            int mark = -1;
            boolean encoded2 = false;
            block9: for (int i2 = 0; i2 < content2.length(); ++i2) {
                char c = content2.charAt(i2);
                switch (c) {
                    case '&': {
                        int l = i2 - mark - 1;
                        value = l == 0 ? "" : (encoded2 ? UrlEncoded.decodeString(content2, mark + 1, l, charset) : content2.substring(mark + 1, i2));
                        mark = i2;
                        encoded2 = false;
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value != null && value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key2 != null) continue block9;
                        key2 = encoded2 ? UrlEncoded.decodeString(content2, mark + 1, i2 - mark - 1, charset) : content2.substring(mark + 1, i2);
                        mark = i2;
                        encoded2 = false;
                        continue block9;
                    }
                    case '+': {
                        encoded2 = true;
                        continue block9;
                    }
                    case '%': {
                        encoded2 = true;
                    }
                }
            }
            if (key2 != null) {
                int l = content2.length() - mark - 1;
                value = l == 0 ? "" : (encoded2 ? UrlEncoded.decodeString(content2, mark + 1, l, charset) : content2.substring(mark + 1));
                map2.add(key2, value);
            } else if (mark < content2.length()) {
                String string = key2 = encoded2 ? UrlEncoded.decodeString(content2, mark + 1, content2.length() - mark - 1, charset) : content2.substring(mark + 1);
                if (key2 != null && key2.length() > 0) {
                    map2.add(key2, "");
                }
            }
        }
    }

    public static void decodeUtf8To(String query, MultiMap<String> map2) {
        UrlEncoded.decodeUtf8To(query, 0, query.length(), map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(String query, int offset, int length, MultiMap<String> map2) {
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            String key2 = null;
            String value = null;
            int end2 = offset + length;
            block9: for (int i2 = offset; i2 < end2; ++i2) {
                char c = query.charAt(i2);
                switch (c) {
                    case '&': {
                        value = buffer.toReplacedString();
                        buffer.reset();
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value != null && value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key2 != null) {
                            buffer.append(c);
                            continue block9;
                        }
                        key2 = buffer.toReplacedString();
                        buffer.reset();
                        continue block9;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i2 + 2 < end2) {
                            char hi = query.charAt(++i2);
                            char lo = query.charAt(++i2);
                            buffer.append(UrlEncoded.decodeHexByte(hi, lo));
                            continue block9;
                        }
                        throw new Utf8Appendable.NotUtf8Exception("Incomplete % encoding");
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            if (key2 != null) {
                value = buffer.toReplacedString();
                buffer.reset();
                map2.add(key2, value);
            } else if (buffer.length() > 0) {
                map2.add(buffer.toReplacedString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream in, MultiMap<String> map2, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            int b;
            StringBuilder buffer = new StringBuilder();
            String key2 = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.setLength(0);
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        UrlEncoded.checkMaxKeys(map2, maxKeys);
                        break;
                    }
                    case '=': {
                        if (key2 != null) {
                            buffer.append((char)b);
                            break;
                        }
                        key2 = buffer.toString();
                        buffer.setLength(0);
                        break;
                    }
                    case '+': {
                        buffer.append(' ');
                        break;
                    }
                    case '%': {
                        int code0 = in.read();
                        int code1 = in.read();
                        buffer.append(UrlEncoded.decodeHexChar(code0, code1));
                        break;
                    }
                    default: {
                        buffer.append((char)b);
                    }
                }
                UrlEncoded.checkMaxLength(++totalLength, maxLength);
            }
            if (key2 != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.setLength(0);
                map2.add(key2, value);
            } else if (buffer.length() > 0) {
                map2.add(buffer.toString(), "");
            }
            UrlEncoded.checkMaxKeys(map2, maxKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream in, MultiMap<String> map2, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            int b;
            Utf8StringBuilder buffer = new Utf8StringBuilder();
            String key2 = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.toReplacedString();
                        buffer.reset();
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value != null && value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        UrlEncoded.checkMaxKeys(map2, maxKeys);
                        break;
                    }
                    case '=': {
                        if (key2 != null) {
                            buffer.append((byte)b);
                            break;
                        }
                        key2 = buffer.toReplacedString();
                        buffer.reset();
                        break;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        break;
                    }
                    case '%': {
                        char code0 = (char)in.read();
                        char code1 = (char)in.read();
                        buffer.append(UrlEncoded.decodeHexByte(code0, code1));
                        break;
                    }
                    default: {
                        buffer.append((byte)b);
                    }
                }
                UrlEncoded.checkMaxLength(++totalLength, maxLength);
            }
            if (key2 != null) {
                value = buffer.toReplacedString();
                buffer.reset();
                map2.add(key2, value);
            } else if (buffer.length() > 0) {
                map2.add(buffer.toReplacedString(), "");
            }
            UrlEncoded.checkMaxKeys(map2, maxKeys);
        }
    }

    public static void decodeUtf16To(InputStream in, MultiMap<String> map2, int maxLength, int maxKeys) throws IOException {
        InputStreamReader input2 = new InputStreamReader(in, StandardCharsets.UTF_16);
        StringWriter buf = new StringWriter(8192);
        IO.copy(input2, buf, (long)maxLength);
        UrlEncoded.decodeTo(buf.getBuffer().toString(), map2, StandardCharsets.UTF_16);
    }

    public static void decodeTo(InputStream in, MultiMap<String> map2, String charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            if (ENCODING.equals(StandardCharsets.UTF_8)) {
                UrlEncoded.decodeUtf8To(in, map2, maxLength, maxKeys);
            } else {
                UrlEncoded.decodeTo(in, map2, ENCODING, maxLength, maxKeys);
            }
        } else if ("utf-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To(in, map2, maxLength, maxKeys);
        } else if ("iso-8859-1".equalsIgnoreCase(charset)) {
            UrlEncoded.decode88591To(in, map2, maxLength, maxKeys);
        } else if ("utf-16".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf16To(in, map2, maxLength, maxKeys);
        } else {
            UrlEncoded.decodeTo(in, map2, Charset.forName(charset), maxLength, maxKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream in, MultiMap<String> map2, Charset charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(in, map2, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.ISO_8859_1.equals(charset)) {
            UrlEncoded.decode88591To(in, map2, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            UrlEncoded.decodeUtf16To(in, map2, maxLength, maxKeys);
            return;
        }
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            String key2 = null;
            String value = null;
            int totalLength = 0;
            try (ByteArrayOutputStream2 output2 = new ByteArrayOutputStream2();){
                int c;
                int size2 = 0;
                while ((c = in.read()) > 0) {
                    switch ((char)c) {
                        case '&': {
                            size2 = output2.size();
                            value = size2 == 0 ? "" : output2.toString(charset);
                            output2.setCount(0);
                            if (key2 != null) {
                                map2.add(key2, value);
                            } else if (value != null && value.length() > 0) {
                                map2.add(value, "");
                            }
                            key2 = null;
                            value = null;
                            UrlEncoded.checkMaxKeys(map2, maxKeys);
                            break;
                        }
                        case '=': {
                            if (key2 != null) {
                                output2.write(c);
                                break;
                            }
                            size2 = output2.size();
                            key2 = size2 == 0 ? "" : output2.toString(charset);
                            output2.setCount(0);
                            break;
                        }
                        case '+': {
                            output2.write(32);
                            break;
                        }
                        case '%': {
                            int code0 = in.read();
                            int code1 = in.read();
                            output2.write(UrlEncoded.decodeHexChar(code0, code1));
                            break;
                        }
                        default: {
                            output2.write(c);
                        }
                    }
                    UrlEncoded.checkMaxLength(++totalLength, maxLength);
                }
                size2 = output2.size();
                if (key2 != null) {
                    value = size2 == 0 ? "" : output2.toString(charset);
                    output2.setCount(0);
                    map2.add(key2, value);
                } else if (size2 > 0) {
                    map2.add(output2.toString(charset), "");
                }
                UrlEncoded.checkMaxKeys(map2, maxKeys);
            }
        }
    }

    private static void checkMaxKeys(MultiMap<String> map2, int maxKeys) {
        int size2 = map2.size();
        if (maxKeys >= 0 && size2 > maxKeys) {
            throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", size2, maxKeys));
        }
    }

    private static void checkMaxLength(int length, int maxLength) {
        if (maxLength >= 0 && length > maxLength) {
            throw new IllegalStateException("Form is larger than max length " + maxLength);
        }
    }

    public static String decodeString(String encoded2) {
        return UrlEncoded.decodeString(encoded2, 0, encoded2.length(), ENCODING);
    }

    public static String decodeString(String encoded2, int offset, int length, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8Appendable buffer = null;
            for (int i2 = 0; i2 < length; ++i2) {
                char c = encoded2.charAt(offset + i2);
                if (c < '\u0000' || c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded2, offset, offset + i2 + 1);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded2, offset, offset + i2);
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(' ');
                    continue;
                }
                if (c == '%') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded2, offset, offset + i2);
                    }
                    if (i2 + 2 < length) {
                        int o = offset + i2 + 1;
                        i2 += 2;
                        byte b = (byte)TypeUtil.parseInt(encoded2, o, 2, 16);
                        buffer.append(b);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                    i2 = length;
                    continue;
                }
                if (buffer == null) continue;
                ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded2.length() == length) {
                    return encoded2;
                }
                return encoded2.substring(offset, offset + length);
            }
            return buffer.toReplacedString();
        }
        StringBuffer buffer = null;
        for (int i3 = 0; i3 < length; ++i3) {
            char c = encoded2.charAt(offset + i3);
            if (c < '\u0000' || c > '\u00ff') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded2, offset, offset + i3 + 1);
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '+') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded2, offset, offset + i3);
                }
                buffer.append(' ');
                continue;
            }
            if (c == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded2, offset, offset + i3);
                }
                byte[] ba = new byte[length];
                int n = 0;
                while (c >= '\u0000' && c <= '\u00ff') {
                    if (c == '%') {
                        if (i3 + 2 < length) {
                            int o = offset + i3 + 1;
                            i3 += 3;
                            ba[n] = (byte)TypeUtil.parseInt(encoded2, o, 2, 16);
                            ++n;
                        } else {
                            ba[n++] = 63;
                            i3 = length;
                        }
                    } else if (c == '+') {
                        ba[n++] = 32;
                        ++i3;
                    } else {
                        ba[n++] = (byte)c;
                        ++i3;
                    }
                    if (i3 >= length) break;
                    c = encoded2.charAt(offset + i3);
                }
                --i3;
                buffer.append(new String(ba, 0, n, charset));
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer == null) {
            if (offset == 0 && encoded2.length() == length) {
                return encoded2;
            }
            return encoded2.substring(offset, offset + length);
        }
        return buffer.toString();
    }

    private static char decodeHexChar(int hi, int lo) {
        try {
            return (char)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not valid encoding '%" + (char)hi + (char)lo + "'");
        }
    }

    private static byte decodeHexByte(char hi, char lo) {
        try {
            return (byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not valid encoding '%" + hi + lo + "'");
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, ENCODING);
    }

    public static String encodeString(String string, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] bytes = null;
        bytes = string.getBytes(charset);
        int len = bytes.length;
        byte[] encoded2 = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i2 = 0; i2 < len; ++i2) {
            byte b = bytes[i2];
            if (b == 32) {
                noEncode = false;
                encoded2[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 45 || b == 46 || b == 95 || b == 126) {
                encoded2[n++] = b;
                continue;
            }
            noEncode = false;
            encoded2[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded2[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded2[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        return new String(encoded2, 0, n, charset);
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }

    static {
        Charset encoding;
        LOG = Log.getLogger(UrlEncoded.class);
        try {
            String charset = System.getProperty("org.eclipse.jetty.util.UrlEncoding.charset");
            encoding = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
        }
        catch (Exception e) {
            LOG.warn(e);
            encoding = StandardCharsets.UTF_8;
        }
        ENCODING = encoding;
    }
}

