/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class IO {
    private static final Logger LOG = Log.getLogger(IO.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static final int bufferSize = 65536;
    private static NullOS __nullStream = new NullOS();
    private static ClosedIS __closedStream = new ClosedIS();
    private static NullWrite __nullWriter = new NullWrite();
    private static PrintWriter __nullPrintWriter = new PrintWriter(__nullWriter);

    public static void copy(InputStream in, OutputStream out2) throws IOException {
        IO.copy(in, out2, -1L);
    }

    public static void copy(Reader in, Writer out2) throws IOException {
        IO.copy(in, out2, -1L);
    }

    public static void copy(InputStream in, OutputStream out2, long byteCount) throws IOException {
        byte[] buffer = new byte[65536];
        int len = 65536;
        if (byteCount >= 0L) {
            int max;
            while (byteCount > 0L && (len = in.read(buffer, 0, max = byteCount < 65536L ? (int)byteCount : 65536)) != -1) {
                byteCount -= (long)len;
                out2.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, 65536)) >= 0) {
                out2.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out2, long byteCount) throws IOException {
        char[] buffer = new char[65536];
        int len = 65536;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < 65536L ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, 65536)) != -1) {
                byteCount -= (long)len;
                out2.write(buffer, 0, len);
            }
        } else if (out2 instanceof PrintWriter) {
            PrintWriter pout = (PrintWriter)out2;
            while (!pout.checkError() && (len = in.read(buffer, 0, 65536)) != -1) {
                out2.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, 65536)) != -1) {
                out2.write(buffer, 0, len);
            }
        }
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            IO.copyDir(from, to);
        } else {
            IO.copyFile(from, to);
        }
    }

    public static void copyDir(File from, File to) throws IOException {
        File[] files2;
        if (to.exists()) {
            if (!to.isDirectory()) {
                throw new IllegalArgumentException(to.toString());
            }
        } else {
            to.mkdirs();
        }
        if ((files2 = from.listFiles()) != null) {
            for (int i2 = 0; i2 < files2.length; ++i2) {
                String name = files2[i2].getName();
                if (".".equals(name) || "..".equals(name)) continue;
                IO.copy(files2[i2], new File(to, name));
            }
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        try (FileInputStream in = new FileInputStream(from);
             FileOutputStream out2 = new FileOutputStream(to);){
            IO.copy(in, out2);
        }
    }

    public static String toString(Path path, Charset charset) throws IOException {
        byte[] buf = Files.readAllBytes(path);
        return new String(buf, charset);
    }

    public static String toString(InputStream in) throws IOException {
        return IO.toString(in, (Charset)null);
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        return IO.toString(in, encoding == null ? null : Charset.forName(encoding));
    }

    public static String toString(InputStream in, Charset encoding) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader2 = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        IO.copy(reader2, writer);
        return writer.toString();
    }

    public static String toString(Reader in) throws IOException {
        StringWriter writer = new StringWriter();
        IO.copy(in, writer);
        return writer.toString();
    }

    public static boolean delete(File file2) {
        if (file2 == null) {
            return false;
        }
        if (!file2.exists()) {
            return false;
        }
        if (file2.isDirectory()) {
            File[] files2 = file2.listFiles();
            for (int i2 = 0; files2 != null && i2 < files2.length; ++i2) {
                IO.delete(files2[i2]);
            }
        }
        return file2.delete();
    }

    public static boolean isEmptyDir(File dir) {
        if (dir == null) {
            return true;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        String[] list = dir.list();
        if (list == null) {
            return true;
        }
        return list.length <= 0;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ignore) {
            LOG.ignore(ignore);
        }
    }

    public static void close(InputStream is) {
        IO.close((Closeable)is);
    }

    public static void close(OutputStream os) {
        IO.close((Closeable)os);
    }

    public static void close(Reader reader2) {
        IO.close((Closeable)reader2);
    }

    public static void close(Writer writer) {
        IO.close((Closeable)writer);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IO.copy(in, bout);
        return bout.toByteArray();
    }

    public static long write(GatheringByteChannel out2, ByteBuffer[] buffers, int offset, int length) throws IOException {
        long wrote;
        long total = 0L;
        block0: while (length > 0 && (wrote = out2.write(buffers, offset, length)) != 0L) {
            total += wrote;
            for (int i2 = offset; i2 < buffers.length; ++i2) {
                if (!buffers[i2].hasRemaining()) continue;
                length -= i2 - offset;
                offset = i2;
                continue block0;
            }
            length = 0;
        }
        return total;
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static InputStream getClosedStream() {
        return __closedStream;
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    public static PrintWriter getNullPrintWriter() {
        return __nullPrintWriter;
    }

    private static class NullWrite
    extends Writer {
        private NullWrite() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] b) {
        }

        @Override
        public void write(char[] b, int o, int l) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(String s) {
        }

        @Override
        public void write(String s, int o, int l) {
        }
    }

    private static class ClosedIS
    extends InputStream {
        private ClosedIS() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int i2, int l) {
        }

        @Override
        public void write(int b) {
        }
    }

    static class Job
    implements Runnable {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream in, OutputStream out2) {
            this.in = in;
            this.out = out2;
            this.read = null;
            this.write = null;
        }

        Job(Reader read2, Writer write2) {
            this.in = null;
            this.out = null;
            this.read = read2;
            this.write = write2;
        }

        @Override
        public void run() {
            try {
                if (this.in != null) {
                    IO.copy(this.in, this.out, -1L);
                } else {
                    IO.copy(this.read, this.write, -1L);
                }
            }
            catch (IOException e) {
                LOG.ignore(e);
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.write != null) {
                        this.write.close();
                    }
                }
                catch (IOException ex2) {
                    LOG.ignore(ex2);
                }
            }
        }
    }
}

