/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.List;
import java.util.function.LongConsumer;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Callback;

public interface Response {
    public Request getRequest();

    public <T extends ResponseListener> List<T> getListeners(Class<T> var1);

    public HttpVersion getVersion();

    public int getStatus();

    public String getReason();

    public HttpFields getHeaders();

    public boolean abort(Throwable var1);

    public static interface Listener
    extends BeginListener,
    HeaderListener,
    HeadersListener,
    ContentListener,
    SuccessListener,
    FailureListener,
    CompleteListener {
        @Override
        default public void onBegin(Response response2) {
        }

        @Override
        default public boolean onHeader(Response response2, HttpField field) {
            return true;
        }

        @Override
        default public void onHeaders(Response response2) {
        }

        @Override
        default public void onContent(Response response2, ByteBuffer content2) {
        }

        @Override
        default public void onSuccess(Response response2) {
        }

        @Override
        default public void onFailure(Response response2, Throwable failure) {
        }

        @Override
        default public void onComplete(Result result2) {
        }

        public static class Adapter
        implements Listener {
        }
    }

    public static interface CompleteListener
    extends ResponseListener {
        public void onComplete(Result var1);
    }

    public static interface FailureListener
    extends ResponseListener {
        public void onFailure(Response var1, Throwable var2);
    }

    public static interface SuccessListener
    extends ResponseListener {
        public void onSuccess(Response var1);
    }

    public static interface DemandedContentListener
    extends ResponseListener {
        default public void onBeforeContent(Response response2, LongConsumer demand) {
            demand.accept(1L);
        }

        public void onContent(Response var1, LongConsumer var2, ByteBuffer var3, Callback var4);
    }

    public static interface AsyncContentListener
    extends DemandedContentListener {
        public void onContent(Response var1, ByteBuffer var2, Callback var3);

        @Override
        default public void onContent(Response response2, LongConsumer demand, ByteBuffer content2, Callback callback) {
            this.onContent(response2, content2, Callback.from(() -> {
                callback.succeeded();
                demand.accept(1L);
            }, callback::failed));
        }
    }

    public static interface ContentListener
    extends AsyncContentListener {
        public void onContent(Response var1, ByteBuffer var2);

        @Override
        default public void onContent(Response response2, ByteBuffer content2, Callback callback) {
            try {
                this.onContent(response2, content2);
                callback.succeeded();
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        }
    }

    public static interface HeadersListener
    extends ResponseListener {
        public void onHeaders(Response var1);
    }

    public static interface HeaderListener
    extends ResponseListener {
        public boolean onHeader(Response var1, HttpField var2);
    }

    public static interface BeginListener
    extends ResponseListener {
        public void onBegin(Response var1);
    }

    public static interface ResponseListener
    extends EventListener {
    }
}

