/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.IntrospectionError;

public final class Introspection {
    public static Method getPropertyGetter(String propertyName, Object target) {
        Method getter2;
        Preconditions.checkNotNullOrEmpty(propertyName);
        Preconditions.checkNotNull(target);
        try {
            getter2 = Introspection.findGetter(propertyName, target);
            if (Modifier.isPublic(getter2.getModifiers())) {
                getter2.setAccessible(true);
            }
            getter2.invoke(target, new Object[0]);
        }
        catch (Exception t) {
            throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage(propertyName, target), t);
        }
        return getter2;
    }

    private static String propertyNotFoundErrorMessage(String propertyName, Object target) {
        String targetTypeName = target.getClass().getName();
        String property2 = Strings.quote(propertyName);
        Method getter2 = Introspection.findGetter(propertyName, target);
        if (getter2 == null) {
            return String.format("No getter for property %s in %s", property2, targetTypeName);
        }
        if (!Modifier.isPublic(getter2.getModifiers())) {
            return String.format("No public getter for property %s in %s", property2, targetTypeName);
        }
        return String.format("Unable to find property %s in %s", property2, targetTypeName);
    }

    private static Method findGetter(String propertyName, Object target) {
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter2 = Introspection.findMethod("get" + capitalized, target);
        if (getter2 != null) {
            return getter2;
        }
        return Introspection.findMethod("is" + capitalized, target);
    }

    private static Method findMethod(String name, Object target) {
        Class<?> clazz = target.getClass();
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            while (clazz != null) {
                try {
                    return clazz.getDeclaredMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException exception2) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }
    }

    private Introspection() {
    }
}

