/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class TextFileWriter {
    private static final TextFileWriter INSTANCE = new TextFileWriter();

    public static TextFileWriter instance() {
        return INSTANCE;
    }

    public void write(File file2, String ... content2) throws IOException {
        this.write(file2, Charset.defaultCharset(), content2);
    }

    public void write(File file2, Charset charset, String ... content2) throws IOException {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), charset));){
            for (String line : content2) {
                writer.println(line);
            }
        }
    }

    private TextFileWriter() {
    }
}

