/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;

public class HexadecimalRepresentation
extends StandardRepresentation {
    public static final HexadecimalRepresentation HEXA_REPRESENTATION = new HexadecimalRepresentation();
    public static final String PREFIX = "0x";
    public static final int NIBBLE_SIZE = 4;

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof Number) {
            return this.toStringOf((Number)object);
        }
        if (object instanceof String) {
            return this.toStringOf(this, (String)object);
        }
        if (object instanceof Character) {
            return this.toStringOf((Character)object);
        }
        return super.toStringOf(object);
    }

    @Override
    protected String toStringOf(Number number) {
        if (number instanceof Byte) {
            return this.toStringOf((Byte)number);
        }
        if (number instanceof Short) {
            return this.toStringOf((Short)number);
        }
        if (number instanceof Integer) {
            return this.toStringOf((Integer)number);
        }
        if (number instanceof Long) {
            return this.toStringOf((Long)number);
        }
        if (number instanceof Float) {
            return this.toStringOf((Float)number);
        }
        if (number instanceof Double) {
            return this.toStringOf((Double)number);
        }
        return number.toString();
    }

    protected String toStringOf(Byte b) {
        return HexadecimalRepresentation.toGroupedHex(b, 8);
    }

    protected String toStringOf(Short s) {
        return HexadecimalRepresentation.toGroupedHex(s, 16);
    }

    protected String toStringOf(Integer i2) {
        return HexadecimalRepresentation.toGroupedHex(i2, 32);
    }

    @Override
    protected String toStringOf(Long l) {
        return HexadecimalRepresentation.toGroupedHex(l, 64);
    }

    @Override
    protected String toStringOf(Float f) {
        return HexadecimalRepresentation.toGroupedHex(Float.floatToIntBits(f.floatValue()), 32);
    }

    protected String toStringOf(Double d) {
        return HexadecimalRepresentation.toGroupedHex(Double.doubleToRawLongBits(d), 64);
    }

    @Override
    protected String toStringOf(Character character) {
        return Strings.concat("'", this.toStringOf((short)character.charValue()), "'");
    }

    protected String toStringOf(Representation representation, String s) {
        return Strings.concat("\"", representation.toStringOf(s.toCharArray()), "\"");
    }

    private static String toGroupedHex(Number value, int size2) {
        return PREFIX + NumberGrouping.toHexLiteral(HexadecimalRepresentation.toHex(value, size2));
    }

    private static String toHex(Number value, int sizeInBits) {
        return String.format("%0" + sizeInBits / 4 + "X", value);
    }
}

