/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.jar.asm;

import org.assertj.core.internal.bytebuddy.jar.asm.AnnotationVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.Attribute;
import org.assertj.core.internal.bytebuddy.jar.asm.FieldVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.MethodVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.ModuleVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.TypePath;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int api) {
        this(api, null);
    }

    public ClassVisitor(int api, ClassVisitor classVisitor) {
        if (api != 393216 && api != 327680 && api != 262144 && api != 0x1070000) {
            throw new IllegalArgumentException();
        }
        this.api = api;
        this.cv = classVisitor;
    }

    public void visit(int version2, int access, String name, String signature2, String superName, String[] interfaces) {
        if (this.cv != null) {
            this.cv.visit(version2, access, name, signature2, superName, interfaces);
        }
    }

    public void visitSource(String source2, String debug2) {
        if (this.cv != null) {
            this.cv.visitSource(source2, debug2);
        }
    }

    public ModuleVisitor visitModule(String name, int access, String version2) {
        if (this.api < 393216) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            return this.cv.visitModule(name, access, version2);
        }
        return null;
    }

    @Deprecated
    public void visitNestHostExperimental(String nestHost) {
        if (this.api < 0x1070000) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            this.cv.visitNestHostExperimental(nestHost);
        }
    }

    public void visitOuterClass(String owner, String name, String descriptor2) {
        if (this.cv != null) {
            this.cv.visitOuterClass(owner, name, descriptor2);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(descriptor2, visible);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            return this.cv.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    @Deprecated
    public void visitNestMemberExperimental(String nestMember) {
        if (this.api < 0x1070000) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            this.cv.visitNestMemberExperimental(nestMember);
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.cv != null) {
            this.cv.visitInnerClass(name, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name, String descriptor2, String signature2, Object value) {
        if (this.cv != null) {
            return this.cv.visitField(access, name, descriptor2, signature2, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor2, String signature2, String[] exceptions) {
        if (this.cv != null) {
            return this.cv.visitMethod(access, name, descriptor2, signature2, exceptions);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

