/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.core.internal.bytebuddy.utility.privilege.SetAccessibleAction;

public interface LoadedTypeInitializer {
    public void onLoad(Class<?> var1);

    public boolean isAlive();

    @HashCodeAndEqualsPlugin.Enhance
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Serialization is considered opt-in for a rare use case")
    public static class Compound
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<LoadedTypeInitializer> loadedTypeInitializers = new ArrayList<LoadedTypeInitializer>();

        public Compound(LoadedTypeInitializer ... loadedTypeInitializer) {
            this(Arrays.asList(loadedTypeInitializer));
        }

        public Compound(List<? extends LoadedTypeInitializer> loadedTypeInitializers) {
            for (LoadedTypeInitializer loadedTypeInitializer : loadedTypeInitializers) {
                if (loadedTypeInitializer instanceof Compound) {
                    this.loadedTypeInitializers.addAll(((Compound)loadedTypeInitializer).loadedTypeInitializers);
                    continue;
                }
                if (loadedTypeInitializer instanceof NoOp) continue;
                this.loadedTypeInitializers.add(loadedTypeInitializer);
            }
        }

        @Override
        public void onLoad(Class<?> type2) {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializers) {
                loadedTypeInitializer.onLoad(type2);
            }
        }

        @Override
        public boolean isAlive() {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializers) {
                if (!loadedTypeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.loadedTypeInitializers).equals(((Compound)object).loadedTypeInitializers);
        }

        public int hashCode() {
            return 17 * 31 + ((Object)this.loadedTypeInitializers).hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class ForStaticField
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Object STATIC_FIELD = null;
        private final String fieldName;
        private final Object value;

        protected ForStaticField(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        public void onLoad(Class<?> type2) {
            try {
                Field field = type2.getDeclaredField(this.fieldName);
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                    AccessController.doPrivileged(new SetAccessibleAction<Field>(field));
                }
                field.set(STATIC_FIELD, this.value);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("Cannot access " + this.fieldName + " from " + type2, exception);
            }
            catch (NoSuchFieldException exception) {
                throw new IllegalStateException("There is no field " + this.fieldName + " defined on " + type2, exception);
            }
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.fieldName.equals(((ForStaticField)object).fieldName)) {
                return false;
            }
            return this.value.equals(((ForStaticField)object).value);
        }

        public int hashCode() {
            return (17 * 31 + this.fieldName.hashCode()) * 31 + this.value.hashCode();
        }
    }

    public static enum NoOp implements LoadedTypeInitializer
    {
        INSTANCE;


        @Override
        public void onLoad(Class<?> type2) {
        }

        @Override
        public boolean isAlive() {
            return false;
        }
    }
}

