/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.description.method;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.core.internal.bytebuddy.description.ByteCodeElement;
import org.assertj.core.internal.bytebuddy.description.ModifierReviewable;
import org.assertj.core.internal.bytebuddy.description.NamedElement;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationDescription;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationList;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationSource;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeDefinition;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeList;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackSize;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;

public interface ParameterDescription
extends AnnotationSource,
NamedElement.WithRuntimeName,
NamedElement.WithOptionalName,
ModifierReviewable.ForParameterDescription,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public static final String NAME_PREFIX = "arg";

    public TypeDescription.Generic getType();

    public MethodDescription getDeclaringMethod();

    public int getIndex();

    public boolean hasModifiers();

    public int getOffset();

    public static class Token
    implements ByteCodeElement.Token<Token> {
        public static final String NO_NAME = null;
        public static final Integer NO_MODIFIERS = null;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;
        private final String name;
        private final Integer modifiers;

        public Token(TypeDescription.Generic type2) {
            this(type2, Collections.emptyList());
        }

        public Token(TypeDescription.Generic type2, List<? extends AnnotationDescription> annotations2) {
            this(type2, annotations2, NO_NAME, NO_MODIFIERS);
        }

        public Token(TypeDescription.Generic type2, String name, Integer modifiers) {
            this(type2, Collections.emptyList(), name, modifiers);
        }

        public Token(TypeDescription.Generic type2, List<? extends AnnotationDescription> annotations2, String name, Integer modifiers) {
            this.type = type2;
            this.annotations = annotations2;
            this.name = name;
            this.modifiers = modifiers;
        }

        public TypeDescription.Generic getType() {
            return this.type;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        public String getName() {
            return this.name;
        }

        public Integer getModifiers() {
            return this.modifiers;
        }

        @Override
        public Token accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor2) {
            return new Token(this.type.accept(visitor2), this.annotations, this.name, this.modifiers);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token2 = (Token)other;
            return this.type.equals(token2.type) && this.annotations.equals(token2.annotations) && (this.name != null ? this.name.equals(token2.name) : token2.name == null) && (this.modifiers != null ? this.modifiers.equals(token2.modifiers) : token2.modifiers == null);
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = 31 * result2 + this.annotations.hashCode();
            result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
            result2 = 31 * result2 + (this.modifiers != null ? this.modifiers.hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "ParameterDescription.Token{type=" + this.type + ", annotations=" + this.annotations + ", name='" + this.name + '\'' + ", modifiers=" + this.modifiers + '}';
        }

        public static class TypeList
        extends AbstractList<Token> {
            private final List<? extends TypeDefinition> typeDescriptions;

            public TypeList(List<? extends TypeDefinition> typeDescriptions) {
                this.typeDescriptions = typeDescriptions;
            }

            @Override
            public Token get(int index) {
                return new Token(this.typeDescriptions.get(index).asGenericType());
            }

            @Override
            public int size() {
                return this.typeDescriptions.size();
            }
        }
    }

    public static class TypeSubstituting
    extends AbstractBase
    implements InGenericShape {
        private final MethodDescription.InGenericShape declaringMethod;
        private final ParameterDescription parameterDescription;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        public TypeSubstituting(MethodDescription.InGenericShape declaringMethod, ParameterDescription parameterDescription, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor2) {
            this.declaringMethod = declaringMethod;
            this.parameterDescription = parameterDescription;
            this.visitor = visitor2;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.parameterDescription.getType().accept(this.visitor);
        }

        @Override
        public MethodDescription.InGenericShape getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.parameterDescription.getIndex();
        }

        @Override
        public boolean isNamed() {
            return this.parameterDescription.isNamed();
        }

        @Override
        public boolean hasModifiers() {
            return this.parameterDescription.hasModifiers();
        }

        @Override
        public int getOffset() {
            return this.parameterDescription.getOffset();
        }

        @Override
        public String getName() {
            return this.parameterDescription.getName();
        }

        @Override
        public int getModifiers() {
            return this.parameterDescription.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.parameterDescription.getDeclaredAnnotations();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.parameterDescription.asDefined();
        }
    }

    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final TypeDescription.Generic parameterType;
        private final List<? extends AnnotationDescription> declaredAnnotations;
        private final String name;
        private final Integer modifiers;
        private final int index;
        private final int offset;

        public Latent(MethodDescription.InDefinedShape declaringMethod, Token token2, int index, int offset) {
            this(declaringMethod, token2.getType(), token2.getAnnotations(), token2.getName(), token2.getModifiers(), index, offset);
        }

        public Latent(MethodDescription.InDefinedShape declaringMethod, TypeDescription.Generic parameterType, int index, int offset) {
            this(declaringMethod, parameterType, Collections.emptyList(), Token.NO_NAME, Token.NO_MODIFIERS, index, offset);
        }

        public Latent(MethodDescription.InDefinedShape declaringMethod, TypeDescription.Generic parameterType, List<? extends AnnotationDescription> declaredAnnotations, String name, Integer modifiers, int index, int offset) {
            this.declaringMethod = declaringMethod;
            this.parameterType = parameterType;
            this.declaredAnnotations = declaredAnnotations;
            this.name = name;
            this.modifiers = modifiers;
            this.index = index;
            this.offset = offset;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.parameterType.accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public boolean isNamed() {
            return this.name != null;
        }

        @Override
        public boolean hasModifiers() {
            return this.modifiers != null;
        }

        @Override
        public String getName() {
            return this.isNamed() ? this.name : super.getName();
        }

        @Override
        public int getModifiers() {
            return this.hasModifiers() ? this.modifiers.intValue() : super.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }
    }

    public static abstract class ForLoadedParameter<T extends AccessibleObject>
    extends InDefinedShape.AbstractBase {
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        protected final T executable;
        protected final int index;

        protected ForLoadedParameter(T executable, int index) {
            this.executable = executable;
            this.index = index;
        }

        @Override
        public String getName() {
            return DISPATCHER.getName((AccessibleObject)this.executable, this.index);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isNamed() {
            return DISPATCHER.isNamePresent((AccessibleObject)this.executable, this.index);
        }

        @Override
        public int getModifiers() {
            return DISPATCHER.getModifiers((AccessibleObject)this.executable, this.index);
        }

        @Override
        public boolean hasModifiers() {
            return this.isNamed() || this.getModifiers() != 0;
        }

        protected static class OfLegacyVmConstructor
        extends InDefinedShape.AbstractBase {
            private final Constructor<?> constructor;
            private final int index;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            protected OfLegacyVmConstructor(Constructor<?> constructor, int index, Class<?>[] parameterType, Annotation[][] parameterAnnotation) {
                this.constructor = constructor;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.parameterType[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfConstructorParameter(this.constructor, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor(this.constructor);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                MethodDescription.InDefinedShape declaringMethod = this.getDeclaringMethod();
                if (this.parameterAnnotation.length != declaringMethod.getParameters().size() && declaringMethod.getDeclaringType().isInnerClass()) {
                    return (AnnotationList)((Object)(this.index == 0 ? new AnnotationList.Empty() : new AnnotationList.ForLoadedAnnotations(this.parameterAnnotation[this.index - 1])));
                }
                return new AnnotationList.ForLoadedAnnotations(this.parameterAnnotation[this.index]);
            }
        }

        protected static class OfLegacyVmMethod
        extends InDefinedShape.AbstractBase {
            private final Method method;
            private final int index;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            protected OfLegacyVmMethod(Method method2, int index, Class<?>[] parameterType, Annotation[][] parameterAnnotation) {
                this.method = method2;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.parameterType[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfMethodParameter(this.method, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod(this.method);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(this.parameterAnnotation[this.index]);
            }
        }

        protected static class OfConstructor
        extends ForLoadedParameter<Constructor<?>> {
            protected OfConstructor(Constructor<?> constructor, int index) {
                super(constructor, index);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs")
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor((Constructor)this.executable);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs")
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(((Constructor)this.executable).getParameterTypes()[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfConstructorParameter((Constructor)this.executable, this.index, ((Constructor)this.executable).getParameterTypes());
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs")
            public AnnotationList getDeclaredAnnotations() {
                MethodDescription.InDefinedShape declaringMethod;
                Annotation[][] annotation = ((Constructor)this.executable).getParameterAnnotations();
                if (annotation.length != (declaringMethod = this.getDeclaringMethod()).getParameters().size() && declaringMethod.getDeclaringType().isInnerClass()) {
                    return (AnnotationList)((Object)(this.index == 0 ? new AnnotationList.Empty() : new AnnotationList.ForLoadedAnnotations(annotation[this.index - 1])));
                }
                return new AnnotationList.ForLoadedAnnotations(annotation[this.index]);
            }
        }

        protected static class OfMethod
        extends ForLoadedParameter<Method> {
            protected OfMethod(Method method2, int index) {
                super(method2, index);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs")
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod((Method)this.executable);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs")
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(((Method)this.executable).getParameterTypes()[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfMethodParameter((Method)this.executable, this.index, ((Method)this.executable).getParameterTypes());
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs")
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(((Method)this.executable).getParameterAnnotations()[this.index]);
            }
        }

        protected static interface Dispatcher {
            public int getModifiers(AccessibleObject var1, int var2);

            public boolean isNamePresent(AccessibleObject var1, int var2);

            public String getName(AccessibleObject var1, int var2);

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public int getModifiers(AccessibleObject executable, int index) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public boolean isNamePresent(AccessibleObject executable, int index) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }

                @Override
                public String getName(AccessibleObject executable, int index) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Parameter");
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava8CapableVm
            implements Dispatcher {
                private static final Object[] NO_ARGUMENTS = new Object[0];
                private final Method getParameters;
                private final Method getName;
                private final Method isNamePresent;
                private final Method getModifiers;

                protected ForJava8CapableVm(Method getParameters, Method getName, Method isNamePresent, Method getModifiers) {
                    this.getParameters = getParameters;
                    this.getName = getName;
                    this.isNamePresent = isNamePresent;
                    this.getModifiers = getModifiers;
                }

                @Override
                public int getModifiers(AccessibleObject executable, int index) {
                    try {
                        return (Integer)this.getModifiers.invoke(this.getParameter(executable, index), NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getModifiers", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getModifiers", exception.getCause());
                    }
                }

                @Override
                public boolean isNamePresent(AccessibleObject executable, int index) {
                    try {
                        return (Boolean)this.isNamePresent.invoke(this.getParameter(executable, index), NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#isNamePresent", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#isNamePresent", exception.getCause());
                    }
                }

                @Override
                public String getName(AccessibleObject executable, int index) {
                    try {
                        return (String)this.getName.invoke(this.getParameter(executable, index), NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getName", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getName", exception.getCause());
                    }
                }

                private Object getParameter(AccessibleObject executable, int index) {
                    try {
                        return Array.get(this.getParameters.invoke((Object)executable, NO_ARGUMENTS), index);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Executable#getParameters", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Executable#getParameters", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.getParameters.equals(((ForJava8CapableVm)object).getParameters)) {
                        return false;
                    }
                    if (!this.getName.equals(((ForJava8CapableVm)object).getName)) {
                        return false;
                    }
                    if (!this.isNamePresent.equals(((ForJava8CapableVm)object).isNamePresent)) {
                        return false;
                    }
                    return this.getModifiers.equals(((ForJava8CapableVm)object).getModifiers);
                }

                public int hashCode() {
                    return (((17 * 31 + this.getParameters.hashCode()) * 31 + this.getName.hashCode()) * 31 + this.isNamePresent.hashCode()) * 31 + this.getModifiers.hashCode();
                }
            }

            public static enum CreationAction implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Dispatcher run() {
                    try {
                        Class<?> executableType = Class.forName("java.lang.reflect.Executable");
                        Class<?> parameterType = Class.forName("java.lang.reflect.Parameter");
                        return new ForJava8CapableVm(executableType.getMethod("getParameters", new Class[0]), parameterType.getMethod("getName", new Class[0]), parameterType.getMethod("isNamePresent", new Class[0]), parameterType.getMethod("getModifiers", new Class[0]));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements ParameterDescription {
        @Override
        public String getName() {
            return ParameterDescription.NAME_PREFIX.concat(String.valueOf(this.getIndex()));
        }

        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public String getActualName() {
            return this.isNamed() ? this.getName() : "";
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public int getOffset() {
            TypeList parameterType = this.getDeclaringMethod().getParameters().asTypeList().asErasures();
            int offset = this.getDeclaringMethod().isStatic() ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
            for (int i2 = 0; i2 < this.getIndex(); ++i2) {
                offset += ((TypeDescription)parameterType.get(i2)).getStackSize().getSize();
            }
            return offset;
        }

        @Override
        public Token asToken(ElementMatcher<? super TypeDescription> matcher) {
            return new Token(this.getType().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment(matcher)), this.getDeclaredAnnotations(), this.isNamed() ? this.getName() : Token.NO_NAME, this.hasModifiers() ? Integer.valueOf(this.getModifiers()) : Token.NO_MODIFIERS);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterDescription)) {
                return false;
            }
            ParameterDescription parameterDescription = (ParameterDescription)other;
            return this.getDeclaringMethod().equals(parameterDescription.getDeclaringMethod()) && this.getIndex() == parameterDescription.getIndex();
        }

        public int hashCode() {
            return this.getDeclaringMethod().hashCode() ^ this.getIndex();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Modifier.toString(this.getModifiers()));
            if (this.getModifiers() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.isVarArgs() ? this.getType().asErasure().getName().replaceFirst("\\[\\]$", "...") : this.getType().asErasure().getName());
            return stringBuilder.append(' ').append(this.getName()).toString();
        }
    }

    public static interface InDefinedShape
    extends ParameterDescription {
        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod();

        public static abstract class AbstractBase
        extends org.assertj.core.internal.bytebuddy.description.method.ParameterDescription$AbstractBase
        implements InDefinedShape {
            @Override
            public InDefinedShape asDefined() {
                return this;
            }
        }
    }

    public static interface InGenericShape
    extends ParameterDescription {
        @Override
        public MethodDescription.InGenericShape getDeclaringMethod();
    }
}

