/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.description.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationList;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationValue;
import org.assertj.core.internal.bytebuddy.description.enumeration.EnumerationDescription;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.method.MethodList;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeList;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.internal.bytebuddy.utility.privilege.SetAccessibleAction;

public interface AnnotationDescription {
    public static final Loadable<?> UNDEFINED = null;

    public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape var1);

    public TypeDescription getAnnotationType();

    public <T extends Annotation> Loadable<T> prepare(Class<T> var1);

    public RetentionPolicy getRetention();

    public Set<ElementType> getElementTypes();

    public boolean isInherited();

    public boolean isDocumented();

    @HashCodeAndEqualsPlugin.Enhance
    public static class Builder {
        private final TypeDescription annotationType;
        private final Map<String, AnnotationValue<?, ?>> annotationValues;

        protected Builder(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
            this.annotationType = annotationType;
            this.annotationValues = annotationValues;
        }

        public static Builder ofType(Class<? extends Annotation> annotationType) {
            return Builder.ofType(TypeDescription.ForLoadedType.of(annotationType));
        }

        public static Builder ofType(TypeDescription annotationType) {
            if (!annotationType.isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + annotationType);
            }
            return new Builder(annotationType, Collections.<String, AnnotationValue<?, ?>>emptyMap());
        }

        public Builder define(String property2, AnnotationValue<?, ?> value) {
            MethodList methodDescriptions = (MethodList)this.annotationType.getDeclaredMethods().filter(ElementMatchers.named(property2));
            if (methodDescriptions.isEmpty()) {
                throw new IllegalArgumentException(this.annotationType + " does not define a property named " + property2);
            }
            if (!((MethodDescription)methodDescriptions.getOnly()).getReturnType().asErasure().isAnnotationValue(value.resolve())) {
                throw new IllegalArgumentException(value + " cannot be assigned to " + property2);
            }
            HashMap annotationValues = new HashMap();
            annotationValues.putAll(this.annotationValues);
            if (annotationValues.put(((MethodDescription)methodDescriptions.getOnly()).getName(), value) != null) {
                throw new IllegalArgumentException("Property already defined: " + property2);
            }
            return new Builder(this.annotationType, annotationValues);
        }

        public Builder define(String property2, Enum<?> value) {
            return this.define(property2, new EnumerationDescription.ForLoadedEnumeration(value));
        }

        public Builder define(String property2, TypeDescription enumerationType, String value) {
            return this.define(property2, new EnumerationDescription.Latent(enumerationType, value));
        }

        public Builder define(String property2, EnumerationDescription value) {
            return this.define(property2, AnnotationValue.ForEnumerationDescription.of(value));
        }

        public Builder define(String property2, Annotation annotation) {
            return this.define(property2, new ForLoadedAnnotation<Annotation>(annotation));
        }

        public Builder define(String property2, AnnotationDescription annotationDescription) {
            return this.define(property2, new AnnotationValue.ForAnnotationDescription(annotationDescription));
        }

        public Builder define(String property2, Class<?> type2) {
            return this.define(property2, TypeDescription.ForLoadedType.of(type2));
        }

        public Builder define(String property2, TypeDescription typeDescription) {
            return this.define(property2, AnnotationValue.ForTypeDescription.of(typeDescription));
        }

        public <T extends Enum<?>> Builder defineEnumerationArray(String property2, Class<T> enumerationType, T ... value) {
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            int index = 0;
            for (T aValue : value) {
                enumerationDescription[index++] = new EnumerationDescription.ForLoadedEnumeration((Enum<?>)aValue);
            }
            return this.defineEnumerationArray(property2, TypeDescription.ForLoadedType.of(enumerationType), enumerationDescription);
        }

        public Builder defineEnumerationArray(String property2, TypeDescription enumerationType, String ... value) {
            if (!enumerationType.isEnum()) {
                throw new IllegalArgumentException("Not an enumeration type: " + enumerationType);
            }
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            for (int i2 = 0; i2 < value.length; ++i2) {
                enumerationDescription[i2] = new EnumerationDescription.Latent(enumerationType, value[i2]);
            }
            return this.defineEnumerationArray(property2, enumerationType, enumerationDescription);
        }

        public Builder defineEnumerationArray(String property2, TypeDescription enumerationType, EnumerationDescription ... value) {
            return this.define(property2, AnnotationValue.ForDescriptionArray.of(enumerationType, value));
        }

        public <T extends Annotation> Builder defineAnnotationArray(String property2, Class<T> annotationType, T ... annotation) {
            return this.defineAnnotationArray(property2, TypeDescription.ForLoadedType.of(annotationType), new AnnotationList.ForLoadedAnnotations((Annotation[])annotation).toArray(new AnnotationDescription[annotation.length]));
        }

        public Builder defineAnnotationArray(String property2, TypeDescription annotationType, AnnotationDescription ... annotationDescription) {
            return this.define(property2, AnnotationValue.ForDescriptionArray.of(annotationType, annotationDescription));
        }

        public Builder defineTypeArray(String property2, Class<?> ... type2) {
            return this.defineTypeArray(property2, new TypeList.ForLoadedTypes(type2).toArray(new TypeDescription[type2.length]));
        }

        public Builder defineTypeArray(String property2, TypeDescription ... typeDescription) {
            return this.define(property2, AnnotationValue.ForDescriptionArray.of(typeDescription));
        }

        public Builder define(String property2, boolean value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, byte value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, char value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, short value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, int value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, long value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, float value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, double value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder define(String property2, String value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, boolean ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, byte ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, char ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, short ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, int ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, long ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, float ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, double ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public Builder defineArray(String property2, String ... value) {
            return this.define(property2, AnnotationValue.ForConstant.of(value));
        }

        public AnnotationDescription build() {
            for (MethodDescription methodDescription : this.annotationType.getDeclaredMethods()) {
                if (this.annotationValues.get(methodDescription.getName()) != null || methodDescription.getDefaultValue() != null) continue;
                throw new IllegalStateException("No value or default value defined for " + methodDescription.getName());
            }
            return new Latent(this.annotationType, this.annotationValues);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.annotationType.equals(((Builder)object).annotationType)) {
                return false;
            }
            return ((Object)this.annotationValues).equals(((Builder)object).annotationValues);
        }

        public int hashCode() {
            return (17 * 31 + this.annotationType.hashCode()) * 31 + ((Object)this.annotationValues).hashCode();
        }
    }

    public static class Latent
    extends AbstractBase {
        private final TypeDescription annotationType;
        private final Map<String, ? extends AnnotationValue<?, ?>> annotationValues;

        protected Latent(TypeDescription annotationType, Map<String, ? extends AnnotationValue<?, ?>> annotationValues) {
            this.annotationType = annotationType;
            this.annotationValues = annotationValues;
        }

        @Override
        public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property2) {
            AnnotationValue<?, ?> value = this.annotationValues.get(property2.getName());
            if (value != null) {
                return value;
            }
            AnnotationValue<?, ?> defaultValue = property2.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("No value defined for: " + property2);
        }

        @Override
        public TypeDescription getAnnotationType() {
            return this.annotationType;
        }

        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            if (!this.annotationType.represents(annotationType)) {
                throw new IllegalArgumentException(annotationType + " does not represent " + this.annotationType);
            }
            return new Loadable<T>(annotationType);
        }

        protected class Loadable<S extends Annotation>
        extends AbstractBase.ForPrepared<S> {
            private final Class<S> annotationType;

            protected Loadable(Class<S> annotationType) {
                this.annotationType = annotationType;
            }

            @Override
            public S load() throws ClassNotFoundException {
                return AnnotationInvocationHandler.of(this.annotationType.getClassLoader(), this.annotationType, Latent.this.annotationValues);
            }

            @Override
            public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property2) {
                return Latent.this.getValue(property2);
            }

            @Override
            public TypeDescription getAnnotationType() {
                return TypeDescription.ForLoadedType.of(this.annotationType);
            }

            @Override
            public <T extends Annotation> org.assertj.core.internal.bytebuddy.description.annotation.AnnotationDescription$Loadable<T> prepare(Class<T> annotationType) {
                return Latent.this.prepare((Class)annotationType);
            }
        }
    }

    public static class ForLoadedAnnotation<S extends Annotation>
    extends AbstractBase.ForPrepared<S> {
        private final S annotation;
        private final Class<S> annotationType;

        protected ForLoadedAnnotation(S annotation) {
            this((Annotation)annotation, annotation.annotationType());
        }

        private ForLoadedAnnotation(S annotation, Class<S> annotationType) {
            this.annotation = annotation;
            this.annotationType = annotationType;
        }

        public static <U extends Annotation> Loadable<U> of(U annotation) {
            return new ForLoadedAnnotation<U>(annotation);
        }

        @Override
        public S load() throws ClassNotFoundException {
            return this.annotationType == this.annotation.annotationType() ? this.annotation : AnnotationInvocationHandler.of(this.annotationType.getClassLoader(), this.annotationType, ForLoadedAnnotation.asValue(this.annotation));
        }

        private static Map<String, AnnotationValue<?, ?>> asValue(Annotation annotation) {
            HashMap annotationValues = new HashMap();
            for (Method property2 : annotation.annotationType().getDeclaredMethods()) {
                try {
                    annotationValues.put(property2.getName(), ForLoadedAnnotation.asValue(property2.invoke((Object)annotation, new Object[0]), property2.getReturnType()));
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot read " + property2, exception.getCause());
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + property2, exception);
                }
            }
            return annotationValues;
        }

        public static AnnotationValue<?, ?> asValue(Object value, Class<?> type2) {
            if (Enum.class.isAssignableFrom(type2)) {
                return AnnotationValue.ForEnumerationDescription.of(new EnumerationDescription.ForLoadedEnumeration((Enum)value));
            }
            if (Enum[].class.isAssignableFrom(type2)) {
                Enum[] element = (Enum[])value;
                EnumerationDescription[] enumerationDescription = new EnumerationDescription[element.length];
                int index = 0;
                for (Enum anElement : element) {
                    enumerationDescription[index++] = new EnumerationDescription.ForLoadedEnumeration(anElement);
                }
                return AnnotationValue.ForDescriptionArray.of(TypeDescription.ForLoadedType.of(type2.getComponentType()), enumerationDescription);
            }
            if (Annotation.class.isAssignableFrom(type2)) {
                return AnnotationValue.ForAnnotationDescription.of(TypeDescription.ForLoadedType.of(type2), ForLoadedAnnotation.asValue((Annotation)value));
            }
            if (Annotation[].class.isAssignableFrom(type2)) {
                Annotation[] element = (Annotation[])value;
                AnnotationDescription[] annotationDescription = new AnnotationDescription[element.length];
                int index = 0;
                for (Annotation anElement : element) {
                    annotationDescription[index++] = new Latent(TypeDescription.ForLoadedType.of(type2.getComponentType()), ForLoadedAnnotation.asValue(anElement));
                }
                return AnnotationValue.ForDescriptionArray.of(TypeDescription.ForLoadedType.of(type2.getComponentType()), annotationDescription);
            }
            if (Class.class.isAssignableFrom(type2)) {
                return AnnotationValue.ForTypeDescription.of(TypeDescription.ForLoadedType.of((Class)value));
            }
            if (Class[].class.isAssignableFrom(type2)) {
                Class[] element = (Class[])value;
                TypeDescription[] typeDescription = new TypeDescription[element.length];
                int index = 0;
                for (Class anElement : element) {
                    typeDescription[index++] = TypeDescription.ForLoadedType.of(anElement);
                }
                return AnnotationValue.ForDescriptionArray.of(typeDescription);
            }
            return AnnotationValue.ForConstant.of(value);
        }

        @Override
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should always be wrapped for clarity")
        public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property2) {
            if (!property2.getDeclaringType().represents(this.annotation.annotationType())) {
                throw new IllegalArgumentException(property2 + " does not represent " + this.annotation.annotationType());
            }
            try {
                Method method2;
                boolean accessible = property2.getDeclaringType().isPublic();
                Method method3 = method2 = property2 instanceof MethodDescription.ForLoadedMethod ? ((MethodDescription.ForLoadedMethod)property2).getLoadedMethod() : null;
                if (method2 == null || method2.getDeclaringClass() != this.annotation.annotationType() || !accessible && !method2.isAccessible()) {
                    method2 = this.annotation.annotationType().getMethod(property2.getName(), new Class[0]);
                    if (!accessible) {
                        AccessController.doPrivileged(new SetAccessibleAction<Method>(method2));
                    }
                }
                return ForLoadedAnnotation.asValue(method2.invoke(this.annotation, new Object[0]), method2.getReturnType());
            }
            catch (InvocationTargetException exception) {
                throw new IllegalStateException("Error reading annotation property " + property2, exception.getCause());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot access annotation property " + property2, exception);
            }
        }

        @Override
        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            if (!this.annotation.annotationType().getName().equals(annotationType.getName())) {
                throw new IllegalArgumentException(annotationType + " does not represent " + this.annotation.annotationType());
            }
            return annotationType == this.annotation.annotationType() ? this : new ForLoadedAnnotation<S>(this.annotation, annotationType);
        }

        @Override
        public TypeDescription getAnnotationType() {
            return TypeDescription.ForLoadedType.of(this.annotation.annotationType());
        }
    }

    public static abstract class AbstractBase
    implements AnnotationDescription {
        private static final ElementType[] DEFAULT_TARGET = new ElementType[]{ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.LOCAL_VARIABLE, ElementType.METHOD, ElementType.PACKAGE, ElementType.PARAMETER, ElementType.TYPE};

        @Override
        public RetentionPolicy getRetention() {
            Loadable<Retention> retention = this.getAnnotationType().getDeclaredAnnotations().ofType(Retention.class);
            return retention == null ? RetentionPolicy.CLASS : retention.loadSilent().value();
        }

        @Override
        public Set<ElementType> getElementTypes() {
            Loadable<Target> target = this.getAnnotationType().getDeclaredAnnotations().ofType(Target.class);
            return new HashSet<ElementType>(Arrays.asList(target == null ? DEFAULT_TARGET : target.loadSilent().value()));
        }

        @Override
        public boolean isInherited() {
            return this.getAnnotationType().getDeclaredAnnotations().isAnnotationPresent(Inherited.class);
        }

        @Override
        public boolean isDocumented() {
            return this.getAnnotationType().getDeclaredAnnotations().isAnnotationPresent(Documented.class);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationDescription)) {
                return false;
            }
            AnnotationDescription annotationDescription = (AnnotationDescription)other;
            TypeDescription annotationType = this.getAnnotationType();
            if (!annotationDescription.getAnnotationType().equals(annotationType)) {
                return false;
            }
            for (MethodDescription.InDefinedShape methodDescription : annotationType.getDeclaredMethods()) {
                if (this.getValue(methodDescription).equals(annotationDescription.getValue(methodDescription))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode2 = 0;
            for (MethodDescription.InDefinedShape methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                hashCode2 += 31 * this.getValue(methodDescription).hashCode();
            }
            return hashCode2;
        }

        public String toString() {
            TypeDescription annotationType = this.getAnnotationType();
            StringBuilder toString2 = new StringBuilder().append('@').append(annotationType.getName()).append('(');
            boolean firstMember = true;
            for (MethodDescription.InDefinedShape methodDescription : annotationType.getDeclaredMethods()) {
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString2.append(", ");
                }
                toString2.append(methodDescription.getName()).append('=').append(this.getValue(methodDescription));
            }
            return toString2.append(')').toString();
        }

        public static abstract class ForPrepared<S extends Annotation>
        extends AbstractBase
        implements Loadable<S> {
            @Override
            public S loadSilent() {
                try {
                    return this.load();
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalStateException("Could not load annotation type or referenced type", exception);
                }
            }
        }
    }

    public static class AnnotationInvocationHandler<T extends Annotation>
    implements InvocationHandler {
        private static final String HASH_CODE = "hashCode";
        private static final String EQUALS = "equals";
        private static final String TO_STRING = "toString";
        private static final Object[] NO_ARGUMENTS = new Object[0];
        private final Class<? extends Annotation> annotationType;
        private final LinkedHashMap<Method, AnnotationValue.Loaded<?>> values;

        protected AnnotationInvocationHandler(Class<T> annotationType, LinkedHashMap<Method, AnnotationValue.Loaded<?>> values2) {
            this.annotationType = annotationType;
            this.values = values2;
        }

        public static <S extends Annotation> S of(ClassLoader classLoader, Class<S> annotationType, Map<String, ? extends AnnotationValue<?, ?>> values2) throws ClassNotFoundException {
            LinkedHashMap loadedValues = new LinkedHashMap();
            Method[] methodArray = annotationType.getDeclaredMethods();
            int n = methodArray.length;
            for (int j = 0; j < n; ++j) {
                Method method2;
                AnnotationValue<?, ?> annotationValue = values2.get((method2 = methodArray[j]).getName());
                loadedValues.put(method2, (annotationValue == null ? AnnotationInvocationHandler.defaultValueOf(method2) : annotationValue).load(classLoader));
            }
            return (S)((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{annotationType}, new AnnotationInvocationHandler<S>(annotationType, loadedValues)));
        }

        private static AnnotationValue<?, ?> defaultValueOf(Method method2) {
            Object defaultValue = method2.getDefaultValue();
            return defaultValue == null ? MissingValue.of(method2) : ForLoadedAnnotation.asValue(defaultValue, method2.getReturnType());
        }

        private static Class<?> asWrapper(Class<?> type2) {
            if (type2.isPrimitive()) {
                if (type2 == Boolean.TYPE) {
                    return Boolean.class;
                }
                if (type2 == Byte.TYPE) {
                    return Byte.class;
                }
                if (type2 == Short.TYPE) {
                    return Short.class;
                }
                if (type2 == Character.TYPE) {
                    return Character.class;
                }
                if (type2 == Integer.TYPE) {
                    return Integer.class;
                }
                if (type2 == Long.TYPE) {
                    return Long.class;
                }
                if (type2 == Float.TYPE) {
                    return Float.class;
                }
                if (type2 == Double.TYPE) {
                    return Double.class;
                }
            }
            return type2;
        }

        @Override
        public Object invoke(Object proxy2, Method method2, Object[] argument) {
            if (method2.getDeclaringClass() != this.annotationType) {
                if (method2.getName().equals(HASH_CODE)) {
                    return this.hashCodeRepresentation();
                }
                if (method2.getName().equals(EQUALS) && method2.getParameterTypes().length == 1) {
                    return this.equalsRepresentation(proxy2, argument[0]);
                }
                if (method2.getName().equals(TO_STRING)) {
                    return this.toStringRepresentation();
                }
                return this.annotationType;
            }
            Object value = this.values.get(method2).resolve();
            if (!AnnotationInvocationHandler.asWrapper(method2.getReturnType()).isAssignableFrom(value.getClass())) {
                throw new AnnotationTypeMismatchException(method2, value.getClass().toString());
            }
            return value;
        }

        protected String toStringRepresentation() {
            StringBuilder toString2 = new StringBuilder();
            toString2.append('@');
            toString2.append(this.annotationType.getName());
            toString2.append('(');
            boolean firstMember = true;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (!entry.getValue().getState().isDefined()) continue;
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString2.append(", ");
                }
                toString2.append(entry.getKey().getName()).append('=').append(entry.getValue().toString());
            }
            toString2.append(')');
            return toString2.toString();
        }

        private int hashCodeRepresentation() {
            int hashCode2 = 0;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (!entry.getValue().getState().isDefined()) continue;
                hashCode2 += 127 * entry.getKey().getName().hashCode() ^ entry.getValue().hashCode();
            }
            return hashCode2;
        }

        private boolean equalsRepresentation(Object self, Object other) {
            Object invocationHandler;
            if (self == other) {
                return true;
            }
            if (!this.annotationType.isInstance(other)) {
                return false;
            }
            if (Proxy.isProxyClass(other.getClass()) && (invocationHandler = Proxy.getInvocationHandler(other)) instanceof AnnotationInvocationHandler) {
                return invocationHandler.equals(this);
            }
            try {
                for (Map.Entry entry : this.values.entrySet()) {
                    try {
                        if (((AnnotationValue.Loaded)entry.getValue()).represents(((Method)entry.getKey()).invoke(other, NO_ARGUMENTS))) continue;
                        return false;
                    }
                    catch (RuntimeException exception) {
                        return false;
                    }
                }
                return true;
            }
            catch (InvocationTargetException ignored) {
                return false;
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException("Could not access annotation property", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationInvocationHandler)) {
                return false;
            }
            AnnotationInvocationHandler that = (AnnotationInvocationHandler)other;
            if (!this.annotationType.equals(that.annotationType)) {
                return false;
            }
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (entry.getValue().equals(that.values.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result2 = this.annotationType.hashCode();
            result2 = 31 * result2 + this.values.hashCode();
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                result2 = 31 * result2 + entry.getValue().hashCode();
            }
            return result2;
        }

        protected static class MissingValue
        extends AnnotationValue.Loaded.AbstractBase<Void>
        implements AnnotationValue<Void, Void> {
            private final Class<? extends Annotation> annotationType;
            private final String property;

            protected MissingValue(Class<? extends Annotation> annotationType, String property2) {
                this.annotationType = annotationType;
                this.property = property2;
            }

            protected static AnnotationValue<?, ?> of(Method method2) {
                return new MissingValue(method2.getDeclaringClass(), method2.getName());
            }

            @Override
            public AnnotationValue.Loaded.State getState() {
                return AnnotationValue.Loaded.State.UNDEFINED;
            }

            @Override
            public boolean represents(Object value) {
                return false;
            }

            @Override
            public AnnotationValue.Loaded<Void> load(ClassLoader classLoader) {
                return this;
            }

            @Override
            public AnnotationValue.Loaded<Void> loadSilent(ClassLoader classLoader) {
                return this;
            }

            @Override
            public Void resolve() {
                throw new IncompleteAnnotationException(this.annotationType, this.property);
            }
        }
    }

    public static interface Loadable<S extends Annotation>
    extends AnnotationDescription {
        public S load() throws ClassNotFoundException;

        public S loadSilent();
    }
}

