/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.uri.ShouldHaveAnchor;
import org.assertj.core.error.uri.ShouldHaveAuthority;
import org.assertj.core.error.uri.ShouldHaveHost;
import org.assertj.core.error.uri.ShouldHaveParameter;
import org.assertj.core.error.uri.ShouldHavePath;
import org.assertj.core.error.uri.ShouldHavePort;
import org.assertj.core.error.uri.ShouldHaveProtocol;
import org.assertj.core.error.uri.ShouldHaveQuery;
import org.assertj.core.error.uri.ShouldHaveUserInfo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Uris;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Urls {
    private static final Urls INSTANCE = new Urls();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Urls instance() {
        return INSTANCE;
    }

    Urls() {
    }

    public void assertHasProtocol(AssertionInfo info2, URL actual, String protocol) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getProtocol(), protocol)) {
            throw this.failures.failure(info2, ShouldHaveProtocol.shouldHaveProtocol(actual, protocol));
        }
    }

    public void assertHasPath(AssertionInfo info2, URL actual, String path) {
        Comparables.assertNotNull(info2, actual);
        Preconditions.checkArgument(path != null, "Expecting given path not to be null", new Object[0]);
        if (!Objects.areEqual(actual.getPath(), path)) {
            throw this.failures.failure(info2, ShouldHavePath.shouldHavePath(actual, path));
        }
    }

    public void assertHasPort(AssertionInfo info2, URL actual, int expected) {
        Comparables.assertNotNull(info2, actual);
        if (actual.getPort() != expected) {
            throw this.failures.failure(info2, ShouldHavePort.shouldHavePort(actual, expected));
        }
    }

    public void assertHasHost(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getHost(), expected)) {
            throw this.failures.failure(info2, ShouldHaveHost.shouldHaveHost(actual, expected));
        }
    }

    public void assertHasAuthority(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getAuthority(), expected)) {
            throw this.failures.failure(info2, ShouldHaveAuthority.shouldHaveAuthority(actual, expected));
        }
    }

    public void assertHasQuery(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getQuery(), expected)) {
            throw this.failures.failure(info2, ShouldHaveQuery.shouldHaveQuery(actual, expected));
        }
    }

    public void assertHasAnchor(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getRef(), expected)) {
            throw this.failures.failure(info2, ShouldHaveAnchor.shouldHaveAnchor(actual, expected));
        }
    }

    public void assertHasUserInfo(AssertionInfo info2, URL actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getUserInfo(), expected)) {
            throw this.failures.failure(info2, ShouldHaveUserInfo.shouldHaveUserInfo(actual, expected));
        }
    }

    public void assertHasParameter(AssertionInfo info2, URL actual, String name) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (!parameters2.containsKey(name)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, name));
        }
    }

    public void assertHasParameter(AssertionInfo info2, URL actual, String expectedParameterName, String expectedParameterValue) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (!parameters2.containsKey(expectedParameterName)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue));
        }
        List<String> values2 = parameters2.get(expectedParameterName);
        if (!values2.contains(expectedParameterValue)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue, values2));
        }
    }

    public void assertHasNoParameters(AssertionInfo info2, URL actual) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (!parameters2.isEmpty()) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameters(actual, parameters2.keySet()));
        }
    }

    public void assertHasNoParameter(AssertionInfo info2, URL actual, String name) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (parameters2.containsKey(name)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameter(actual, name, parameters2.get(name)));
        }
    }

    public void assertHasNoParameter(AssertionInfo info2, URL actual, String name, String unwantedValue) {
        List<String> values2;
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (parameters2.containsKey(name) && (values2 = parameters2.get(name)).contains(unwantedValue)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameter(actual, name, unwantedValue, values2));
        }
    }
}

