/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.assertj.core.util.DoubleComparator;
import org.assertj.core.util.FloatComparator;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.ClassUtils;

public class TypeComparators {
    private static final double DOUBLE_COMPARATOR_PRECISION = 1.0E-15;
    private static final DoubleComparator DEFAULT_DOUBLE_COMPARATOR = new DoubleComparator(1.0E-15);
    private static final float FLOAT_COMPARATOR_PRECISION = 1.0E-6f;
    private static final FloatComparator DEFAULT_FLOAT_COMPARATOR = new FloatComparator(1.0E-6f);
    private static final Comparator<Class<?>> CLASS_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> class1, Class<?> class2) {
            return class1.getName().compareTo(class2.getName());
        }
    };
    @VisibleForTesting
    Map<Class<?>, Comparator<?>> typeComparators = new TreeMap(CLASS_COMPARATOR);

    public static TypeComparators defaultTypeComparators() {
        TypeComparators comparatorByType = new TypeComparators();
        comparatorByType.put(Double.class, DEFAULT_DOUBLE_COMPARATOR);
        comparatorByType.put(Float.class, DEFAULT_FLOAT_COMPARATOR);
        return comparatorByType;
    }

    public Comparator<?> get(Class<?> clazz) {
        Comparator<?> comparator2 = this.typeComparators.get(clazz);
        if (comparator2 == null) {
            for (Class<?> superClass : ClassUtils.getAllSuperclasses(clazz)) {
                if (!this.typeComparators.containsKey(superClass)) continue;
                return this.typeComparators.get(superClass);
            }
            for (Class<?> interfaceClass : ClassUtils.getAllInterfaces(clazz)) {
                if (!this.typeComparators.containsKey(interfaceClass)) continue;
                return this.typeComparators.get(interfaceClass);
            }
        }
        return comparator2;
    }

    public <T> void put(Class<T> clazz, Comparator<? super T> comparator2) {
        this.typeComparators.put(clazz, comparator2);
    }

    public boolean isEmpty() {
        return this.typeComparators.isEmpty();
    }

    public int hashCode() {
        return this.typeComparators.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TypeComparators && Objects.equals(this.typeComparators, ((TypeComparators)obj).typeComparators);
    }

    public String toString() {
        ArrayList<String> registeredComparatorsDescription = new ArrayList<String>();
        for (Map.Entry<Class<?>, Comparator<?>> registeredComparator : this.typeComparators.entrySet()) {
            registeredComparatorsDescription.add(TypeComparators.formatRegisteredComparator(registeredComparator));
        }
        return String.format("{%s}", Strings.join(registeredComparatorsDescription).with(", "));
    }

    private static String formatRegisteredComparator(Map.Entry<Class<?>, Comparator<?>> next) {
        return String.format("%s -> %s", next.getKey().getSimpleName(), next.getValue());
    }
}

