/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeBlank;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeEqualIgnoringCase;
import org.assertj.core.error.ShouldBeEqualIgnoringNewLineDifferences;
import org.assertj.core.error.ShouldBeEqualIgnoringNewLines;
import org.assertj.core.error.ShouldBeEqualIgnoringWhitespace;
import org.assertj.core.error.ShouldBeEqualNormalizingWhitespace;
import org.assertj.core.error.ShouldBeLowerCase;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSubstring;
import org.assertj.core.error.ShouldBeUpperCase;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldContainCharSequenceOnlyOnce;
import org.assertj.core.error.ShouldContainOneOrMoreWhitespaces;
import org.assertj.core.error.ShouldContainOnlyDigits;
import org.assertj.core.error.ShouldContainOnlyWhitespaces;
import org.assertj.core.error.ShouldContainPattern;
import org.assertj.core.error.ShouldContainSequenceOfCharSequence;
import org.assertj.core.error.ShouldContainSubsequenceOfCharSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldMatchPattern;
import org.assertj.core.error.ShouldNotBeBlank;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotBeEqualIgnoringCase;
import org.assertj.core.error.ShouldNotBeEqualIgnoringWhitespace;
import org.assertj.core.error.ShouldNotBeEqualNormalizingWhitespace;
import org.assertj.core.error.ShouldNotContainAnyWhitespaces;
import org.assertj.core.error.ShouldNotContainCharSequence;
import org.assertj.core.error.ShouldNotContainOnlyWhitespaces;
import org.assertj.core.error.ShouldNotContainPattern;
import org.assertj.core.error.ShouldNotEndWith;
import org.assertj.core.error.ShouldNotMatchPattern;
import org.assertj.core.error.ShouldNotStartWith;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.InputStreamsException;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.xml.XmlStringPrettyFormatter;

public class Strings {
    private static final Strings INSTANCE = new Strings();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Strings instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Strings() {
        this(StandardComparisonStrategy.instance());
    }

    public Strings(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertNullOrEmpty(AssertionInfo info2, CharSequence actual) {
        if (actual != null && Strings.hasContent(actual)) {
            throw this.failures.failure(info2, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
        }
    }

    public void assertEmpty(AssertionInfo info2, CharSequence actual) {
        this.assertNotNull(info2, actual);
        if (Strings.hasContent(actual)) {
            throw this.failures.failure(info2, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }

    public void assertNotEmpty(AssertionInfo info2, CharSequence actual) {
        this.assertNotNull(info2, actual);
        if (!Strings.hasContent(actual)) {
            throw this.failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    private static boolean hasContent(CharSequence s) {
        return s.length() > 0;
    }

    public void assertBlank(AssertionInfo info2, CharSequence actual) {
        if (!this.isBlank(actual)) {
            throw this.failures.failure(info2, ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    public void assertNotBlank(AssertionInfo info2, CharSequence actual) {
        if (this.isBlank(actual)) {
            throw this.failures.failure(info2, ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    private boolean isBlank(CharSequence actual) {
        return this.isNullOrEmpty(actual) || this.strictlyContainsWhitespaces(actual);
    }

    private boolean containsWhitespaces(CharSequence actual) {
        return !this.isNullOrEmpty(actual) && this.containsOneOrMoreWhitespaces(actual);
    }

    private boolean containsOnlyWhitespaces(CharSequence actual) {
        return !this.isNullOrEmpty(actual) && this.strictlyContainsWhitespaces(actual);
    }

    private boolean isNullOrEmpty(CharSequence actual) {
        return actual == null || actual.length() == 0;
    }

    private boolean containsOneOrMoreWhitespaces(CharSequence actual) {
        return actual.chars().anyMatch(Character::isWhitespace);
    }

    private boolean strictlyContainsWhitespaces(CharSequence actual) {
        return actual.chars().allMatch(Character::isWhitespace);
    }

    public void assertContainsWhitespaces(AssertionInfo info2, CharSequence actual) {
        if (!this.containsWhitespaces(actual)) {
            throw this.failures.failure(info2, ShouldContainOneOrMoreWhitespaces.shouldContainOneOrMoreWhitespaces(actual));
        }
    }

    public void assertContainsOnlyWhitespaces(AssertionInfo info2, CharSequence actual) {
        if (!this.containsOnlyWhitespaces(actual)) {
            throw this.failures.failure(info2, ShouldContainOnlyWhitespaces.shouldContainOnlyWhitespaces(actual));
        }
    }

    public void assertDoesNotContainAnyWhitespaces(AssertionInfo info2, CharSequence actual) {
        if (this.containsWhitespaces(actual)) {
            throw this.failures.failure(info2, ShouldNotContainAnyWhitespaces.shouldNotContainAnyWhitespaces(actual));
        }
    }

    public void assertDoesNotContainOnlyWhitespaces(AssertionInfo info2, CharSequence actual) {
        if (this.containsOnlyWhitespaces(actual)) {
            throw this.failures.failure(info2, ShouldNotContainOnlyWhitespaces.shouldNotContainOnlyWhitespaces(actual));
        }
    }

    public void assertJavaBlank(AssertionInfo info2, CharSequence actual) {
        if (!this.isJavaBlank(actual)) {
            throw this.failures.failure(info2, ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    public void assertNotJavaBlank(AssertionInfo info2, CharSequence actual) {
        if (this.isJavaBlank(actual)) {
            throw this.failures.failure(info2, ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    private boolean isJavaBlank(CharSequence actual) {
        if (actual == null || actual.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < actual.length(); ++i2) {
            if (Character.isWhitespace(actual.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public void assertHasSize(AssertionInfo info2, CharSequence actual, int expectedSize) {
        this.assertNotNull(info2, actual);
        CommonValidations.checkSizes(actual, actual.length(), expectedSize, info2);
    }

    public void assertHasLineCount(AssertionInfo info2, CharSequence actual, int expectedLineCount) {
        this.assertNotNull(info2, actual);
        LineNumberReader reader2 = new LineNumberReader(new StringReader(actual.toString()));
        try {
            while (reader2.readLine() != null) {
            }
        }
        catch (IOException e) {
            throw new InputStreamsException(String.format("Unable to count lines in `%s`", actual), e);
        }
        CommonValidations.checkLineCounts(actual, reader2.getLineNumber(), expectedLineCount, info2);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, CharSequence actual, Iterable<?> other) {
        this.assertNotNull(info2, actual);
        CommonValidations.hasSameSizeAsCheck(info2, (Object)actual, other, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info2, CharSequence actual, Object array) {
        Objects.instance().assertNotNull(info2, actual);
        Arrays.assertIsArray(info2, array);
        CommonValidations.hasSameSizeAsCheck(info2, (Object)actual, array, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info2, CharSequence actual, CharSequence other) {
        Objects.instance().assertNotNull(info2, actual);
        CommonValidations.checkOtherIsNotNull(other, "CharSequence or String");
        CommonValidations.checkSameSizes(info2, actual, actual.length(), other.length());
    }

    public void assertContains(AssertionInfo info2, CharSequence actual, CharSequence ... values2) {
        this.doCommonCheckForCharSequence(info2, actual, values2);
        Set notFound = java.util.Arrays.stream(values2).filter(value -> !this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (notFound.isEmpty()) {
            return;
        }
        if (notFound.size() == 1 && values2.length == 1) {
            throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(actual, values2[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(actual, values2, notFound, this.comparisonStrategy));
    }

    public void assertContainsOnlyDigits(AssertionInfo info2, CharSequence actual) {
        this.assertNotNull(info2, actual);
        if (actual.length() == 0) {
            throw this.failures.failure(info2, ShouldContainOnlyDigits.shouldContainOnlyDigits(actual));
        }
        for (int index = 0; index < actual.length(); ++index) {
            char character = actual.charAt(index);
            if (Character.isDigit(character)) continue;
            throw this.failures.failure(info2, ShouldContainOnlyDigits.shouldContainOnlyDigits(actual, character, index));
        }
    }

    private void checkIsNotNull(CharSequence ... values2) {
        if (values2 == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private void checkIsNotEmpty(CharSequence ... values2) {
        if (values2.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private boolean stringContains(CharSequence actual, CharSequence sequence) {
        return this.comparisonStrategy.stringContains(actual.toString(), sequence.toString());
    }

    public void assertContainsIgnoringCase(AssertionInfo info2, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info2, actual);
        if (!actual.toString().toLowerCase().contains(sequence.toString().toLowerCase())) {
            throw this.failures.failure(info2, ShouldContainCharSequence.shouldContainIgnoringCase(actual, sequence));
        }
    }

    public void assertDoesNotContain(AssertionInfo info2, CharSequence actual, CharSequence ... values2) {
        this.doCommonCheckForCharSequence(info2, actual, values2);
        Set found = java.util.Arrays.stream(values2).filter(value -> this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (found.isEmpty()) {
            return;
        }
        if (found.size() == 1 && values2.length == 1) {
            throw this.failures.failure(info2, ShouldNotContainCharSequence.shouldNotContain(actual, values2[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info2, ShouldNotContainCharSequence.shouldNotContain(actual, values2, found, this.comparisonStrategy));
    }

    private void checkCharSequenceIsNotNull(CharSequence sequence) {
        Preconditions.checkNotNull(sequence, "The char sequence to look for should not be null");
    }

    public void assertEqualsIgnoringCase(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        if (!this.areEqualIgnoringCase(actual, expected)) {
            throw this.failures.failure(info2, ShouldBeEqualIgnoringCase.shouldBeEqual(actual, expected));
        }
    }

    public void assertNotEqualsIgnoringCase(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        if (this.areEqualIgnoringCase(actual, expected)) {
            throw this.failures.failure(info2, ShouldNotBeEqualIgnoringCase.shouldNotBeEqualIgnoringCase(actual, expected));
        }
    }

    private boolean areEqualIgnoringCase(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        return actual.toString().equalsIgnoreCase(expected.toString());
    }

    public void assertIsEqualToNormalizingNewlines(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        String expectedNormalized;
        String actualNormalized = Strings.normalizeNewlines(actual);
        if (!actualNormalized.equals(expectedNormalized = Strings.normalizeNewlines(expected))) {
            throw this.failures.failure(info2, ShouldBeEqualIgnoringNewLineDifferences.shouldBeEqualIgnoringNewLineDifferences(actual, expected));
        }
    }

    private static String normalizeNewlines(CharSequence actual) {
        return actual.toString().replace("\r\n", "\n");
    }

    public void assertEqualsIgnoringWhitespace(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        if (!this.areEqualIgnoringWhitespace(actual, expected)) {
            throw this.failures.failure(info2, ShouldBeEqualIgnoringWhitespace.shouldBeEqualIgnoringWhitespace(actual, expected));
        }
    }

    public void assertNotEqualsIgnoringWhitespace(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        if (this.areEqualIgnoringWhitespace(actual, expected)) {
            throw this.failures.failure(info2, ShouldNotBeEqualIgnoringWhitespace.shouldNotBeEqualIgnoringWhitespace(actual, expected));
        }
    }

    private boolean areEqualIgnoringWhitespace(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        this.checkCharSequenceIsNotNull(expected);
        return this.removeAllWhitespaces(actual).equals(this.removeAllWhitespaces(expected));
    }

    private String removeAllWhitespaces(CharSequence toBeStripped) {
        StringBuilder result2 = new StringBuilder(toBeStripped.length());
        for (int i2 = 0; i2 < toBeStripped.length(); ++i2) {
            char c = toBeStripped.charAt(i2);
            if (Character.isWhitespace(c)) continue;
            result2.append(c);
        }
        return result2.toString();
    }

    public void assertEqualsNormalizingWhitespace(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        if (!this.areEqualNormalizingWhitespace(actual, expected)) {
            throw this.failures.failure(info2, ShouldBeEqualNormalizingWhitespace.shouldBeEqualNormalizingWhitespace(actual, expected));
        }
    }

    public void assertNotEqualsNormalizingWhitespace(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        if (this.areEqualNormalizingWhitespace(actual, expected)) {
            throw this.failures.failure(info2, ShouldNotBeEqualNormalizingWhitespace.shouldNotBeEqualNormalizingWhitespace(actual, expected));
        }
    }

    private boolean areEqualNormalizingWhitespace(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        this.checkCharSequenceIsNotNull(expected);
        return this.normalizeWhitespace(actual).equals(this.normalizeWhitespace(expected));
    }

    private String normalizeWhitespace(CharSequence toNormalize) {
        StringBuilder result2 = new StringBuilder(toNormalize.length());
        boolean lastWasSpace = true;
        for (int i2 = 0; i2 < toNormalize.length(); ++i2) {
            char c = toNormalize.charAt(i2);
            if (Character.isWhitespace(c)) {
                if (!lastWasSpace) {
                    result2.append(' ');
                }
                lastWasSpace = true;
                continue;
            }
            result2.append(c);
            lastWasSpace = false;
        }
        return result2.toString().trim();
    }

    public void assertContainsOnlyOnce(AssertionInfo info2, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info2, actual);
        int sequenceOccurrencesInActual = this.countOccurrences(sequence, actual);
        if (sequenceOccurrencesInActual == 1) {
            return;
        }
        throw this.failures.failure(info2, ShouldContainCharSequenceOnlyOnce.shouldContainOnlyOnce(actual, sequence, sequenceOccurrencesInActual, this.comparisonStrategy));
    }

    private int countOccurrences(CharSequence sequenceToSearch, CharSequence actual) {
        String strToSearch = sequenceToSearch.toString();
        String strActual = actual.toString();
        int occurrences = 0;
        for (int i2 = 0; i2 <= strActual.length() - strToSearch.length(); ++i2) {
            if (!this.comparisonStrategy.areEqual(strActual.substring(i2, i2 + sequenceToSearch.length()), strToSearch)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public void assertStartsWith(AssertionInfo info2, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info2, actual);
        if (!this.comparisonStrategy.stringStartsWith(actual.toString(), prefix.toString())) {
            throw this.failures.failure(info2, ShouldStartWith.shouldStartWith(actual, prefix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotStartWith(AssertionInfo info2, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info2, actual);
        if (this.comparisonStrategy.stringStartsWith(actual.toString(), prefix.toString())) {
            throw this.failures.failure(info2, ShouldNotStartWith.shouldNotStartWith(actual, prefix, this.comparisonStrategy));
        }
    }

    private static void failIfPrefixIsNull(CharSequence prefix) {
        Preconditions.checkNotNull(prefix, "The given prefix should not be null");
    }

    public void assertEndsWith(AssertionInfo info2, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info2, actual);
        if (!this.comparisonStrategy.stringEndsWith(actual.toString(), suffix.toString())) {
            throw this.failures.failure(info2, ShouldEndWith.shouldEndWith(actual, suffix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotEndWith(AssertionInfo info2, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info2, actual);
        if (this.comparisonStrategy.stringEndsWith(actual.toString(), suffix.toString())) {
            throw this.failures.failure(info2, ShouldNotEndWith.shouldNotEndWith(actual, suffix, this.comparisonStrategy));
        }
    }

    private static void failIfSuffixIsNull(CharSequence suffix) {
        Preconditions.checkNotNull(suffix, "The given suffix should not be null");
    }

    public void assertMatches(AssertionInfo info2, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info2, actual);
        if (!Pattern.matches(regex.toString(), actual)) {
            throw this.failures.failure(info2, ShouldMatchPattern.shouldMatch(actual, regex));
        }
    }

    public void assertDoesNotMatch(AssertionInfo info2, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info2, actual);
        if (Pattern.matches(regex.toString(), actual)) {
            throw this.failures.failure(info2, ShouldNotMatchPattern.shouldNotMatch(actual, regex));
        }
    }

    private void checkRegexIsNotNull(CharSequence regex) {
        if (regex == null) {
            throw this.patternToMatchIsNull();
        }
    }

    public void assertMatches(AssertionInfo info2, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info2, actual);
        if (!pattern.matcher(actual).matches()) {
            throw this.failures.failure(info2, ShouldMatchPattern.shouldMatch(actual, pattern.pattern()));
        }
    }

    public void assertDoesNotMatch(AssertionInfo info2, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        if (actual != null && pattern.matcher(actual).matches()) {
            throw this.failures.failure(info2, ShouldNotMatchPattern.shouldNotMatch(actual, pattern.pattern()));
        }
    }

    private void checkIsNotNull(Pattern pattern) {
        if (pattern == null) {
            throw this.patternToMatchIsNull();
        }
    }

    private NullPointerException patternToMatchIsNull() {
        return new NullPointerException("The regular expression pattern to match should not be null");
    }

    private void assertNotNull(AssertionInfo info2, CharSequence actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    public void assertContainsSequence(AssertionInfo info2, CharSequence actual, CharSequence[] sequence) {
        String strSequence;
        this.doCommonCheckForCharSequence(info2, actual, sequence);
        Set notFound = java.util.Arrays.stream(sequence).filter(value -> !this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!notFound.isEmpty()) {
            if (notFound.size() == 1 && sequence.length == 1) {
                throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(actual, sequence[0], this.comparisonStrategy));
            }
            throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(actual, sequence, notFound, this.comparisonStrategy));
        }
        if (sequence.length == 1) {
            return;
        }
        String strActual = actual.toString();
        if (!this.stringContains(strActual, strSequence = java.util.Arrays.stream(sequence).collect(Collectors.joining()))) {
            throw this.failures.failure(info2, ShouldContainSequenceOfCharSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
        }
    }

    public void assertContainsSubsequence(AssertionInfo info2, CharSequence actual, CharSequence[] subsequence) {
        this.doCommonCheckForCharSequence(info2, actual, subsequence);
        Set notFound = java.util.Arrays.stream(subsequence).filter(value -> !this.stringContains(actual, (CharSequence)value)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!notFound.isEmpty()) {
            if (notFound.size() == 1 && subsequence.length == 1) {
                throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(actual, subsequence[0], this.comparisonStrategy));
            }
            throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(actual, subsequence, notFound, this.comparisonStrategy));
        }
        if (subsequence.length == 1) {
            return;
        }
        String actualRest = this.removeUpTo(actual.toString(), subsequence[0]);
        for (int i2 = 1; i2 < subsequence.length; ++i2) {
            if (!this.stringContains(actualRest, subsequence[i2])) {
                throw this.failures.failure(info2, ShouldContainSubsequenceOfCharSequence.shouldContainSubsequence(actual, subsequence, i2 - 1, this.comparisonStrategy));
            }
            actualRest = this.removeUpTo(actualRest, subsequence[i2]);
        }
    }

    private String removeUpTo(String string, CharSequence toRemove) {
        int index = this.indexOf(string, toRemove);
        return string.substring(index + toRemove.length());
    }

    private int indexOf(String string, CharSequence toFind) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (!this.comparisonStrategy.stringStartsWith(string.substring(i2), toFind.toString())) continue;
            return i2;
        }
        return -1;
    }

    public void assertXmlEqualsTo(AssertionInfo info2, CharSequence actualXml, CharSequence expectedXml) {
        this.checkCharSequenceIsNotNull(expectedXml);
        this.assertNotNull(info2, actualXml);
        String formattedActualXml = XmlStringPrettyFormatter.xmlPrettyFormat(actualXml.toString());
        String formattedExpectedXml = XmlStringPrettyFormatter.xmlPrettyFormat(expectedXml.toString());
        if (!this.comparisonStrategy.areEqual(formattedActualXml, formattedExpectedXml)) {
            throw this.failures.failure(info2, ShouldBeEqual.shouldBeEqual(formattedActualXml, formattedExpectedXml, this.comparisonStrategy, info2.representation()));
        }
    }

    public void assertIsSubstringOf(AssertionInfo info2, CharSequence actual, CharSequence sequence) {
        this.assertNotNull(info2, actual);
        Preconditions.checkNotNull(sequence, "Expecting CharSequence not to be null");
        if (this.stringContains(sequence.toString(), actual.toString())) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeSubstring.shouldBeSubstring(actual, sequence, this.comparisonStrategy));
    }

    public void assertContainsPattern(AssertionInfo info2, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info2, actual);
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.find()) {
            throw this.failures.failure(info2, ShouldContainPattern.shouldContainPattern(actual, pattern.pattern()));
        }
    }

    public void assertContainsPattern(AssertionInfo info2, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info2, actual);
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.find()) {
            throw this.failures.failure(info2, ShouldContainPattern.shouldContainPattern(actual, pattern.pattern()));
        }
    }

    public void assertDoesNotContainPattern(AssertionInfo info2, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        Pattern pattern = Pattern.compile(regex.toString());
        this.assertDoesNotContainPattern(info2, actual, pattern);
    }

    public void assertDoesNotContainPattern(AssertionInfo info2, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info2, actual);
        Matcher matcher = pattern.matcher(actual);
        if (matcher.find()) {
            throw this.failures.failure(info2, ShouldNotContainPattern.shouldNotContainPattern(actual, pattern.pattern()));
        }
    }

    private void checkCharSequenceArrayDoesNotHaveNullElements(CharSequence[] values2) {
        if (values2.length == 1) {
            this.checkCharSequenceIsNotNull(values2[0]);
        } else {
            for (int i2 = 0; i2 < values2.length; ++i2) {
                Preconditions.checkNotNull(values2[i2], "Expecting CharSequence elements not to be null but found one at index " + i2);
            }
        }
    }

    public void assertIsEqualToIgnoringNewLines(AssertionInfo info2, CharSequence actual, CharSequence expected) {
        String expectedWithoutNewLines;
        String actualWithoutNewLines = Strings.removeNewLines(actual);
        if (!actualWithoutNewLines.equals(expectedWithoutNewLines = Strings.removeNewLines(expected))) {
            throw this.failures.failure(info2, ShouldBeEqualIgnoringNewLines.shouldBeEqualIgnoringNewLines(actual, expected));
        }
    }

    public void assertLowerCase(AssertionInfo info2, CharSequence actual) {
        this.assertNotNull(info2, actual);
        if (actual.equals(actual.toString().toLowerCase())) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeLowerCase.shouldBeLowerCase(actual));
    }

    public void assertUpperCase(AssertionInfo info2, CharSequence actual) {
        this.assertNotNull(info2, actual);
        if (actual.equals(actual.toString().toUpperCase())) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeUpperCase.shouldBeUpperCase(actual));
    }

    private static String removeNewLines(CharSequence text) {
        String normalizedText = Strings.normalizeNewlines(text);
        return normalizedText.toString().replace("\n", "");
    }

    private void doCommonCheckForCharSequence(AssertionInfo info2, CharSequence actual, CharSequence[] sequence) {
        this.assertNotNull(info2, actual);
        this.checkIsNotNull(sequence);
        this.checkIsNotEmpty(sequence);
        this.checkCharSequenceArrayDoesNotHaveNullElements(sequence);
    }
}

