/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.concurrent.Future;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.future.ShouldBeCancelled;
import org.assertj.core.error.future.ShouldBeDone;
import org.assertj.core.error.future.ShouldNotBeCancelled;
import org.assertj.core.error.future.ShouldNotBeDone;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Futures {
    private static final Futures INSTANCE = new Futures();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Futures instance() {
        return INSTANCE;
    }

    public void assertIsCancelled(AssertionInfo info2, Future<?> actual) {
        this.assertNotNull(info2, actual);
        if (!actual.isCancelled()) {
            throw this.failures.failure(info2, ShouldBeCancelled.shouldBeCancelled(actual));
        }
    }

    public void assertIsNotCancelled(AssertionInfo info2, Future<?> actual) {
        this.assertNotNull(info2, actual);
        if (actual.isCancelled()) {
            throw this.failures.failure(info2, ShouldNotBeCancelled.shouldNotBeCancelled(actual));
        }
    }

    public void assertIsDone(AssertionInfo info2, Future<?> actual) {
        this.assertNotNull(info2, actual);
        if (!actual.isDone()) {
            throw this.failures.failure(info2, ShouldBeDone.shouldBeDone(actual));
        }
    }

    public void assertIsNotDone(AssertionInfo info2, Future<?> actual) {
        this.assertNotNull(info2, actual);
        if (actual.isDone()) {
            throw this.failures.failure(info2, ShouldNotBeDone.shouldNotBeDone(actual));
        }
    }

    private void assertNotNull(AssertionInfo info2, Future<?> actual) {
        Objects.instance().assertNotNull(info2, actual);
    }
}

