/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.error.ConstructorInvoker;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class ShouldBeEqual
implements AssertionErrorFactory {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "%nExpecting:%n <%s>%nto be equal to:%n <%s>%nbut was not.";
    private static final String EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR = "%nExpecting:%n <%s>%nto be equal to:%n <%s>%n%s%nbut was not.";
    private static final Class<?>[] MSG_ARG_TYPES = Arrays.array(String.class, String.class, String.class);
    private static final Class<?>[] MSG_ARG_TYPES_FOR_ASSERTION_FAILED_ERROR = Arrays.array(String.class, Object.class, Object.class);
    protected final Object actual;
    protected final Object expected;
    @VisibleForTesting
    final MessageFormatter messageFormatter = MessageFormatter.instance();
    private final ComparisonStrategy comparisonStrategy;
    private Representation representation;
    @VisibleForTesting
    ConstructorInvoker constructorInvoker = new ConstructorInvoker();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, Representation representation) {
        return new ShouldBeEqual(actual, expected, StandardComparisonStrategy.instance(), representation);
    }

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Representation representation) {
        return new ShouldBeEqual(actual, expected, comparisonStrategy, representation);
    }

    @VisibleForTesting
    ShouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Representation representation) {
        this.actual = actual;
        this.expected = expected;
        this.comparisonStrategy = comparisonStrategy;
        this.representation = representation;
    }

    @Override
    public AssertionError newAssertionError(Description description2, Representation representation) {
        AssertionError assertionFailedError;
        String message2 = this.smartErrorMessage(description2, representation);
        if (this.comparisonStrategy.isStandard() && !this.actualAndExpectedHaveSameStringRepresentation()) {
            assertionFailedError = this.assertionFailedError(message2);
            if (assertionFailedError != null) {
                return assertionFailedError;
            }
            AssertionError error2 = this.comparisonFailure(description2);
            if (error2 != null) {
                return error2;
            }
        }
        if ((assertionFailedError = this.assertionFailedError(message2)) != null) {
            return assertionFailedError;
        }
        return Failures.instance().failure(message2);
    }

    private boolean actualAndExpectedHaveSameStringRepresentation() {
        return Objects.areEqual(this.representation.toStringOf(this.actual), this.representation.toStringOf(this.expected));
    }

    private String smartErrorMessage(Description description2, Representation representation) {
        if (this.actualAndExpectedHaveSameStringRepresentation()) {
            return this.defaultDetailedErrorMessage(description2, representation);
        }
        return this.comparisonStrategy.isStandard() ? this.messageFormatter.format(description2, representation, EXPECTED_BUT_WAS_MESSAGE, this.actual, this.expected) : this.messageFormatter.format(description2, representation, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.actual, this.expected, this.comparisonStrategy);
    }

    private String defaultDetailedErrorMessage(Description description2, Representation representation) {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return this.messageFormatter.format(description2, representation, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.detailedActual(), this.detailedExpected(), this.comparisonStrategy);
        }
        return this.messageFormatter.format(description2, representation, EXPECTED_BUT_WAS_MESSAGE, this.detailedActual(), this.detailedExpected());
    }

    private AssertionError assertionFailedError(String message2) {
        try {
            Object o = this.constructorInvoker.newInstance("org.opentest4j.AssertionFailedError", MSG_ARG_TYPES_FOR_ASSERTION_FAILED_ERROR, message2, this.expected, this.actual);
            if (o instanceof AssertionError) {
                AssertionError assertionError = (AssertionError)o;
                Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
                return assertionError;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private AssertionError comparisonFailure(Description description2) {
        try {
            AssertionError comparisonFailure = this.newComparisonFailure(this.descriptionFormatter.format(description2).trim());
            Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(comparisonFailure);
            return comparisonFailure;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private AssertionError newComparisonFailure(String description2) throws Exception {
        Object o = this.constructorInvoker.newInstance("org.junit.ComparisonFailure", MSG_ARG_TYPES, this.msgArgs(description2));
        if (o instanceof AssertionError) {
            return (AssertionError)o;
        }
        return null;
    }

    private Object[] msgArgs(String description2) {
        return Arrays.array(description2, this.representation.toStringOf(this.expected), this.representation.toStringOf(this.actual));
    }

    private String detailedActual() {
        return this.representation.unambiguousToStringOf(this.actual);
    }

    private String detailedExpected() {
        return this.representation.unambiguousToStringOf(this.expected);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ShouldBeEqual other = (ShouldBeEqual)o;
        if (!Objects.areEqual(this.actual, other.actual)) {
            return false;
        }
        return Objects.areEqual(this.expected, other.expected);
    }

    public int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + Objects.hashCodeFor(this.actual);
        result2 = 31 * result2 + Objects.hashCodeFor(this.expected);
        return result2;
    }
}

