/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Descriptable;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public class ThrowableTypeAssert<T extends Throwable>
implements Descriptable<ThrowableTypeAssert<T>> {
    @VisibleForTesting
    protected final Class<? extends T> expectedThrowableType;
    protected Description description;

    public ThrowableTypeAssert(Class<? extends T> throwableType) {
        this.expectedThrowableType = Objects.requireNonNull(throwableType, "exceptionType");
    }

    public ThrowableAssertAlternative<T> isThrownBy(ThrowableAssert.ThrowingCallable throwingCallable) {
        Throwable throwable = ThrowableAssert.catchThrowable(throwingCallable);
        ((AbstractAssert)((AbstractThrowableAssert)((AbstractObjectAssert)((Object)Assertions.assertThat(throwable))).as(this.description)).hasBeenThrown()).isInstanceOf((Class)this.expectedThrowableType);
        Throwable c = throwable;
        return (ThrowableAssertAlternative)new ThrowableAssertAlternative<Throwable>(c).as(this.description);
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> as(String description2, Object ... args2) {
        return this.describedAs(description2, args2);
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> as(Description description2) {
        return this.describedAs(description2);
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> describedAs(String description2, Object ... args2) {
        this.description = new TextDescription(description2, args2);
        return this;
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> describedAs(Description description2) {
        this.description = description2;
        return this;
    }
}

