/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBigIntegerAssert;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractClassAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractFutureAssert;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.AbstractInstantAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLocalDateAssert;
import org.assertj.core.api.AbstractLocalDateTimeAssert;
import org.assertj.core.api.AbstractLocalTimeAssert;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractOffsetDateTimeAssert;
import org.assertj.core.api.AbstractOffsetTimeAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AbstractShortArrayAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AbstractUriAssert;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicBooleanAssert;
import org.assertj.core.api.AtomicIntegerArrayAssert;
import org.assertj.core.api.AtomicIntegerAssert;
import org.assertj.core.api.AtomicIntegerFieldUpdaterAssert;
import org.assertj.core.api.AtomicLongArrayAssert;
import org.assertj.core.api.AtomicLongAssert;
import org.assertj.core.api.AtomicLongFieldUpdaterAssert;
import org.assertj.core.api.AtomicMarkableReferenceAssert;
import org.assertj.core.api.AtomicReferenceArrayAssert;
import org.assertj.core.api.AtomicReferenceAssert;
import org.assertj.core.api.AtomicReferenceFieldUpdaterAssert;
import org.assertj.core.api.AtomicStampedReferenceAssert;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BigIntegerAssert;
import org.assertj.core.api.BooleanArrayAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.ByteAssert;
import org.assertj.core.api.CharArrayAssert;
import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.CharacterAssert;
import org.assertj.core.api.ClassLoadingStrategyFactory;
import org.assertj.core.api.CompletableFutureAssert;
import org.assertj.core.api.DateAssert;
import org.assertj.core.api.DoubleArrayAssert;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.DoublePredicateAssert;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.FileAssert;
import org.assertj.core.api.FloatArrayAssert;
import org.assertj.core.api.FloatAssert;
import org.assertj.core.api.FutureAssert;
import org.assertj.core.api.GenericComparableAssert;
import org.assertj.core.api.InputStreamAssert;
import org.assertj.core.api.InstantAssert;
import org.assertj.core.api.IntArrayAssert;
import org.assertj.core.api.IntPredicateAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.LocalDateAssert;
import org.assertj.core.api.LocalDateTimeAssert;
import org.assertj.core.api.LocalTimeAssert;
import org.assertj.core.api.LongArrayAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.LongPredicateAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OffsetDateTimeAssert;
import org.assertj.core.api.OffsetTimeAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.OptionalDoubleAssert;
import org.assertj.core.api.OptionalIntAssert;
import org.assertj.core.api.OptionalLongAssert;
import org.assertj.core.api.PathAssert;
import org.assertj.core.api.ProxyableClassAssert;
import org.assertj.core.api.ProxyableIterableAssert;
import org.assertj.core.api.ProxyableListAssert;
import org.assertj.core.api.ProxyableMapAssert;
import org.assertj.core.api.ProxyableObjectArrayAssert;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.api.ProxyablePredicateAssert;
import org.assertj.core.api.ShortArrayAssert;
import org.assertj.core.api.ShortAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.UriAssert;
import org.assertj.core.api.UrlAssert;
import org.assertj.core.api.ZonedDateTimeAssert;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.TypeCache;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.MethodDelegation;
import org.assertj.core.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.This;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;

public class Assumptions {
    private static ByteBuddy BYTE_BUDDY = new ByteBuddy().with(TypeValidation.DISABLED).with(new AuxiliaryType.NamingStrategy.SuffixingRandom("Assertj$Assumptions"));
    private static final Implementation ASSUMPTION = MethodDelegation.to(AssumptionMethodInterceptor.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction<TypeCache.SimpleKey>(TypeCache.Sort.SOFT);

    @CheckReturnValue
    public static <T> ProxyableObjectAssert<T> assumeThat(T actual) {
        return Assumptions.asAssumption(ProxyableObjectAssert.class, Object.class, actual);
    }

    @CheckReturnValue
    public static AbstractStringAssert<?> assumeThat(String actual) {
        return Assumptions.asAssumption(StringAssert.class, String.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractBigDecimalAssert<?> assumeThat(BigDecimal actual) {
        return Assumptions.asAssumption(BigDecimalAssert.class, BigDecimal.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractBigIntegerAssert<?> assumeThat(BigInteger actual) {
        return Assumptions.asAssumption(BigIntegerAssert.class, BigInteger.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractUriAssert<?> assumeThat(URI actual) {
        return Assumptions.asAssumption(UriAssert.class, URI.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractUrlAssert<?> assumeThat(URL actual) {
        return Assumptions.asAssumption(UrlAssert.class, URL.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractBooleanAssert<?> assumeThat(boolean actual) {
        return Assumptions.asAssumption(BooleanAssert.class, Boolean.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractBooleanAssert<?> assumeThat(Boolean actual) {
        return Assumptions.asAssumption(BooleanAssert.class, Boolean.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractBooleanArrayAssert<?> assumeThat(boolean[] actual) {
        return Assumptions.asAssumption(BooleanArrayAssert.class, boolean[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractByteAssert<?> assumeThat(byte actual) {
        return Assumptions.asAssumption(ByteAssert.class, Byte.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractByteAssert<?> assumeThat(Byte actual) {
        return Assumptions.asAssumption(ByteAssert.class, Byte.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractByteArrayAssert<?> assumeThat(byte[] actual) {
        return Assumptions.asAssumption(ByteArrayAssert.class, byte[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractCharacterAssert<?> assumeThat(char actual) {
        return Assumptions.asAssumption(CharacterAssert.class, Character.class, (Object)Character.valueOf(actual));
    }

    @CheckReturnValue
    public static AbstractCharacterAssert<?> assumeThat(Character actual) {
        return Assumptions.asAssumption(CharacterAssert.class, Character.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractCharArrayAssert<?> assumeThat(char[] actual) {
        return Assumptions.asAssumption(CharArrayAssert.class, char[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assumeThat(CharSequence actual) {
        return Assumptions.asAssumption(CharSequenceAssert.class, CharSequence.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assumeThat(StringBuilder actual) {
        return Assumptions.asAssumption(CharSequenceAssert.class, CharSequence.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assumeThat(StringBuffer actual) {
        return Assumptions.asAssumption(CharSequenceAssert.class, CharSequence.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractShortAssert<?> assumeThat(short actual) {
        return Assumptions.asAssumption(ShortAssert.class, Short.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractShortAssert<?> assumeThat(Short actual) {
        return Assumptions.asAssumption(ShortAssert.class, Short.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractShortArrayAssert<?> assumeThat(short[] actual) {
        return Assumptions.asAssumption(ShortArrayAssert.class, short[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractIntegerAssert<?> assumeThat(int actual) {
        return Assumptions.asAssumption(IntegerAssert.class, Integer.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractIntegerAssert<?> assumeThat(Integer actual) {
        return Assumptions.asAssumption(IntegerAssert.class, Integer.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractIntArrayAssert<?> assumeThat(int[] actual) {
        return Assumptions.asAssumption(IntArrayAssert.class, int[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractLongAssert<?> assumeThat(long actual) {
        return Assumptions.asAssumption(LongAssert.class, Long.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractLongAssert<?> assumeThat(Long actual) {
        return Assumptions.asAssumption(LongAssert.class, Long.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractLongArrayAssert<?> assumeThat(long[] actual) {
        return Assumptions.asAssumption(LongArrayAssert.class, long[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractFloatAssert<?> assumeThat(float actual) {
        return Assumptions.asAssumption(FloatAssert.class, Float.class, (Object)Float.valueOf(actual));
    }

    @CheckReturnValue
    public static AbstractFloatAssert<?> assumeThat(Float actual) {
        return Assumptions.asAssumption(FloatAssert.class, Float.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractFloatArrayAssert<?> assumeThat(float[] actual) {
        return Assumptions.asAssumption(FloatArrayAssert.class, float[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractDoubleAssert<?> assumeThat(double actual) {
        return Assumptions.asAssumption(DoubleAssert.class, Double.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractDoubleAssert<?> assumeThat(Double actual) {
        return Assumptions.asAssumption(DoubleAssert.class, Double.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractDoubleArrayAssert<?> assumeThat(double[] actual) {
        return Assumptions.asAssumption(DoubleArrayAssert.class, double[].class, (Object)actual);
    }

    @CheckReturnValue
    public static AtomicBooleanAssert assumeThat(AtomicBoolean actual) {
        return Assumptions.asAssumption(AtomicBooleanAssert.class, AtomicBoolean.class, (Object)actual);
    }

    @CheckReturnValue
    public static AtomicIntegerAssert assumeThat(AtomicInteger actual) {
        return Assumptions.asAssumption(AtomicIntegerAssert.class, AtomicInteger.class, (Object)actual);
    }

    @CheckReturnValue
    public static AtomicIntegerArrayAssert assumeThat(AtomicIntegerArray actual) {
        return Assumptions.asAssumption(AtomicIntegerArrayAssert.class, AtomicIntegerArray.class, (Object)actual);
    }

    @CheckReturnValue
    public static <OBJECT> AtomicIntegerFieldUpdaterAssert<OBJECT> assumeThat(AtomicIntegerFieldUpdater<OBJECT> actual) {
        return Assumptions.asAssumption(AtomicIntegerFieldUpdaterAssert.class, AtomicIntegerFieldUpdater.class, actual);
    }

    @CheckReturnValue
    public static AtomicLongAssert assumeThat(AtomicLong actual) {
        return Assumptions.asAssumption(AtomicLongAssert.class, AtomicLong.class, (Object)actual);
    }

    @CheckReturnValue
    public static AtomicLongArrayAssert assumeThat(AtomicLongArray actual) {
        return Assumptions.asAssumption(AtomicLongArrayAssert.class, AtomicLongArray.class, (Object)actual);
    }

    @CheckReturnValue
    public static <OBJECT> AtomicLongFieldUpdaterAssert<OBJECT> assumeThat(AtomicLongFieldUpdater<OBJECT> actual) {
        return Assumptions.asAssumption(AtomicLongFieldUpdaterAssert.class, AtomicLongFieldUpdater.class, actual);
    }

    @CheckReturnValue
    public static <VALUE> AtomicReferenceAssert<VALUE> assumeThat(AtomicReference<VALUE> actual) {
        return Assumptions.asAssumption(AtomicReferenceAssert.class, AtomicReference.class, actual);
    }

    @CheckReturnValue
    public static <ELEMENT> AtomicReferenceArrayAssert<ELEMENT> assumeThat(AtomicReferenceArray<ELEMENT> actual) {
        return Assumptions.asAssumption(AtomicReferenceArrayAssert.class, AtomicReferenceArray.class, actual);
    }

    @CheckReturnValue
    public static <FIELD, OBJECT> AtomicReferenceFieldUpdaterAssert<FIELD, OBJECT> assumeThat(AtomicReferenceFieldUpdater<OBJECT, FIELD> actual) {
        return Assumptions.asAssumption(AtomicReferenceFieldUpdaterAssert.class, AtomicReferenceFieldUpdater.class, actual);
    }

    @CheckReturnValue
    public static <VALUE> AtomicMarkableReferenceAssert<VALUE> assumeThat(AtomicMarkableReference<VALUE> actual) {
        return Assumptions.asAssumption(AtomicMarkableReferenceAssert.class, AtomicMarkableReference.class, actual);
    }

    @CheckReturnValue
    public static <VALUE> AtomicStampedReferenceAssert<VALUE> assumeThat(AtomicStampedReference<VALUE> actual) {
        return Assumptions.asAssumption(AtomicStampedReferenceAssert.class, AtomicStampedReference.class, actual);
    }

    @CheckReturnValue
    public static AbstractClassAssert<?> assumeThat(Class<?> actual) {
        return Assumptions.asAssumption(ProxyableClassAssert.class, Class.class, actual);
    }

    @CheckReturnValue
    public static AbstractDateAssert<?> assumeThat(Date actual) {
        return Assumptions.asAssumption(DateAssert.class, Date.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractFileAssert<?> assumeThat(File actual) {
        return Assumptions.asAssumption(FileAssert.class, File.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractPathAssert<?> assumeThat(Path actual) {
        return Assumptions.asAssumption(PathAssert.class, Path.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractInputStreamAssert<?, ? extends InputStream> assumeThat(InputStream actual) {
        return Assumptions.asAssumption(InputStreamAssert.class, InputStream.class, (Object)actual);
    }

    @CheckReturnValue
    public static <RESULT> AbstractFutureAssert<?, ? extends Future<? extends RESULT>, RESULT> assumeThat(Future<RESULT> future) {
        return Assumptions.asAssumption(FutureAssert.class, Future.class, future);
    }

    @CheckReturnValue
    public static <ELEMENT> ProxyableIterableAssert<ELEMENT> assumeThat(Iterable<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(ProxyableIterableAssert.class, Iterable.class, actual);
    }

    @CheckReturnValue
    public static <ELEMENT> ProxyableIterableAssert<ELEMENT> assumeThat(Iterator<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(ProxyableIterableAssert.class, Iterator.class, actual);
    }

    @CheckReturnValue
    public static <ELEMENT> FactoryBasedNavigableListAssert<ProxyableListAssert<ELEMENT>, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> assumeThat(List<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(ProxyableListAssert.class, List.class, actual);
    }

    @CheckReturnValue
    public static <T> ProxyableObjectArrayAssert<T> assumeThat(T[] actual) {
        return Assumptions.asAssumption(ProxyableObjectArrayAssert.class, Object[].class, actual);
    }

    @CheckReturnValue
    public static <K, V> AbstractMapAssert<?, ?, K, V> assumeThat(Map<K, V> actual) {
        return Assumptions.asAssumption(ProxyableMapAssert.class, Map.class, actual);
    }

    @CheckReturnValue
    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assumeThat(T actual) {
        return Assumptions.asAssumption(GenericComparableAssert.class, Comparable.class, actual);
    }

    @CheckReturnValue
    public static AbstractThrowableAssert<?, ? extends Throwable> assumeThat(Throwable actual) {
        return Assumptions.asAssumption(ThrowableAssert.class, Throwable.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractThrowableAssert<?, ? extends Throwable> assumeThatThrownBy(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return Assumptions.asAssumption(ThrowableAssert.class, Throwable.class, (Object)Assertions.catchThrowable(shouldRaiseThrowable));
    }

    @CheckReturnValue
    public static AbstractThrowableAssert<?, ? extends Throwable> assumeThatCode(ThrowableAssert.ThrowingCallable shouldRaiseOrNotThrowable) {
        return Assumptions.assumeThat(Assertions.catchThrowable(shouldRaiseOrNotThrowable));
    }

    @CheckReturnValue
    public static <T> ProxyablePredicateAssert<T> assumeThat(Predicate<T> actual) {
        return Assumptions.asAssumption(ProxyablePredicateAssert.class, Predicate.class, actual);
    }

    @CheckReturnValue
    public static IntPredicateAssert assumeThat(IntPredicate actual) {
        return Assumptions.asAssumption(IntPredicateAssert.class, IntPredicate.class, (Object)actual);
    }

    @CheckReturnValue
    public static LongPredicateAssert assumeThat(LongPredicate actual) {
        return Assumptions.asAssumption(LongPredicateAssert.class, LongPredicate.class, (Object)actual);
    }

    @CheckReturnValue
    public static DoublePredicateAssert assumeThat(DoublePredicate actual) {
        return Assumptions.asAssumption(DoublePredicateAssert.class, DoublePredicate.class, (Object)actual);
    }

    @CheckReturnValue
    public static <RESULT> CompletableFutureAssert<RESULT> assumeThat(CompletableFuture<RESULT> actual) {
        return Assumptions.asAssumption(CompletableFutureAssert.class, CompletableFuture.class, actual);
    }

    @CheckReturnValue
    public static <RESULT> CompletableFutureAssert<RESULT> assumeThat(CompletionStage<RESULT> actual) {
        return Assumptions.asAssumption(CompletableFutureAssert.class, CompletionStage.class, actual);
    }

    @CheckReturnValue
    public static <VALUE> OptionalAssert<VALUE> assumeThat(Optional<VALUE> actual) {
        return Assumptions.asAssumption(OptionalAssert.class, Optional.class, actual);
    }

    @CheckReturnValue
    public static OptionalDoubleAssert assumeThat(OptionalDouble actual) {
        return Assumptions.asAssumption(OptionalDoubleAssert.class, OptionalDouble.class, (Object)actual);
    }

    @CheckReturnValue
    public static OptionalIntAssert assumeThat(OptionalInt actual) {
        return Assumptions.asAssumption(OptionalIntAssert.class, OptionalInt.class, (Object)actual);
    }

    @CheckReturnValue
    public static OptionalLongAssert assumeThat(OptionalLong actual) {
        return Assumptions.asAssumption(OptionalLongAssert.class, OptionalLong.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractZonedDateTimeAssert<?> assumeThat(ZonedDateTime actual) {
        return Assumptions.asAssumption(ZonedDateTimeAssert.class, ZonedDateTime.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractLocalDateTimeAssert<?> assumeThat(LocalDateTime actual) {
        return Assumptions.asAssumption(LocalDateTimeAssert.class, LocalDateTime.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractOffsetDateTimeAssert<?> assumeThat(OffsetDateTime actual) {
        return Assumptions.asAssumption(OffsetDateTimeAssert.class, OffsetDateTime.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractOffsetTimeAssert<?> assumeThat(OffsetTime actual) {
        return Assumptions.asAssumption(OffsetTimeAssert.class, OffsetTime.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractLocalTimeAssert<?> assumeThat(LocalTime actual) {
        return Assumptions.asAssumption(LocalTimeAssert.class, LocalTime.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractLocalDateAssert<?> assumeThat(LocalDate actual) {
        return Assumptions.asAssumption(LocalDateAssert.class, LocalDate.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractInstantAssert<?> assumeThat(Instant actual) {
        return Assumptions.asAssumption(InstantAssert.class, Instant.class, (Object)actual);
    }

    @CheckReturnValue
    public static <ELEMENT> AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> assumeThat(Stream<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(ProxyableListAssert.class, Stream.class, actual);
    }

    @CheckReturnValue
    public static AbstractListAssert<?, List<? extends Double>, Double, ObjectAssert<Double>> assumeThat(DoubleStream actual) {
        return Assumptions.asAssumption(ProxyableListAssert.class, DoubleStream.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractListAssert<?, List<? extends Long>, Long, ObjectAssert<Long>> assumeThat(LongStream actual) {
        return Assumptions.asAssumption(ProxyableListAssert.class, LongStream.class, (Object)actual);
    }

    @CheckReturnValue
    public static AbstractListAssert<?, List<? extends Integer>, Integer, ObjectAssert<Integer>> assumeThat(IntStream actual) {
        return Assumptions.asAssumption(ProxyableListAssert.class, IntStream.class, (Object)actual);
    }

    private static <ASSERTION, ACTUAL> ASSERTION asAssumption(Class<ASSERTION> assertionType, Class<ACTUAL> actualType, Object actual) {
        return Assumptions.asAssumption(assertionType, Arrays.array(actualType), Arrays.array(actual));
    }

    private static <ASSERTION> ASSERTION asAssumption(Class<ASSERTION> assertionType, Class<?>[] constructorTypes, Object ... constructorParams) {
        try {
            Class<ASSERTION> type2 = Assumptions.createAssumptionClass(assertionType);
            Constructor<ASSERTION> constructor = type2.getConstructor(constructorTypes);
            return constructor.newInstance(constructorParams);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <ASSERTION> Class<? extends ASSERTION> createAssumptionClass(Class<ASSERTION> assertClass) {
        TypeCache.SimpleKey cacheKey = new TypeCache.SimpleKey(assertClass, new Class[0]);
        return CACHE.findOrInsert(Assumptions.class.getClassLoader(), cacheKey, () -> Assumptions.generateAssumptionClass(assertClass));
    }

    protected static <ASSERTION> Class<? extends ASSERTION> generateAssumptionClass(Class<ASSERTION> assertionType) {
        return BYTE_BUDDY.subclass(assertionType).method(ElementMatchers.any()).intercept(ASSUMPTION).make().load(Assumptions.class.getClassLoader(), ClassLoadingStrategyFactory.classLoadingStrategy(assertionType)).getLoaded();
    }

    private static RuntimeException assumptionNotMet(AssertionError assertionError) throws ReflectiveOperationException {
        Class<?> assumptionClass = Assumptions.getAssumptionClass("org.junit.AssumptionViolatedException");
        if (assumptionClass != null) {
            return Assumptions.assumptionNotMet(assumptionClass, assertionError);
        }
        assumptionClass = Assumptions.getAssumptionClass("org.opentest4j.TestAbortedException");
        if (assumptionClass != null) {
            return Assumptions.assumptionNotMet(assumptionClass, assertionError);
        }
        assumptionClass = Assumptions.getAssumptionClass("org.testng.SkipException");
        if (assumptionClass != null) {
            return Assumptions.assumptionNotMet(assumptionClass, assertionError);
        }
        throw new IllegalStateException("Assumptions require JUnit, opentest4j or TestNG on the classpath");
    }

    private static Class<?> getAssumptionClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static RuntimeException assumptionNotMet(Class<?> exceptionClass, AssertionError e) throws ReflectiveOperationException {
        return (RuntimeException)exceptionClass.getConstructor(String.class, Throwable.class).newInstance("assumption was not met due to: " + ((Throwable)((Object)e)).getMessage(), e);
    }

    private static AbstractAssert<?, ?> asAssumption(AbstractAssert<?, ?> assertion) {
        Object actual = assertion.actual;
        if (assertion instanceof StringAssert) {
            return Assumptions.asAssumption(StringAssert.class, String.class, actual);
        }
        if (assertion instanceof FactoryBasedNavigableListAssert) {
            return Assumptions.asAssumption(ProxyableListAssert.class, List.class, actual);
        }
        if (assertion instanceof ProxyableIterableAssert) {
            return Assumptions.asAssumption(ProxyableIterableAssert.class, Iterable.class, actual);
        }
        if (assertion instanceof ProxyableMapAssert) {
            return Assumptions.asAssumption(ProxyableMapAssert.class, Map.class, actual);
        }
        if (assertion instanceof AbstractObjectArrayAssert) {
            return Assumptions.asAssumption(ProxyableObjectArrayAssert.class, Object[].class, actual);
        }
        if (assertion instanceof IterableSizeAssert) {
            return Assumptions.asIterableSizeAssumption(assertion);
        }
        if (assertion instanceof MapSizeAssert) {
            return Assumptions.asMapSizeAssumption(assertion);
        }
        if (assertion instanceof ProxyableObjectAssert) {
            return Assumptions.asAssumption(ObjectAssert.class, Object.class, actual);
        }
        if (assertion instanceof ObjectAssert) {
            return Assumptions.asAssumption(ObjectAssert.class, Object.class, actual);
        }
        throw new IllegalArgumentException("Unsupported assumption creation for " + assertion.getClass());
    }

    private static AbstractAssert<?, ?> asMapSizeAssumption(AbstractAssert<?, ?> assertion) {
        MapSizeAssert mapSizeAssert = (MapSizeAssert)assertion;
        Class[] constructorTypes = Arrays.array(AbstractMapAssert.class, Integer.class);
        return Assumptions.asAssumption(MapSizeAssert.class, constructorTypes, mapSizeAssert.returnToMap(), assertion.actual);
    }

    private static AbstractAssert<?, ?> asIterableSizeAssumption(AbstractAssert<?, ?> assertion) {
        IterableSizeAssert iterableSizeAssert = (IterableSizeAssert)assertion;
        Class[] constructorTypes = Arrays.array(AbstractIterableAssert.class, Integer.class);
        return Assumptions.asAssumption(IterableSizeAssert.class, constructorTypes, iterableSizeAssert.returnToIterable(), assertion.actual);
    }

    private static final class AssumptionMethodInterceptor {
        private AssumptionMethodInterceptor() {
        }

        @RuntimeType
        public static Object intercept(@This AbstractAssert<?, ?> assertion, @SuperCall Callable<Object> proxy2) throws Exception {
            try {
                Object result2 = proxy2.call();
                if (result2 != assertion && result2 instanceof AbstractAssert) {
                    return Assumptions.asAssumption((AbstractAssert)result2).withAssertionState(assertion);
                }
                return result2;
            }
            catch (AssertionError e) {
                throw Assumptions.assumptionNotMet(e);
            }
        }
    }
}

