/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractMapSizeAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.description.Description;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.Maps;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractMapAssert<SELF extends AbstractMapAssert<SELF, ACTUAL, K, V>, ACTUAL extends Map<K, V>, K, V>
extends AbstractObjectAssert<SELF, ACTUAL>
implements EnumerableAssert<SELF, Map.Entry<? extends K, ? extends V>> {
    @VisibleForTesting
    Maps maps = Maps.instance();

    public AbstractMapAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF allSatisfy(BiConsumer<? super K, ? super V> entryRequirements) {
        this.maps.assertAllSatisfy(this.info, (Map)this.actual, entryRequirements);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public void isNullOrEmpty() {
        this.maps.assertNullOrEmpty(this.info, (Map)this.actual);
    }

    @Override
    public void isEmpty() {
        this.maps.assertEmpty(this.info, (Map)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.maps.assertNotEmpty(this.info, (Map)this.actual);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.maps.assertHasSize(this.info, (Map)this.actual, expected);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSameSizeAs(Map<?, ?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF contains(Map.Entry<? extends K, ? extends V> ... entries2) {
        this.maps.assertContains(this.info, (Map)this.actual, entries2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsAnyOf(Map.Entry<? extends K, ? extends V> ... entries2) {
        this.maps.assertContainsAnyOf(this.info, (Map)this.actual, entries2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsAllEntriesOf(Map<? extends K, ? extends V> other) {
        Map.Entry[] entries2 = other.entrySet().toArray(new Map.Entry[other.size()]);
        this.maps.assertContains(this.info, (Map)this.actual, entries2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsEntry(K key2, V value) {
        this.maps.assertContains(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key2, value)));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(K key2, Condition<? super V> valueCondition) {
        this.maps.assertHasEntrySatisfying((AssertionInfo)this.info, (Map)this.actual, key2, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(K key2, Consumer<? super V> valueRequirements) {
        this.maps.assertHasEntrySatisfying((AssertionInfo)this.info, (Map)this.actual, key2, valueRequirements);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(Condition<? super Map.Entry<K, V>> entryCondition) {
        this.maps.assertHasEntrySatisfying(this.info, (Map)this.actual, entryCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(Condition<? super K> keyCondition, Condition<? super V> valueCondition) {
        this.maps.assertHasEntrySatisfyingConditions(this.info, (Map)this.actual, keyCondition, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasKeySatisfying(Condition<? super K> keyCondition) {
        this.maps.assertHasKeySatisfying(this.info, (Map)this.actual, keyCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasValueSatisfying(Condition<? super V> valueCondition) {
        this.maps.assertHasValueSatisfying(this.info, (Map)this.actual, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContain(Map.Entry<? extends K, ? extends V> ... entries2) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, entries2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainEntry(K key2, V value) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key2, value)));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsKey(K key2) {
        return this.containsKeys(key2);
    }

    public SELF containsKeys(K ... keys2) {
        this.maps.assertContainsKeys(this.info, (Map)this.actual, keys2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainKey(K key2) {
        return this.doesNotContainKeys(key2);
    }

    public SELF doesNotContainKeys(K ... keys2) {
        this.maps.assertDoesNotContainKeys(this.info, (Map)this.actual, keys2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsOnlyKeys(K ... keys2) {
        this.maps.assertContainsOnlyKeys(this.info, (Map)this.actual, keys2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsValue(V value) {
        this.maps.assertContainsValue(this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsValues(V ... values2) {
        this.maps.assertContainsValues(this.info, (Map)this.actual, values2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainValue(V value) {
        this.maps.assertDoesNotContainValue(this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsOnly(Map.Entry<? extends K, ? extends V> ... entries2) {
        this.maps.assertContainsOnly(this.info, (Map)this.actual, entries2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsExactly(Map.Entry<? extends K, ? extends V> ... entries2) {
        this.maps.assertContainsExactly(this.info, (Map)this.actual, entries2);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    @Deprecated
    public SELF usingElementComparator(Comparator<? super Map.Entry<? extends K, ? extends V>> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @Deprecated
    public SELF usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @CheckReturnValue
    public SELF as(String description2, Object ... args2) {
        return (SELF)((AbstractMapAssert)super.as(description2, args2));
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description2) {
        return (SELF)((AbstractMapAssert)super.as(description2));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(Description description2) {
        return (SELF)((AbstractMapAssert)super.describedAs(description2));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(String description2, Object ... args2) {
        return (SELF)((AbstractMapAssert)super.describedAs(description2, args2));
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.doesNotHave((Condition)condition));
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        return (SELF)((AbstractMapAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.has((Condition)condition));
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        return (SELF)((AbstractMapAssert)super.hasSameClassAs(other));
    }

    @Override
    public SELF hasToString(String expectedToString) {
        return (SELF)((AbstractMapAssert)super.hasToString(expectedToString));
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.is((Condition)condition));
    }

    @Override
    public SELF isEqualTo(Object expected) {
        return (SELF)((AbstractMapAssert)super.isEqualTo(expected));
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type2) {
        return (SELF)((AbstractMapAssert)super.isExactlyInstanceOf((Class)type2));
    }

    @Override
    public SELF isIn(Iterable<?> values2) {
        return (SELF)((AbstractMapAssert)super.isIn((Iterable)values2));
    }

    @Override
    public SELF isIn(Object ... values2) {
        return (SELF)((AbstractMapAssert)super.isIn(values2));
    }

    @Override
    public SELF isInstanceOf(Class<?> type2) {
        return (SELF)((AbstractMapAssert)super.isInstanceOf((Class)type2));
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.isNot((Condition)condition));
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        return (SELF)((AbstractMapAssert)super.isNotEqualTo(other));
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type2) {
        return (SELF)((AbstractMapAssert)super.isNotExactlyInstanceOf((Class)type2));
    }

    @Override
    public SELF isNotIn(Iterable<?> values2) {
        return (SELF)((AbstractMapAssert)super.isNotIn((Iterable)values2));
    }

    @Override
    public SELF isNotIn(Object ... values2) {
        return (SELF)((AbstractMapAssert)super.isNotIn(values2));
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type2) {
        return (SELF)((AbstractMapAssert)super.isNotInstanceOf((Class)type2));
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isNotNull() {
        return (SELF)((AbstractMapAssert)super.isNotNull());
    }

    @Override
    public SELF isNotSameAs(Object other) {
        return (SELF)((AbstractMapAssert)super.isNotSameAs(other));
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isSameAs(Object expected) {
        return (SELF)((AbstractMapAssert)super.isSameAs(expected));
    }

    @Override
    @CheckReturnValue
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args2) {
        return (SELF)((AbstractMapAssert)super.overridingErrorMessage(newErrorMessage, args2));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        return (SELF)((AbstractMapAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        return (SELF)((AbstractMapAssert)super.usingComparator((Comparator)customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF withFailMessage(String newErrorMessage, Object ... args2) {
        return (SELF)((AbstractMapAssert)super.withFailMessage(newErrorMessage, args2));
    }

    @Override
    @CheckReturnValue
    public SELF withThreadDumpOnError() {
        return (SELF)((AbstractMapAssert)super.withThreadDumpOnError());
    }

    @CheckReturnValue
    public AbstractMapSizeAssert<SELF, ACTUAL, K, V> size() {
        Preconditions.checkNotNull(this.actual, "Can not perform assertions on the size of a null map.");
        return new MapSizeAssert(this, ((Map)this.actual).size());
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extracting(Object ... keys2) {
        this.isNotNull();
        List extractedValues = Stream.of(keys2).map(((Map)this.actual)::get).collect(Collectors.toList());
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(keys2);
        String description2 = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return this.newListAssertInstance(extractedValues).as(description2, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(String ... keys2) {
        Tuple values2 = Extractors.byName(keys2).extract(this.actual);
        List<Object> valuesFlattened = AbstractMapAssert.flatten(values2.toList());
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(keys2);
        String description2 = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return this.newListAssertInstance(valuesFlattened).as(description2, new Object[0]);
    }

    private static List<Object> flatten(Iterable<Object> collectionToFlatten) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object item : collectionToFlatten) {
            if (item instanceof Iterable) {
                result2.addAll(IterableUtil.toCollection((Iterable)item));
                continue;
            }
            if (Arrays.isArray(item)) {
                result2.addAll(Arrays.asList(item));
                continue;
            }
            result2.add(item);
        }
        return result2;
    }
}

