/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.annotation.Annotation;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Classes;

public abstract class AbstractClassAssert<SELF extends AbstractClassAssert<SELF>>
extends AbstractAssert<SELF, Class<?>> {
    Classes classes = Classes.instance();

    public AbstractClassAssert(Class<?> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isAssignableFrom(Class<?> ... others) {
        this.classes.assertIsAssignableFrom(this.info, (Class)this.actual, others);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotInterface() {
        this.classes.assertIsNotInterface(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isInterface() {
        this.classes.assertIsInterface(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isAnnotation() {
        this.classes.assertIsAnnotation(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotAnnotation() {
        this.classes.assertIsNotAnnotation(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isFinal() {
        this.classes.assertIsFinal(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotFinal() {
        this.classes.assertIsNotFinal(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isPublic() {
        this.classes.assertIsPublic(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isProtected() {
        this.classes.assertIsProtected(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasAnnotations(Class<? extends Annotation> ... annotations2) {
        this.classes.assertContainsAnnotations(this.info, (Class)this.actual, annotations2);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasAnnotation(Class<? extends Annotation> annotation) {
        this.classes.assertContainsAnnotations(this.info, (Class)this.actual, annotation);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    @Deprecated
    public SELF hasFields(String ... fields2) {
        return this.hasPublicFields(fields2);
    }

    public SELF hasPublicFields(String ... fields2) {
        this.classes.assertHasPublicFields(this.info, (Class)this.actual, fields2);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasOnlyPublicFields(String ... fields2) {
        this.classes.assertHasOnlyPublicFields(this.info, (Class)this.actual, fields2);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasDeclaredFields(String ... fields2) {
        this.classes.assertHasDeclaredFields(this.info, (Class)this.actual, fields2);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasOnlyDeclaredFields(String ... fields2) {
        this.classes.assertHasOnlyDeclaredFields(this.info, (Class)this.actual, fields2);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasMethods(String ... methodNames) {
        this.classes.assertHasMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasDeclaredMethods(String ... methodNames) {
        this.classes.assertHasDeclaredMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasPublicMethods(String ... methodNames) {
        this.classes.assertHasPublicMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }
}

