/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WebSocketClientExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketClientExtensionHandshaker> extensionHandshakers;

    public WebSocketClientExtensionHandler(WebSocketClientExtensionHandshaker ... extensionHandshakers) {
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty(extensionHandshakers, "extensionHandshakers"));
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpRequest && WebSocketExtensionUtil.isWebsocketUpgrade(((HttpRequest)msg).headers())) {
            HttpRequest request2 = (HttpRequest)msg;
            String headerValue = request2.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
            for (WebSocketClientExtensionHandshaker extensionHandshaker : this.extensionHandshakers) {
                extraExtensions.add(extensionHandshaker.newRequestData());
            }
            String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
            request2.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
        }
        super.write(ctx, msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpResponse response2;
        if (msg instanceof HttpResponse && WebSocketExtensionUtil.isWebsocketUpgrade((response2 = (HttpResponse)msg).headers())) {
            String extensionsHeader = response2.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (extensionsHeader != null) {
                List<WebSocketExtensionData> extensions2 = WebSocketExtensionUtil.extractExtensions(extensionsHeader);
                ArrayList<WebSocketExtension> validExtensions = new ArrayList<WebSocketExtension>(extensions2.size());
                int rsv = 0;
                for (WebSocketExtensionData webSocketExtensionData : extensions2) {
                    Iterator<WebSocketClientExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                    WebSocketExtension validExtension = null;
                    while (validExtension == null && extensionHandshakersIterator.hasNext()) {
                        WebSocketClientExtensionHandshaker extensionHandshaker = extensionHandshakersIterator.next();
                        validExtension = extensionHandshaker.handshakeExtension(webSocketExtensionData);
                    }
                    if (validExtension != null && (validExtension.rsv() & rsv) == 0) {
                        rsv |= validExtension.rsv();
                        validExtensions.add(validExtension);
                        continue;
                    }
                    throw new CodecException("invalid WebSocket Extension handshake for \"" + extensionsHeader + '\"');
                }
                for (WebSocketClientExtension webSocketClientExtension : validExtensions) {
                    WebSocketExtensionDecoder decoder = webSocketClientExtension.newExtensionDecoder();
                    WebSocketExtensionEncoder encoder2 = webSocketClientExtension.newExtensionEncoder();
                    ctx.pipeline().addAfter(ctx.name(), decoder.getClass().getName(), decoder);
                    ctx.pipeline().addAfter(ctx.name(), encoder2.getClass().getName(), encoder2);
                }
            }
            ctx.pipeline().remove(ctx.name());
        }
        super.channelRead(ctx, msg);
    }
}

