/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.forwardedheaders;

import io.ktor.http.URLProtocol;
import io.ktor.server.plugins.MutableOriginConnectionPoint;
import io.ktor.server.plugins.forwardedheaders.ForwardedHeaderValue;
import io.ktor.server.plugins.forwardedheaders.ForwardedHeadersConfig;
import io.ktor.util.KtorDsl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@KtorDsl
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\b2\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0004J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\bR2\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/plugins/forwardedheaders/ForwardedHeadersConfig;", "", "()V", "forwardedHeadersHandler", "Lkotlin/Function2;", "Lio/ktor/server/plugins/MutableOriginConnectionPoint;", "", "Lio/ktor/server/plugins/forwardedheaders/ForwardedHeaderValue;", "", "getForwardedHeadersHandler$ktor_server_forwarded_header", "()Lkotlin/jvm/functions/Function2;", "setForwardedHeadersHandler$ktor_server_forwarded_header", "(Lkotlin/jvm/functions/Function2;)V", "extractValue", "block", "setValues", "connectionPoint", "forward", "skipKnownProxies", "hosts", "", "skipLastProxies", "proxiesCount", "", "useFirstValue", "useLastValue", "ktor-server-forwarded-header"})
public final class ForwardedHeadersConfig {
    @NotNull
    private Function2<? super MutableOriginConnectionPoint, ? super List<ForwardedHeaderValue>, Unit> forwardedHeadersHandler = forwardedHeadersHandler.1.INSTANCE;

    public ForwardedHeadersConfig() {
        this.useFirstValue();
    }

    @NotNull
    public final Function2<MutableOriginConnectionPoint, List<ForwardedHeaderValue>, Unit> getForwardedHeadersHandler$ktor_server_forwarded_header() {
        return this.forwardedHeadersHandler;
    }

    public final void setForwardedHeadersHandler$ktor_server_forwarded_header(@NotNull Function2<? super MutableOriginConnectionPoint, ? super List<ForwardedHeaderValue>, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, "<set-?>");
        this.forwardedHeadersHandler = function2;
    }

    public final void extractValue(@NotNull Function2<? super MutableOriginConnectionPoint, ? super List<ForwardedHeaderValue>, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        this.forwardedHeadersHandler = block2;
    }

    public final void useFirstValue() {
        this.extractValue((Function2<? super MutableOriginConnectionPoint, ? super List<ForwardedHeaderValue>, Unit>)new Function2<MutableOriginConnectionPoint, List<? extends ForwardedHeaderValue>, Unit>(this){
            final /* synthetic */ ForwardedHeadersConfig this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull List<ForwardedHeaderValue> headers2) {
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                ForwardedHeadersConfig.access$setValues(this.this$0, connectionPoint, CollectionsKt.firstOrNull(headers2));
            }
        });
    }

    public final void useLastValue() {
        this.extractValue((Function2<? super MutableOriginConnectionPoint, ? super List<ForwardedHeaderValue>, Unit>)new Function2<MutableOriginConnectionPoint, List<? extends ForwardedHeaderValue>, Unit>(this){
            final /* synthetic */ ForwardedHeadersConfig this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull List<ForwardedHeaderValue> headers2) {
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                ForwardedHeadersConfig.access$setValues(this.this$0, connectionPoint, CollectionsKt.lastOrNull(headers2));
            }
        });
    }

    public final void skipLastProxies(int proxiesCount) {
        this.extractValue((Function2<? super MutableOriginConnectionPoint, ? super List<ForwardedHeaderValue>, Unit>)new Function2<MutableOriginConnectionPoint, List<? extends ForwardedHeaderValue>, Unit>(this, proxiesCount){
            final /* synthetic */ ForwardedHeadersConfig this$0;
            final /* synthetic */ int $proxiesCount;
            {
                this.this$0 = $receiver;
                this.$proxiesCount = $proxiesCount;
                super(2);
            }

            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull List<ForwardedHeaderValue> headers2) {
                ForwardedHeaderValue forwardedHeaderValue;
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                ForwardedHeadersConfig forwardedHeadersConfig = this.this$0;
                MutableOriginConnectionPoint mutableOriginConnectionPoint2 = connectionPoint;
                List<ForwardedHeaderValue> list = headers2;
                int n = headers2.size() - this.$proxiesCount - 1;
                if (n >= 0 && n <= CollectionsKt.getLastIndex(list)) {
                    forwardedHeaderValue = list.get(n);
                } else {
                    int n2 = n;
                    MutableOriginConnectionPoint mutableOriginConnectionPoint3 = mutableOriginConnectionPoint2;
                    ForwardedHeadersConfig forwardedHeadersConfig2 = forwardedHeadersConfig;
                    boolean bl = false;
                    ForwardedHeaderValue forwardedHeaderValue2 = CollectionsKt.last(headers2);
                    forwardedHeadersConfig = forwardedHeadersConfig2;
                    mutableOriginConnectionPoint2 = mutableOriginConnectionPoint3;
                    forwardedHeaderValue = forwardedHeaderValue2;
                }
                ForwardedHeadersConfig.access$setValues(forwardedHeadersConfig, mutableOriginConnectionPoint2, forwardedHeaderValue);
            }
        });
    }

    public final void skipKnownProxies(@NotNull List<String> hosts2) {
        Intrinsics.checkNotNullParameter(hosts2, "hosts");
        this.extractValue((Function2<? super MutableOriginConnectionPoint, ? super List<ForwardedHeaderValue>, Unit>)new Function2<MutableOriginConnectionPoint, List<? extends ForwardedHeaderValue>, Unit>(hosts2, this){
            final /* synthetic */ List<String> $hosts;
            final /* synthetic */ ForwardedHeadersConfig this$0;
            {
                this.$hosts = $hosts;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull List<ForwardedHeaderValue> headers2) {
                ForwardedHeaderValue forwardedHeaderValue;
                int proxiesCount;
                Object object;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                Iterable $this$map$iv = headers2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ForwardedHeaderValue forwardedHeaderValue2 = (ForwardedHeaderValue)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    object.add(it.getForParam());
                }
                List forValues = (List)destination$iv$iv2;
                for (proxiesCount = 0; CollectionsKt.getLastIndex(this.$hosts) >= proxiesCount && CollectionsKt.getLastIndex(forValues) >= proxiesCount; ++proxiesCount) {
                    String string = (String)forValues.get(forValues.size() - proxiesCount - 1);
                    if (!Intrinsics.areEqual(((Object)StringsKt.trim((CharSequence)this.$hosts.get(this.$hosts.size() - proxiesCount - 1))).toString(), string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null)) break;
                }
                Object object2 = this.this$0;
                MutableOriginConnectionPoint mutableOriginConnectionPoint2 = connectionPoint;
                List<ForwardedHeaderValue> list = headers2;
                int n = headers2.size() - proxiesCount - 1;
                if (n >= 0 && n <= CollectionsKt.getLastIndex(list)) {
                    forwardedHeaderValue = list.get(n);
                } else {
                    int destination$iv$iv2 = n;
                    MutableOriginConnectionPoint mutableOriginConnectionPoint3 = mutableOriginConnectionPoint2;
                    object = object2;
                    boolean bl = false;
                    ForwardedHeaderValue forwardedHeaderValue3 = CollectionsKt.last(headers2);
                    object2 = object;
                    mutableOriginConnectionPoint2 = mutableOriginConnectionPoint3;
                    forwardedHeaderValue = forwardedHeaderValue3;
                }
                ForwardedHeadersConfig.access$setValues((ForwardedHeadersConfig)object2, mutableOriginConnectionPoint2, forwardedHeaderValue);
            }
        });
    }

    private final void setValues(MutableOriginConnectionPoint connectionPoint, ForwardedHeaderValue forward) {
        block5: {
            block6: {
                if (forward == null) {
                    return;
                }
                if (forward.getProto() != null) {
                    String proto = forward.getProto();
                    connectionPoint.setScheme(proto);
                    URLProtocol uRLProtocol = URLProtocol.Companion.getByName().get(proto);
                    if (uRLProtocol != null) {
                        URLProtocol p = uRLProtocol;
                        boolean bl = false;
                        connectionPoint.setPort(p.getDefaultPort());
                        connectionPoint.setServerPort(p.getDefaultPort());
                    }
                }
                if (forward.getForParam() != null) {
                    String[] stringArray = new String[]{","};
                    String remoteHost2 = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first(StringsKt.split$default((CharSequence)forward.getForParam(), stringArray, false, 0, 6, null))))).toString();
                    if (!StringsKt.isBlank(remoteHost2)) {
                        connectionPoint.setRemoteHost(remoteHost2);
                    }
                }
                if (forward.getHost() == null) break block5;
                String host2 = StringsKt.substringBefore$default(forward.getHost(), ':', null, 2, null);
                String port2 = StringsKt.substringAfter(forward.getHost(), ':', "");
                connectionPoint.setHost(host2);
                connectionPoint.setServerHost(host2);
                Integer n = StringsKt.toIntOrNull(port2);
                if (n == null) break block6;
                int it = ((Number)n).intValue();
                boolean bl = false;
                connectionPoint.setPort(it);
                connectionPoint.setServerPort(it);
                break block5;
            }
            URLProtocol uRLProtocol = URLProtocol.Companion.getByName().get(connectionPoint.getScheme());
            if (uRLProtocol == null) break block5;
            URLProtocol it = uRLProtocol;
            boolean bl = false;
            connectionPoint.setPort(it.getDefaultPort());
            connectionPoint.setServerPort(it.getDefaultPort());
        }
    }

    public static final /* synthetic */ void access$setValues(ForwardedHeadersConfig $this, MutableOriginConnectionPoint connectionPoint, ForwardedHeaderValue forward) {
        $this.setValues(connectionPoint, forward);
    }
}

