/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.callid;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.CreatePluginUtilsKt;
import io.ktor.server.application.RouteScopedPlugin;
import io.ktor.server.plugins.callid.CallIdConfig;
import io.ktor.server.plugins.callid.CallIdKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.CharsetKt;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u001a\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019*\u00020\u0001H\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u001b*\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0001\u001a\u001c\u0010\u001f\u001a\u00020\u0001*\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020!H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0012*D\u0010\"\"\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0006\u0012\u0004\u0018\u00010\u00010#2\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0006\u0012\u0004\u0018\u00010\u00010#*\"\u0010'\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140#2\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140#\u00a8\u0006("}, d2={"CALL_ID_DEFAULT_DICTIONARY", "", "CallId", "Lio/ktor/server/application/RouteScopedPlugin;", "Lio/ktor/server/plugins/callid/CallIdConfig;", "getCallId", "()Lio/ktor/server/application/RouteScopedPlugin;", "CallIdKey", "Lio/ktor/util/AttributeKey;", "getCallIdKey", "()Lio/ktor/util/AttributeKey;", "LOGGER", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "callId", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;)Ljava/lang/String;", "verifyCallIdAgainstDictionary", "", "dictionarySet", "", "", "duplicates", "", "generate", "", "length", "", "dictionary", "nextString", "Lkotlin/random/Random;", "", "CallIdProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "call", "CallIdVerifier", "ktor-server-call-id"})
public final class CallIdKt {
    @NotNull
    private static final Logger LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger("io.ktor.server.plugins.callid.CallId");
    @NotNull
    private static final AttributeKey<String> CallIdKey = new AttributeKey("ExtractedCallId");
    @NotNull
    private static final RouteScopedPlugin<CallIdConfig> CallId = CreatePluginUtilsKt.createRouteScopedPlugin("CallId", CallId.1.INSTANCE, CallId.2.INSTANCE);
    @NotNull
    public static final String CALL_ID_DEFAULT_DICTIONARY = "abcdefghijklmnopqrstuvwxyz0123456789+/=-";

    @NotNull
    public static final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public static final AttributeKey<String> getCallIdKey() {
        return CallIdKey;
    }

    @NotNull
    public static final RouteScopedPlugin<CallIdConfig> getCallId() {
        return CallId;
    }

    @Nullable
    public static final String getCallId(@NotNull ApplicationCall $this$callId) {
        Intrinsics.checkNotNullParameter($this$callId, "<this>");
        return $this$callId.getAttributes().getOrNull(CallIdKey);
    }

    private static final boolean verifyCallIdAgainstDictionary(String callId, Set<Character> dictionarySet) {
        int n = callId.length();
        for (int j = 0; j < n; ++j) {
            char element = callId.charAt(j);
            if (dictionarySet.contains(Character.valueOf(element))) continue;
            return false;
        }
        return true;
    }

    public static final void generate(@NotNull CallIdConfig $this$generate, int length, @NotNull String dictionary) {
        Intrinsics.checkNotNullParameter($this$generate, "<this>");
        Intrinsics.checkNotNullParameter(dictionary, "dictionary");
        if (!(length >= 1)) {
            boolean $i$a$-require-CallIdKt$generate$42 = false;
            String $i$a$-require-CallIdKt$generate$42 = "Call id should be at least one characters length: " + length;
            throw new IllegalArgumentException($i$a$-require-CallIdKt$generate$42.toString());
        }
        if (!(dictionary.length() > 1)) {
            boolean bl = false;
            String string = "Dictionary should consist of several different characters";
            throw new IllegalArgumentException(string.toString());
        }
        char[] dictionaryCharacters = CollectionsKt.toCharArray((Collection<Character>)ArraysKt.distinct(CharsetKt.toCharArray(dictionary)));
        if (!(dictionaryCharacters.length == dictionary.length())) {
            boolean bl = false;
            String string = "Dictionary should not contain duplicates, found: " + CallIdKt.duplicates(dictionary);
            throw new IllegalArgumentException(string.toString());
        }
        $this$generate.generate((Function1<? super ApplicationCall, String>)new Function1<ApplicationCall, String>(length, dictionaryCharacters){
            final /* synthetic */ int $length;
            final /* synthetic */ char[] $dictionaryCharacters;
            {
                this.$length = $length;
                this.$dictionaryCharacters = $dictionaryCharacters;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull ApplicationCall it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return CallIdKt.access$nextString(Random.Default, this.$length, this.$dictionaryCharacters);
            }
        });
    }

    public static /* synthetic */ void generate$default(CallIdConfig callIdConfig, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            string = CALL_ID_DEFAULT_DICTIONARY;
        }
        CallIdKt.generate(callIdConfig, n, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Character> duplicates(String $this$duplicates) {
        void $this$groupByTo$iv$iv;
        char[] $this$groupBy$iv = CharsetKt.toCharArray($this$duplicates);
        boolean $i$f$groupBy = false;
        char[] cArray = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        int n = ((void)$this$groupByTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Object object;
            void element$iv$iv;
            void it = element$iv$iv = $this$groupByTo$iv$iv[j];
            boolean bl = false;
            Character key$iv$iv = Character.valueOf((char)it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(Character.valueOf((char)element$iv$iv));
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.sorted(((Map)result$iv).keySet());
    }

    private static final String nextString(Random $this$nextString, int length, char[] dictionary) {
        char[] chars = new char[length];
        int dictionarySize = dictionary.length;
        for (int index = 0; index < length; ++index) {
            chars[index] = dictionary[$this$nextString.nextInt(dictionarySize)];
        }
        return StringsKt.concatToString(chars);
    }

    public static final /* synthetic */ boolean access$verifyCallIdAgainstDictionary(String callId, Set dictionarySet) {
        return CallIdKt.verifyCallIdAgainstDictionary(callId, dictionarySet);
    }

    public static final /* synthetic */ String access$nextString(Random $receiver, int length, char[] dictionary) {
        return CallIdKt.nextString($receiver, length, dictionary);
    }
}

