/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.engine.BaseApplicationCall;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyDirectEncoder;
import io.ktor.server.netty.http1.NettyHttp1ApplicationRequest;
import io.ktor.server.netty.http1.NettyHttp1ApplicationResponse;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u001cJ\u001d\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b%R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lio/ktor/server/netty/http1/NettyHttp1ApplicationCall;", "Lio/ktor/server/netty/NettyApplicationCall;", "application", "Lio/ktor/server/application/Application;", "context", "Lio/netty/channel/ChannelHandlerContext;", "httpRequest", "Lio/netty/handler/codec/http/HttpRequest;", "requestBodyChannel", "Lio/ktor/utils/io/ByteReadChannel;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "(Lio/ktor/server/application/Application;Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "request", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationRequest;", "getRequest", "()Lio/ktor/server/netty/http1/NettyHttp1ApplicationRequest;", "response", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationResponse;", "getResponse", "()Lio/ktor/server/netty/http1/NettyHttp1ApplicationResponse;", "isContextCloseRequired", "", "isContextCloseRequired$ktor_server_netty", "prepareEndOfStreamMessage", "", "lastTransformed", "prepareEndOfStreamMessage$ktor_server_netty", "prepareMessage", "buf", "Lio/netty/buffer/ByteBuf;", "isLastContent", "prepareMessage$ktor_server_netty", "upgrade", "", "dst", "upgrade$ktor_server_netty", "ktor-server-netty"})
public final class NettyHttp1ApplicationCall
extends NettyApplicationCall {
    @NotNull
    private final NettyHttp1ApplicationRequest request;
    @NotNull
    private final NettyHttp1ApplicationResponse response;

    public NettyHttp1ApplicationCall(@NotNull Application application, @NotNull ChannelHandlerContext context, @NotNull HttpRequest httpRequest, @Nullable ByteReadChannel requestBodyChannel, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext) {
        Intrinsics.checkNotNullParameter(application, "application");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(httpRequest, "httpRequest");
        Intrinsics.checkNotNullParameter(engineContext, "engineContext");
        Intrinsics.checkNotNullParameter(userContext, "userContext");
        super(application, context, httpRequest);
        ApplicationCall applicationCall = this;
        ByteReadChannel byteReadChannel = requestBodyChannel;
        if (byteReadChannel == null) {
            byteReadChannel = ByteReadChannel.Companion.getEmpty();
        }
        this.request = new NettyHttp1ApplicationRequest(applicationCall, engineContext, context, httpRequest, byteReadChannel);
        NettyApplicationCall nettyApplicationCall = this;
        HttpVersion httpVersion = httpRequest.protocolVersion();
        Intrinsics.checkNotNullExpressionValue(httpVersion, "httpRequest.protocolVersion()");
        this.response = new NettyHttp1ApplicationResponse(nettyApplicationCall, context, engineContext, userContext, httpVersion);
        BaseApplicationCall.putResponseAttribute$default(this, null, 1, null);
    }

    @Override
    @NotNull
    public NettyHttp1ApplicationRequest getRequest() {
        return this.request;
    }

    @Override
    @NotNull
    public NettyHttp1ApplicationResponse getResponse() {
        return this.response;
    }

    @Override
    @NotNull
    public Object prepareMessage$ktor_server_netty(@NotNull ByteBuf buf, boolean isLastContent) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareMessage$ktor_server_netty(buf, isLastContent);
        }
        return new DefaultHttpContent(buf);
    }

    @Override
    @Nullable
    public Object prepareEndOfStreamMessage$ktor_server_netty(boolean lastTransformed) {
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareEndOfStreamMessage$ktor_server_netty(lastTransformed);
        }
        return LastHttpContent.EMPTY_LAST_CONTENT;
    }

    @Override
    public void upgrade$ktor_server_netty(@NotNull ChannelHandlerContext dst) {
        ChannelPipeline channelPipeline;
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (this.isByteBufferContent$ktor_server_netty()) {
            super.upgrade$ktor_server_netty(dst);
            return;
        }
        ChannelPipeline $this$upgrade_u24lambda_u240 = channelPipeline = dst.pipeline();
        boolean bl = false;
        $this$upgrade_u24lambda_u240.replace(HttpServerCodec.class, "direct-encoder", (ChannelHandler)new NettyDirectEncoder());
    }

    @Override
    public boolean isContextCloseRequired$ktor_server_netty() {
        return !this.isByteBufferContent$ktor_server_netty();
    }
}

