/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.Configurable;
import io.ktor.network.sockets.SocketOptions;
import io.ktor.network.sockets.TcpSocketBuilder;
import io.ktor.network.sockets.UDPSocketBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0005\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/ktor/network/sockets/SocketBuilder;", "Lio/ktor/network/sockets/Configurable;", "Lio/ktor/network/sockets/SocketOptions;", "selector", "Lio/ktor/network/selector/SelectorManager;", "options", "(Lio/ktor/network/selector/SelectorManager;Lio/ktor/network/sockets/SocketOptions;)V", "getOptions", "()Lio/ktor/network/sockets/SocketOptions;", "setOptions", "(Lio/ktor/network/sockets/SocketOptions;)V", "tcp", "Lio/ktor/network/sockets/TcpSocketBuilder;", "udp", "Lio/ktor/network/sockets/UDPSocketBuilder;", "ktor-network"})
public final class SocketBuilder
implements Configurable<SocketBuilder, SocketOptions> {
    @NotNull
    private final SelectorManager selector;
    @NotNull
    private SocketOptions options;

    public SocketBuilder(@NotNull SelectorManager selector, @NotNull SocketOptions options2) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(options2, "options");
        this.selector = selector;
        this.options = options2;
    }

    @Override
    @NotNull
    public SocketOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(@NotNull SocketOptions socketOptions) {
        Intrinsics.checkNotNullParameter(socketOptions, "<set-?>");
        this.options = socketOptions;
    }

    @NotNull
    public final TcpSocketBuilder tcp() {
        return new TcpSocketBuilder(this.selector, this.getOptions().peer$ktor_network());
    }

    @NotNull
    public final UDPSocketBuilder udp() {
        return new UDPSocketBuilder(this.selector, this.getOptions().peer$ktor_network().udp$ktor_network());
    }

    @Override
    @NotNull
    public SocketBuilder configure(@NotNull Function1<? super SocketOptions, Unit> block2) {
        return Configurable.DefaultImpls.configure(this, block2);
    }
}

