/*
 * Decompiled with CFR 0.152.
 */
package factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import model.board.Board;
import model.board.Dimension;
import model.board.Figures;
import model.board.Position;
import model.figure.EmptyFigure;
import model.figure.Figure;
import model.figure.Wall;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lfactory/BoardFactory;", "", "()V", "create", "Lmodel/board/Board;", "dimension", "Lmodel/board/Dimension;", "walls", "", "", "Lmodel/figure/Wall;", "getEmptyFigures", "Lmodel/board/Figures;", "setupRandomWalls", "numberOfWallsGiven", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nBoardFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoardFactory.kt\nfactory/BoardFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1855#2:62\n1747#2,3:63\n1856#2:66\n1549#2:68\n1620#2,3:69\n1#3:67\n*S KotlinDebug\n*F\n+ 1 BoardFactory.kt\nfactory/BoardFactory\n*L\n25#1:62\n30#1:63,3\n25#1:66\n58#1:68\n58#1:69,3\n*E\n"})
public final class BoardFactory {
    @NotNull
    public static final BoardFactory INSTANCE = new BoardFactory();

    private BoardFactory() {
    }

    @NotNull
    public final Board create(@NotNull Dimension dimension, int walls) {
        Intrinsics.checkNotNullParameter(dimension, "dimension");
        if (!dimension.isValid()) {
            System.err.println("GuiConstants dimension is smaller than 1");
            System.exit(5);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        Figures figures = this.setupRandomWalls(dimension, walls);
        return new Board(figures);
    }

    @NotNull
    public final Board create(@NotNull Dimension dimension, @NotNull List<Wall> walls) {
        Intrinsics.checkNotNullParameter(dimension, "dimension");
        Intrinsics.checkNotNullParameter(walls, "walls");
        Figures figures = this.getEmptyFigures(dimension);
        Iterable $this$forEach$iv = RangesKt.until(0, dimension.getX() * dimension.getY());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            Wall wall;
            Position position;
            block5: {
                int element$iv;
                int index = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                int x = index % dimension.getX();
                int y = index / dimension.getX();
                position = new Position(x, y);
                wall = new Wall(position);
                Iterable $this$any$iv = walls;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Wall it = (Wall)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getPosition(), position)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                figures.setFigure(position, wall);
                continue;
            }
            figures.setFigure(position, EmptyFigure.INSTANCE);
        }
        return new Board(figures);
    }

    private final Figures setupRandomWalls(Dimension dimension, int numberOfWallsGiven) {
        Figures figures = this.getEmptyFigures(dimension);
        if (numberOfWallsGiven < dimension.getX() * dimension.getY()) {
            for (int numberOfWalls = numberOfWallsGiven; numberOfWalls > 0; --numberOfWalls) {
                Position randomPosition = null;
                while (!(figures.getFigure(randomPosition = dimension.getRandomPosition()) instanceof EmptyFigure)) {
                }
                figures.setFigure(randomPosition, new Wall(randomPosition));
            }
        }
        return figures;
    }

    /*
     * WARNING - void declaration
     */
    private final Figures getEmptyFigures(Dimension dimension) {
        void $this$mapTo$iv$iv;
        void it;
        Dimension dimension2 = dimension;
        int n = 0;
        boolean $i$a$-let-BoardFactory$getEmptyFigures$figures$22 = false;
        int n2 = it.getX() * it.getY();
        Iterable $this$map$iv = RangesKt.until(n, n2);
        boolean $i$f$map = false;
        Iterable $i$a$-let-BoardFactory$getEmptyFigures$figures$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EmptyFigure.INSTANCE);
        }
        List<Figure> figures = CollectionsKt.toMutableList((List)destination$iv$iv);
        return new Figures(figures, dimension);
    }
}

