/*
 * Decompiled with CFR 0.152.
 */
package view.component;

import factory.ImageFactory;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import model.board.Board;
import model.board.BombToUpdate;
import model.board.Position;
import model.figure.Bomb;
import model.figure.EmptyFigure;
import model.figure.Figure;
import model.figure.Level;
import model.figure.Wall;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import service.DelayerService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J1\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2!\u0010 \u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u00070\u0005J\u0012\u0010#\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u000e\u0010$\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lview/component/BoardCanvas;", "Ljava/awt/Canvas;", "board", "Lmodel/board/Board;", "playOnClick", "Lkotlin/Function1;", "Lmodel/board/Position;", "", "(Lmodel/board/Board;Lkotlin/jvm/functions/Function1;)V", "boardHeight", "", "boardWidth", "canvasHeight", "canvasWidth", "figureHeight", "figureWidth", "isRunningOnDifferentThread", "Ljava/util/concurrent/atomic/AtomicBoolean;", "startPointHorizontal", "startPointVertical", "drawGrid", "graphics", "Ljava/awt/Graphics;", "dimensionX", "dimensionY", "drawImage", "position", "image", "Ljava/awt/Image;", "bombToUpdate", "Lmodel/board/BombToUpdate;", "onFigureChanged", "updateInfoText", "Lkotlin/ParameterName;", "name", "paint", "paintAllFigures", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nBoardCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoardCanvas.kt\nview/component/BoardCanvas\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1855#2,2:172\n1855#2,2:174\n1855#2:176\n1855#2,2:177\n1856#2:179\n1#3:180\n*S KotlinDebug\n*F\n+ 1 BoardCanvas.kt\nview/component/BoardCanvas\n*L\n99#1:172,2\n107#1:174,2\n118#1:176\n119#1:177,2\n118#1:179\n*E\n"})
public final class BoardCanvas
extends Canvas {
    @NotNull
    private final Board board;
    @NotNull
    private final Function1<Position, Unit> playOnClick;
    private int canvasHeight;
    private int canvasWidth;
    private int figureWidth;
    private int figureHeight;
    @NotNull
    private final AtomicBoolean isRunningOnDifferentThread;
    private int boardWidth;
    private int boardHeight;
    private int startPointHorizontal;
    private int startPointVertical;

    public BoardCanvas(@NotNull Board board, @NotNull Function1<? super Position, Unit> playOnClick) {
        Intrinsics.checkNotNullParameter(board, "board");
        Intrinsics.checkNotNullParameter(playOnClick, "playOnClick");
        this.board = board;
        this.playOnClick = playOnClick;
        this.isRunningOnDifferentThread = new AtomicBoolean(false);
        this.boardWidth = this.figureWidth * this.board.getDimension().getX();
        this.boardHeight = this.figureHeight * this.board.getDimension().getY();
        this.startPointHorizontal = (this.canvasWidth - this.boardWidth) / 2 - 4;
        this.startPointVertical = (this.canvasHeight - this.boardHeight) / 2 - 4;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(@NotNull MouseEvent mouseEvent) {
                int yCoordinate;
                Intrinsics.checkNotNullParameter(mouseEvent, "mouseEvent");
                int xCoordinate = (mouseEvent.getX() - startPointHorizontal) / figureWidth;
                if (xCoordinate >= board.getDimension().getX()) {
                    xCoordinate = board.getDimension().getX() - 1;
                }
                if ((yCoordinate = (mouseEvent.getY() - startPointVertical) / figureHeight) >= board.getDimension().getY()) {
                    yCoordinate = board.getDimension().getY() - 1;
                }
                Position position = new Position(xCoordinate, yCoordinate);
                if (isRunningOnDifferentThread.compareAndSet(false, true)) {
                    BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, position, null){
                        int label;
                        final /* synthetic */ BoardCanvas this$0;
                        final /* synthetic */ Position $position;
                        {
                            this.this$0 = $receiver;
                            this.$position = $position;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    BoardCanvas.access$getPlayOnClick$p(this.this$0).invoke(this.$position);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 3, null);
                    isRunningOnDifferentThread.compareAndSet(true, false);
                }
            }

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
            }
        });
    }

    @Override
    public void paint(@Nullable Graphics graphics) {
        Rectangle clipBounds;
        if (graphics != null && (clipBounds = graphics.getClipBounds()) != null && (this.canvasWidth != clipBounds.width || this.canvasHeight != clipBounds.height)) {
            this.canvasWidth = clipBounds.width;
            this.canvasHeight = clipBounds.height;
            int dimensionX = this.board.getDimension().getX();
            this.figureWidth = this.canvasWidth / dimensionX;
            int dimensionY = this.board.getDimension().getY();
            this.figureHeight = this.canvasHeight / dimensionY;
            if (this.figureHeight < this.figureWidth) {
                this.figureWidth = this.figureHeight;
            } else if (this.figureWidth < this.figureHeight) {
                this.figureHeight = this.figureWidth;
            }
            this.drawGrid(graphics, dimensionX, dimensionY);
            this.paintAllFigures(this.board);
        }
    }

    private final void drawGrid(Graphics graphics, int dimensionX, int dimensionY) {
        int i2;
        int element$iv;
        this.boardWidth = this.figureWidth * this.board.getDimension().getX();
        this.boardHeight = this.figureHeight * this.board.getDimension().getY();
        this.startPointHorizontal = (this.canvasWidth - this.boardWidth) / 2;
        this.startPointVertical = (this.canvasHeight - this.boardHeight) / 2;
        graphics.setColor(Color.LIGHT_GRAY);
        Iterable $this$forEach$iv = new IntRange(0, dimensionY);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            i2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            graphics.drawLine(this.startPointHorizontal, i2 * this.figureHeight + this.startPointVertical, this.startPointHorizontal + this.boardWidth, i2 * this.figureHeight + this.startPointVertical);
        }
        $this$forEach$iv = new IntRange(0, dimensionX);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            i2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            graphics.drawLine(i2 * this.figureWidth + this.startPointHorizontal, this.startPointVertical, i2 * this.figureWidth + this.startPointHorizontal, this.startPointVertical + this.boardHeight);
        }
    }

    public final void paintAllFigures(@NotNull Board board) {
        Intrinsics.checkNotNullParameter(board, "board");
        Iterable $this$forEach$iv = RangesKt.until(0, board.getDimension().getY());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int positionY = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = RangesKt.until(0, board.getDimension().getX());
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                int element$iv2;
                int positionX = element$iv2 = ((IntIterator)iterator3).nextInt();
                boolean bl2 = false;
                Position position = new Position(positionX, positionY);
                Figure figure = board.getFigure(position);
                if (figure instanceof Bomb) {
                    this.drawImage(position, new BombToUpdate(((Bomb)figure).getPlayer(), ((Bomb)figure).getLevel(), position));
                    continue;
                }
                if (figure instanceof Wall) {
                    this.drawImage(position, ImageFactory.INSTANCE.getWallImage());
                    continue;
                }
                if (!(figure instanceof EmptyFigure)) continue;
                this.drawImage(position, ImageFactory.INSTANCE.getWhiteImage());
            }
        }
    }

    private final void drawImage(Position position, Image image) {
        int xCoordinate = position.getX() * this.figureWidth + this.startPointHorizontal;
        int yCoordinate = position.getY() * this.figureHeight + this.startPointVertical;
        this.getGraphics().drawImage(image, xCoordinate + 1, yCoordinate + 1, this.figureWidth - 2, this.figureHeight - 2, this);
    }

    public final void onFigureChanged(@NotNull BombToUpdate bombToUpdate, @NotNull Function1<? super Board, Unit> updateInfoText) {
        Intrinsics.checkNotNullParameter(bombToUpdate, "bombToUpdate");
        Intrinsics.checkNotNullParameter(updateInfoText, "updateInfoText");
        this.drawImage(bombToUpdate.getPosition(), bombToUpdate);
        updateInfoText.invoke(this.board);
        this.paint(this.getGraphics());
        DelayerService.INSTANCE.explosionDelay();
    }

    private final void drawImage(Position position, BombToUpdate bombToUpdate) {
        block1: {
            block0: {
                if (bombToUpdate.getLevel() != Level.EXPLODING) break block0;
                this.drawImage(position, ImageFactory.INSTANCE.getWhiteImage());
                break block1;
            }
            Map<Level, BufferedImage> map2 = ImageFactory.INSTANCE.getAllBombsImages().get((Object)bombToUpdate.getPlayer().getColor());
            if (map2 == null || (map2 = map2.get((Object)bombToUpdate.getLevel())) == null) break block1;
            Map<Level, BufferedImage> it = map2;
            boolean bl = false;
            this.drawImage(position, (Image)((Object)it));
        }
    }

    public static final /* synthetic */ Function1 access$getPlayOnClick$p(BoardCanvas $this) {
        return $this.playOnClick;
    }
}

