/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.tools.javac.Main;
import factory.BombFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import model.board.Board;
import model.board.BombToUpdate;
import model.board.Game;
import model.board.Position;
import model.event.BombsToUpdateEvent;
import model.event.Event;
import model.event.GameStartedEvent;
import model.event.PositionClickedEvent;
import model.figure.Bomb;
import model.figure.EmptyFigure;
import model.figure.Figure;
import model.figure.Level;
import model.player.Player;
import model.player.PlayerColor;
import org.jetbrains.annotations.NotNull;
import service.DelayerService;
import service.GameService;
import view.component.BoardCanvas;
import view.component.GuiConstantsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0018\u0010\u0013\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u00062\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J:\u0010(\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lview/BoardScreen;", "", "()V", "boardCanvas", "Lview/component/BoardCanvas;", "countLabels", "", "Ljavax/swing/JLabel;", "currentPlayerLabel", "frame", "Ljavax/swing/JFrame;", "getFrame", "()Ljavax/swing/JFrame;", "setFrame", "(Ljavax/swing/JFrame;)V", "game", "Lmodel/board/Game;", "isDrawing", "", "playOnClick", "Lkotlin/Function1;", "Lmodel/event/Event;", "", "addCanvasToFrame", "playerPlacedName", "", "addTitelToFrame", "createInfoText", "textPanel", "Ljavax/swing/JPanel;", "onFigureChanged", "bombsToUpdateEvent", "Lmodel/event/BombsToUpdateEvent;", "painLeftPlayerCounterGray", "playerName", "position", "Lmodel/board/Position;", "playerDisconnectedWhileGameIsRunning", "playerToLeave", "setIconImage", "start", "gameStartedEvent", "Lmodel/event/GameStartedEvent;", "nameOfClient", "updateInfoText", "board", "Lmodel/board/Board;", "currentName", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nBoardScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoardScreen.kt\nview/BoardScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1549#2:180\n1620#2,3:181\n1855#2,2:184\n1360#2:186\n1446#2,2:187\n1603#2,9:189\n1855#2:198\n1856#2:200\n1612#2:201\n1448#2,3:202\n1549#2:206\n1620#2,2:207\n1774#2,4:209\n1622#2:213\n1559#2:214\n1590#2,4:215\n1559#2:219\n1590#2,4:220\n1#3:199\n1#3:205\n*S KotlinDebug\n*F\n+ 1 BoardScreen.kt\nview/BoardScreen\n*L\n53#1:180\n53#1:181,3\n102#1:184,2\n128#1:186\n128#1:187,2\n129#1:189,9\n129#1:198\n129#1:200\n129#1:201\n128#1:202,3\n152#1:206\n152#1:207,2\n153#1:209,4\n152#1:213\n157#1:214\n157#1:215,4\n165#1:219\n165#1:220,4\n129#1:199\n*E\n"})
public final class BoardScreen {
    private Game game;
    private BoardCanvas boardCanvas;
    private Function1<? super Event, Unit> playOnClick;
    private List<? extends JLabel> countLabels;
    public JFrame frame;
    @NotNull
    private final JLabel currentPlayerLabel = new JLabel("", 0);
    private boolean isDrawing;

    @NotNull
    public final JFrame getFrame() {
        JFrame jFrame = this.frame;
        if (jFrame != null) {
            return jFrame;
        }
        Intrinsics.throwUninitializedPropertyAccessException("frame");
        return null;
    }

    public final void setFrame(@NotNull JFrame jFrame) {
        Intrinsics.checkNotNullParameter(jFrame, "<set-?>");
        this.frame = jFrame;
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull Game game, @NotNull JFrame frame, @NotNull Function1<? super Event, Unit> playOnClick, @NotNull GameStartedEvent gameStartedEvent, @NotNull String nameOfClient) {
        BoardCanvas boardCanvas;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(playOnClick, "playOnClick");
        Intrinsics.checkNotNullParameter(gameStartedEvent, "gameStartedEvent");
        Intrinsics.checkNotNullParameter(nameOfClient, "nameOfClient");
        this.game = game;
        this.setFrame(frame);
        this.playOnClick = playOnClick;
        frame.getContentPane().removeAll();
        frame.repaint();
        frame.setTitle("Chain Reaction " + nameOfClient);
        this.setIconImage(frame);
        Iterable iterable = gameStartedEvent.getPlayers();
        BoardScreen boardScreen = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void player;
            Player player2 = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JLabel("Bomb counter " + player.getName() + ": 0", 0));
        }
        boardScreen.countLabels = (List)destination$iv$iv;
        frame.setLayout(new BorderLayout(20, 15));
        this.addTitelToFrame();
        this.addCanvasToFrame(nameOfClient);
        JPanel textPanel = new JPanel(new GridLayout(gameStartedEvent.getPlayers().size() + 1, 1));
        this.createInfoText(textPanel);
        textPanel.setForeground(Color.BLACK);
        BoardCanvas boardCanvas2 = this.boardCanvas;
        if (boardCanvas2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
            boardCanvas2 = null;
        }
        if ((boardCanvas = this.boardCanvas) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
            boardCanvas = null;
        }
        boardCanvas2.paint(boardCanvas.getGraphics());
        frame.getContentPane().setBackground(GuiConstantsKt.getLABEL_BACKGROUND());
        frame.add((Component)textPanel, "South");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private final void setIconImage(JFrame frame) {
        URL fileName = Main.class.getClassLoader().getResource("BombIcon.png");
        BufferedImage bombPictureIcon = ImageIO.read(fileName);
        frame.setIconImage(bombPictureIcon);
    }

    private final void playOnClick(Position position, String playerPlacedName) {
        Function1<? super Event, Unit> function1 = this.playOnClick;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("playOnClick");
            function1 = null;
        }
        function1.invoke(new PositionClickedEvent(position, playerPlacedName));
    }

    private final void addCanvasToFrame(String playerPlacedName) {
        Game game = this.game;
        if (game == null) {
            Intrinsics.throwUninitializedPropertyAccessException("game");
            game = null;
        }
        this.boardCanvas = new BoardCanvas(game.getBoard(), (Function1<? super Position, Unit>)new Function1<Position, Unit>(this, playerPlacedName){
            final /* synthetic */ BoardScreen this$0;
            final /* synthetic */ String $playerPlacedName;
            {
                this.this$0 = $receiver;
                this.$playerPlacedName = $playerPlacedName;
                super(1);
            }

            public final void invoke(@NotNull Position position) {
                Intrinsics.checkNotNullParameter(position, "position");
                if (!BoardScreen.access$isDrawing$p(this.this$0)) {
                    Game game = BoardScreen.access$getGame$p(this.this$0);
                    if (game == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("game");
                        game = null;
                    }
                    if (GameService.INSTANCE.winner(game) == null) {
                        BoardScreen.access$playOnClick(this.this$0, position, this.$playerPlacedName);
                    }
                }
            }
        });
        this.getFrame().add(GuiConstantsKt.getBIG_HORIZONTAL_DISTANCE(), "West");
        JFrame jFrame = this.getFrame();
        BoardCanvas boardCanvas = this.boardCanvas;
        if (boardCanvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
            boardCanvas = null;
        }
        jFrame.add((Component)boardCanvas, "Center");
        this.getFrame().add(GuiConstantsKt.getSMALL_HORIZONTAL_DISTANCE(), "East");
    }

    private final void addTitelToFrame() {
        JLabel title = new JLabel("Chain Reaction", 0);
        title.setFont(new Font("Arial", 0, 50));
        title.setForeground(Color.BLACK);
        this.getFrame().add((Component)title, "North");
    }

    public final void onFigureChanged(@NotNull BombsToUpdateEvent bombsToUpdateEvent, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(bombsToUpdateEvent, "bombsToUpdateEvent");
        Intrinsics.checkNotNullParameter(game, "game");
        this.isDrawing = true;
        Iterable $this$forEach$iv = bombsToUpdateEvent.getBombsToUpdate();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BoardCanvas boardCanvas;
            BombToUpdate it = (BombToUpdate)element$iv;
            boolean bl = false;
            if (it.getLevel() == Level.EXPLODING) {
                game.getBoard().setFigure(it.getPosition(), EmptyFigure.INSTANCE);
                Game game2 = this.game;
                if (game2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("game");
                    game2 = null;
                }
                game2.getBoard().setFigure(it.getPosition(), EmptyFigure.INSTANCE);
            } else {
                Bomb newBomb = BombFactory.INSTANCE.createBomb(it.getPlayer(), it.getLevel());
                game.getBoard().setFigure(it.getPosition(), newBomb);
                Game game3 = this.game;
                if (game3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("game");
                    game3 = null;
                }
                game3.getBoard().setFigure(it.getPosition(), newBomb);
            }
            if ((boardCanvas = this.boardCanvas) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
                boardCanvas = null;
            }
            boardCanvas.onFigureChanged(it, (Function1<? super Board, Unit>)new Function1<Board, Unit>(bombsToUpdateEvent, this){
                final /* synthetic */ BombsToUpdateEvent $bombsToUpdateEvent;
                final /* synthetic */ BoardScreen this$0;
                {
                    this.$bombsToUpdateEvent = $bombsToUpdateEvent;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Board board) {
                    block0: {
                        Intrinsics.checkNotNullParameter(board, "board");
                        Player player = this.$bombsToUpdateEvent.getCurrentPlayer();
                        if (player == null) break block0;
                        Player player2 = player;
                        BoardScreen boardScreen = this.this$0;
                        Player currentPlayer = player2;
                        boolean bl = false;
                        boardScreen.updateInfoText(board, currentPlayer.getName());
                    }
                }
            });
        }
        this.isDrawing = false;
        DelayerService.INSTANCE.reset();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Position> playerDisconnectedWhileGameIsRunning(@NotNull String playerToLeave, @NotNull Game game) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerToLeave, "playerToLeave");
        Intrinsics.checkNotNullParameter(game, "game");
        Iterable $this$flatMap$iv = RangesKt.until(0, game.getBoard().getDimension().getY());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            int element$iv$iv;
            int positionY = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$mapNotNull$iv = RangesKt.until(0, game.getBoard().getDimension().getX());
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Position position;
                int element$iv$iv$iv;
                int element$iv$iv2 = element$iv$iv$iv = ((IntIterator)iterator3).nextInt();
                boolean bl2 = false;
                int positionX = element$iv$iv2;
                boolean bl3 = false;
                Position position2 = new Position(positionX, positionY);
                Figure figure = game.getBoard().getFigure(position2);
                Object object = figure;
                if (Intrinsics.areEqual(object != null && (object = object.getPlayer()) != null ? ((Player)object).getName() : null, playerToLeave)) {
                    game.getBoard().setFigure(position2, EmptyFigure.INSTANCE);
                    Game game2 = this.game;
                    if (game2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("game");
                        game2 = null;
                    }
                    game2.getBoard().setFigure(position2, EmptyFigure.INSTANCE);
                    position = position2;
                } else {
                    position = null;
                }
                if (position == null) continue;
                Position it$iv$iv = position;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List allChanged = (List)destination$iv$iv;
        BoardCanvas boardCanvas = this.boardCanvas;
        if (boardCanvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
            boardCanvas = null;
        }
        boardCanvas.paintAllFigures(game.getBoard());
        this.painLeftPlayerCounterGray(playerToLeave);
        return allChanged;
    }

    private final void painLeftPlayerCounterGray(String playerName) {
        Object v2;
        block3: {
            List<? extends JLabel> list = this.countLabels;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("countLabels");
                list = null;
            }
            Iterable iterable = list;
            for (Object t : iterable) {
                JLabel it = (JLabel)t;
                boolean bl = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue(string, "it.text");
                if (!StringsKt.contains$default((CharSequence)string, ' ' + playerName + ':', false, 2, null)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        JLabel jLabel = v2;
        if (jLabel != null) {
            jLabel.setForeground(Color.lightGray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateInfoText(@NotNull Board board, @NotNull String currentName) {
        void $this$mapIndexedTo$iv$iv;
        int $i$f$count;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(board, "board");
        Intrinsics.checkNotNullParameter(currentName, "currentName");
        Game game = this.game;
        if (game == null) {
            Intrinsics.throwUninitializedPropertyAccessException("game");
            game = null;
        }
        Iterable $this$map$iv = CollectionsKt.getIndices((Collection)game.getPlayers());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int n;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$count$iv = board.getDimension().getAllPositions();
            $i$f$count = 0;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    void playerIndex;
                    Position pos = (Position)element$iv;
                    boolean bl2 = false;
                    Game game2 = this.game;
                    if (game2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("game");
                        game2 = null;
                    }
                    if (!(board.getBombsPlayerIndex(pos, game2.getPlayers()) == playerIndex) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            collection.add(n);
        }
        List counters = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv = counters;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void value;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int $this$count$iv = ((Number)item$iv$iv).intValue();
            $i$f$count = n;
            collection = destination$iv$iv;
            boolean bl = false;
            List<? extends JLabel> list = this.countLabels;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("countLabels");
                list = null;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Bomb counter ");
            Game game3 = this.game;
            if (game3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("game");
                game3 = null;
            }
            list.get((int)index).setText(stringBuilder.append(game3.getPlayers().get((int)index).getName()).append(": ").append((int)value).toString());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.currentPlayerLabel.setText("The Current Player is: " + currentName);
    }

    /*
     * WARNING - void declaration
     */
    private final void createInfoText(JPanel textPanel) {
        void $this$mapIndexedTo$iv$iv;
        List<? extends JLabel> list = this.countLabels;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("countLabels");
            list = null;
        }
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void label;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JLabel jLabel = (JLabel)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            label.setFont(GuiConstantsKt.getLABEL_FONT());
            label.setBackground(GuiConstantsKt.getLABEL_BACKGROUND());
            PlayerColor playerColor = PlayerColor.Companion.forIndex((int)index);
            label.setForeground(playerColor != null ? GuiConstantsKt.toForegroundColor(playerColor) : null);
            collection.add(textPanel.add((Component)label));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        textPanel.setBackground(Color.WHITE);
        Game game = this.game;
        if (game == null) {
            Intrinsics.throwUninitializedPropertyAccessException("game");
            game = null;
        }
        Player player = game.getCurrent();
        String initialPlayerName = player != null ? player.getName() : null;
        this.currentPlayerLabel.setText("The first Player is: " + initialPlayerName);
        this.currentPlayerLabel.setFont(GuiConstantsKt.getLABEL_FONT());
        this.currentPlayerLabel.setBackground(GuiConstantsKt.getLABEL_BACKGROUND());
        textPanel.add(this.currentPlayerLabel);
    }

    public static final /* synthetic */ boolean access$isDrawing$p(BoardScreen $this) {
        return $this.isDrawing;
    }

    public static final /* synthetic */ Game access$getGame$p(BoardScreen $this) {
        return $this.game;
    }

    public static final /* synthetic */ void access$playOnClick(BoardScreen $this, Position position, String playerPlacedName) {
        $this.playOnClick(position, playerPlacedName);
    }
}

