/*
 * Decompiled with CFR 0.152.
 */
package service.server;

import connector.ServerNetworkConnector;
import connector.SessionId;
import factory.GameFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import model.board.Board;
import model.board.BoardInitializeData;
import model.board.BombToUpdate;
import model.board.Game;
import model.board.GameKt;
import model.board.Position;
import model.event.BombsToUpdateEvent;
import model.event.ClientEvent;
import model.event.ConnectionResponseEvent;
import model.event.ConnectionResponseType;
import model.event.Event;
import model.event.GameFinishedEvent;
import model.event.GameSettingsUpdateEvent;
import model.event.GameStartedEvent;
import model.event.PlayerConnectingEvent;
import model.event.PositionClickedEvent;
import model.event.ServerEvent;
import model.figure.Level;
import model.player.Network;
import model.player.Player;
import model.player.PlayerType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import service.BoardService;
import service.DelayerService;
import service.GameProgressService;
import service.server.Server;
import view.BoardScreen;
import view.EndScreen;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0007H\u0002J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0019\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0006\u0010 \u001a\u00020\u0006J\u001e\u0010!\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\u0007J\u0006\u00100\u001a\u00020\u0007J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020.H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2={"Lservice/server/Server;", "", "updateSettingsScreen", "Lkotlin/Function3;", "", "Lmodel/player/PlayerType;", "", "", "(Lkotlin/jvm/functions/Function3;)V", "boardScreen", "Lview/BoardScreen;", "game", "Lmodel/board/Game;", "playerNamesBySessionId", "", "Lconnector/SessionId;", "bindNetworkConnector", "createGame", "frame", "Ljavax/swing/JFrame;", "boardData", "Lmodel/board/BoardInitializeData;", "forceDisconnect", "name", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handle", "clientEvent", "Lmodel/event/ClientEvent;", "sessionId", "serverEvent", "Lmodel/event/ServerEvent;", "handleDisconnect", "hasGameStarted", "informNetworkPlayers", "changes", "", "Lmodel/board/Position;", "onPlayerConnecting", "Lmodel/event/PlayerConnectingEvent;", "connectionId", "onPositionClick", "Lmodel/event/PositionClickedEvent;", "removePlayerFromMap", "sendToAllNetworkClientsAsync", "sendUpdateToEveryone", "update", "Lmodel/event/BombsToUpdateEvent;", "start", "stopGameRunningFlag", "updateUiSync", "bombsToUpdateEvent", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.kt\nservice/server/Server\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1#2:215\n1549#3:216\n1620#3,3:217\n*S KotlinDebug\n*F\n+ 1 Server.kt\nservice/server/Server\n*L\n177#1:216\n177#1:217,3\n*E\n"})
public final class Server {
    @NotNull
    private final Function3<String, PlayerType, Boolean, Unit> updateSettingsScreen;
    @NotNull
    private final BoardScreen boardScreen;
    @Nullable
    private Game game;
    @NotNull
    private final Map<SessionId, String> playerNamesBySessionId;

    public Server(@NotNull Function3<? super String, ? super PlayerType, ? super Boolean, Unit> updateSettingsScreen) {
        Intrinsics.checkNotNullParameter(updateSettingsScreen, "updateSettingsScreen");
        this.updateSettingsScreen = updateSettingsScreen;
        this.boardScreen = new BoardScreen();
        this.playerNamesBySessionId = new LinkedHashMap();
    }

    public final void start() {
        ServerNetworkConnector.INSTANCE.startConnectorIfNotRunning();
        this.bindNetworkConnector();
    }

    public final void handle(@NotNull ServerEvent serverEvent) {
        Intrinsics.checkNotNullParameter(serverEvent, "serverEvent");
        ServerEvent serverEvent2 = serverEvent;
        if (serverEvent2 instanceof BombsToUpdateEvent) {
            this.sendUpdateToEveryone((BombsToUpdateEvent)serverEvent);
        } else if (serverEvent2 instanceof GameSettingsUpdateEvent) {
            this.sendToAllNetworkClientsAsync(serverEvent);
        } else if ((serverEvent2 instanceof ConnectionResponseEvent ? true : serverEvent2 instanceof GameFinishedEvent) ? true : serverEvent2 instanceof GameStartedEvent) {
            // empty if block
        }
    }

    public final void removePlayerFromMap(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable iterable = this.playerNamesBySessionId.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getValue(), name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        SessionId disconnectingId = entry != null ? (SessionId)entry.getKey() : null;
        TypeIntrinsics.asMutableMap(this.playerNamesBySessionId).remove(disconnectingId);
    }

    private final void handle(ClientEvent clientEvent, SessionId sessionId) {
        ClientEvent clientEvent2 = clientEvent;
        if (clientEvent2 instanceof PlayerConnectingEvent) {
            this.onPlayerConnecting((PlayerConnectingEvent)clientEvent, sessionId);
        } else if (clientEvent2 instanceof PositionClickedEvent) {
            this.onPositionClick((PositionClickedEvent)clientEvent);
        }
    }

    private final void onPositionClick(PositionClickedEvent clientEvent) {
        block8: {
            EndScreen endScreen;
            Player winner2;
            Player player;
            block7: {
                Object object;
                Game game = this.game;
                if ((game != null ? game.getCurrent() : null) instanceof Network && Intrinsics.areEqual((object = this.game) != null && (object = ((Game)object).getCurrent()) != null ? ((Player)object).getName() : null, clientEvent.getPlayerPlacedName())) break block7;
                Game game2 = this.game;
                if ((game2 != null ? game2.getCurrent() : null) instanceof Network || !Intrinsics.areEqual(clientEvent.getPlayerPlacedName(), "server")) break block8;
            }
            Game game = this.game;
            if (game != null) {
                Game it = game;
                boolean bl = false;
                player = GameProgressService.INSTANCE.play(it, clientEvent.getPosition(), (Function1<? super BombsToUpdateEvent, Unit>)new Function1<BombsToUpdateEvent, Unit>((Object)this){

                    public final void invoke(@NotNull BombsToUpdateEvent p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        Server.access$sendUpdateToEveryone((Server)this.receiver, p0);
                    }
                });
            } else {
                player = null;
            }
            Player player2 = winner2 = player;
            if (player2 != null) {
                Player it = player2;
                boolean bl = false;
                GameFinishedEvent gameFinishedEvent = new GameFinishedEvent(it.getName(), it.getColor());
                this.sendToAllNetworkClientsAsync(gameFinishedEvent);
                ServerNetworkConnector.INSTANCE.clearSessions();
                endScreen = new EndScreen(it.getName(), it.getColor(), this.boardScreen.getFrame());
            } else {
                endScreen = null;
            }
        }
    }

    private final void onPlayerConnecting(PlayerConnectingEvent clientEvent, SessionId connectionId) {
        ConnectionResponseEvent connectionResponseEvent;
        if (StringsKt.isBlank(clientEvent.getJoiningName())) {
            connectionResponseEvent = new ConnectionResponseEvent(ConnectionResponseType.NAME_MUST_HAVE_CHARACTERS);
        } else if (this.game != null) {
            connectionResponseEvent = new ConnectionResponseEvent(ConnectionResponseType.GAME_HAS_ALREADY_STARTED);
        } else if (this.playerNamesBySessionId.values().contains(clientEvent.getJoiningName())) {
            connectionResponseEvent = new ConnectionResponseEvent(ConnectionResponseType.NAME_HAS_ALREADY_BEEN_CHOSEN);
        } else if (this.playerNamesBySessionId.size() >= GameKt.getMAX_PLAYERS()) {
            connectionResponseEvent = new ConnectionResponseEvent(ConnectionResponseType.ALREADY_MAX_PLAYERS);
        } else {
            this.updateSettingsScreen.invoke(clientEvent.getJoiningName(), PlayerType.NETWORK, false);
            this.playerNamesBySessionId.put(connectionId, clientEvent.getJoiningName());
            connectionResponseEvent = new ConnectionResponseEvent(ConnectionResponseType.VALID);
        }
        ConnectionResponseEvent responseEvent = connectionResponseEvent;
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connectionId, responseEvent, null){
            int label;
            final /* synthetic */ SessionId $connectionId;
            final /* synthetic */ ConnectionResponseEvent $responseEvent;
            {
                this.$connectionId = $connectionId;
                this.$responseEvent = $responseEvent;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = ServerNetworkConnector.INSTANCE.sendToOne(this.$connectionId, this.$responseEvent, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void sendUpdateToEveryone(BombsToUpdateEvent update) {
        this.sendToAllNetworkClientsAsync(update);
        this.updateUiSync(update);
    }

    private final void sendToAllNetworkClientsAsync(ServerEvent serverEvent) {
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(serverEvent, null){
            int label;
            final /* synthetic */ ServerEvent $serverEvent;
            {
                this.$serverEvent = $serverEvent;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext(Dispatchers.getIO(), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$serverEvent, null){
                            int label;
                            final /* synthetic */ ServerEvent $serverEvent;
                            {
                                this.$serverEvent = $serverEvent;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        this.label = 1;
                                        Object object3 = ServerNetworkConnector.INSTANCE.sendToAllNetworkPlayers(this.$serverEvent, this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure($result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void updateUiSync(BombsToUpdateEvent bombsToUpdateEvent) {
        block0: {
            Game game = this.game;
            if (game == null) break block0;
            Game it = game;
            boolean bl = false;
            this.boardScreen.onFigureChanged(bombsToUpdateEvent, it);
        }
    }

    public final void createGame(@NotNull JFrame frame, @NotNull BoardInitializeData boardData) {
        block5: {
            GameStartedEvent gameStartedEvent;
            GameStartedEvent gameStartedEvent2;
            Intrinsics.checkNotNullParameter(frame, "frame");
            Intrinsics.checkNotNullParameter(boardData, "boardData");
            this.game = GameFactory.INSTANCE.create(boardData);
            Object object = this.game;
            Player player = object != null && (object = ((Game)object).getPlayers()) != null ? (Player)object.get(0) : null;
            if (player != null) {
                player.setCurrentPlayer(true);
            }
            Game game = this.game;
            if (game != null) {
                Game it = game;
                boolean bl = false;
                gameStartedEvent2 = new GameStartedEvent(it.getPlayers(), BoardService.INSTANCE.getWalls(it.getBoard()), it.getBoard().getDimension(), DelayerService.INSTANCE.getExplosionTimeInMs(), DelayerService.INSTANCE.getBotPlayingTimeInMs(), DelayerService.INSTANCE.getExplosionDecrementInMs());
            } else {
                gameStartedEvent2 = null;
            }
            GameStartedEvent gameStartedEvent3 = gameStartedEvent = gameStartedEvent2;
            if (gameStartedEvent3 != null) {
                GameStartedEvent gameStarted = gameStartedEvent3;
                boolean bl = false;
                Game game2 = this.game;
                Intrinsics.checkNotNull(game2);
                this.boardScreen.start(game2, frame, (Function1<? super Event, Unit>)new Function1<Event, Unit>(this){
                    final /* synthetic */ Server this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Event event) {
                        Intrinsics.checkNotNullParameter(event, "event");
                        Event event2 = event;
                        if (event2 instanceof ServerEvent) {
                            this.this$0.handle((ServerEvent)event);
                        } else if (event2 instanceof PositionClickedEvent) {
                            Server.access$handle(this.this$0, (ClientEvent)event, new SessionId(-1));
                        }
                    }
                }, gameStarted, "server");
            }
            GameStartedEvent gameStartedEvent4 = gameStartedEvent;
            if (gameStartedEvent4 != null) {
                GameStartedEvent it = gameStartedEvent4;
                boolean bl = false;
                this.sendToAllNetworkClientsAsync(it);
            }
            Game game3 = this.game;
            if (game3 == null) break block5;
            Game it = game3;
            boolean bl = false;
            GameProgressService.INSTANCE.start(it, (Function1<? super BombsToUpdateEvent, Unit>)new Function1<BombsToUpdateEvent, Unit>((Object)this){

                public final void invoke(@NotNull BombsToUpdateEvent p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    Server.access$sendUpdateToEveryone((Server)this.receiver, p0);
                }
            });
        }
    }

    private final void handleDisconnect(SessionId sessionId) {
        block7: {
            Object v5;
            String name;
            block5: {
                block6: {
                    Object object;
                    List<Position> changes;
                    List<Position> list;
                    name = this.playerNamesBySessionId.get(sessionId);
                    if (this.game == null) break block6;
                    String string = name;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        Game game = this.game;
                        Intrinsics.checkNotNull(game);
                        list = this.boardScreen.playerDisconnectedWhileGameIsRunning(it, game);
                    } else {
                        list = changes = null;
                    }
                    if (changes != null) {
                        this.informNetworkPlayers(name, changes);
                    }
                    if ((object = this.game) == null || (object = ((Game)object).getCurrent()) == null || (object = ((Player)object).getName()) == null) break block7;
                    Object it = object;
                    boolean bl = false;
                    Object object2 = this.game;
                    if (object2 != null && (object2 = ((Game)object2).getBoard()) != null) {
                        Object board = object2;
                        boolean bl2 = false;
                        this.boardScreen.updateInfoText((Board)board, (String)it);
                    }
                    break block7;
                }
                Iterable bl = this.playerNamesBySessionId.entrySet();
                for (Object t : bl) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getValue(), name)) continue;
                    v5 = t;
                    break block5;
                }
                v5 = null;
            }
            Map.Entry entry = v5;
            SessionId disconnectingId = entry != null ? (SessionId)entry.getKey() : null;
            TypeIntrinsics.asMutableMap(this.playerNamesBySessionId).remove(disconnectingId);
            String string = name;
            if (string == null) break block7;
            String it = string;
            boolean bl = false;
            this.updateSettingsScreen.invoke(it, PlayerType.NETWORK, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void informNetworkPlayers(String name, List<Position> changes) {
        block5: {
            Object v3;
            boolean shouldStartNextRound;
            block4: {
                Game game = this.game;
                Intrinsics.checkNotNull(game);
                Player player = game.getCurrent();
                shouldStartNextRound = Intrinsics.areEqual(name, player != null ? player.getName() : null);
                Game game2 = this.game;
                Intrinsics.checkNotNull(game2);
                Iterable iterable = game2.getPlayers();
                for (Object t : iterable) {
                    Player it = (Player)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                    v3 = t;
                    break block4;
                }
                v3 = null;
            }
            Player player = v3;
            if (player != null) {
                void $this$mapTo$iv$iv;
                Object it = player;
                boolean bl = false;
                Iterable $this$map$iv = changes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void pos;
                    Position position = (Position)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new BombToUpdate((Player)it, Level.EXPLODING, (Position)pos));
                }
                List list = (List)destination$iv$iv;
                Game game = this.game;
                Intrinsics.checkNotNull(game);
                String string = name;
                boolean bl3 = shouldStartNextRound;
                boolean bl4 = true;
                Player player2 = game.getCurrent();
                List list2 = list;
                it = new BombsToUpdateEvent(list2, player2, bl4, bl3, string);
                boolean bl5 = false;
                this.sendToAllNetworkClientsAsync((ServerEvent)it);
            }
            if (!shouldStartNextRound) break block5;
            Game game = this.game;
            if (game != null) {
                game.startNextRound();
            }
        }
    }

    private final void bindNetworkConnector() {
        ServerNetworkConnector.INSTANCE.bind((Function2<? super ClientEvent, ? super SessionId, Unit>)new Function2<ClientEvent, SessionId, Unit>((Object)this){

            public final void invoke(@NotNull ClientEvent p0, @NotNull SessionId p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Server.access$handle((Server)this.receiver, p0, p1);
            }
        }, (Function1<? super SessionId, Unit>)new Function1<SessionId, Unit>((Object)this){

            public final void invoke(@NotNull SessionId p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Server.access$handleDisconnect((Server)this.receiver, p0);
            }
        });
    }

    public final boolean hasGameStarted() {
        return this.game != null;
    }

    public final void stopGameRunningFlag() {
        this.game = null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object forceDisconnect(@NotNull String var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof forceDisconnect.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ Server this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.forceDisconnect(null, this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var5_6 = this.playerNamesBySessionId.entrySet();
                for (T var7_10 : var5_6) {
                    it = (Map.Entry)var7_10;
                    $i$a$-find-Server$forceDisconnect$disconnectingId$1 = false;
                    if (!Intrinsics.areEqual(it.getValue(), name)) continue;
                    v0 = var7_10;
                    ** GOTO lbl20
                }
                v0 = null;
lbl20:
                // 2 sources

                v1 = v0;
                v2 = disconnectingId = v1 != null ? (SessionId)v1.getKey() : null;
                if (v2 == null) break;
                it = v2;
                $i$a$-let-Server$forceDisconnect$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = disconnectingId;
                $continuation.label = 1;
                v3 = ServerNetworkConnector.INSTANCE.disconnect(it, $continuation);
                if (v3 == var12_5) {
                    return var12_5;
                }
                break;
            }
            case 1: {
                $i$a$-let-Server$forceDisconnect$2 = false;
                disconnectingId = (SessionId)$continuation.L$1;
                this = (Server)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
                break;
            }
        }
        TypeIntrinsics.asMutableMap(this.playerNamesBySessionId).remove(disconnectingId);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ void access$handle(Server $this, ClientEvent clientEvent, SessionId sessionId) {
        $this.handle(clientEvent, sessionId);
    }

    public static final /* synthetic */ void access$handleDisconnect(Server $this, SessionId sessionId) {
        $this.handleDisconnect(sessionId);
    }

    public static final /* synthetic */ void access$sendUpdateToEveryone(Server $this, BombsToUpdateEvent update) {
        $this.sendUpdateToEveryone(update);
    }
}

