/*
 * Decompiled with CFR 0.152.
 */
package service.server;

import connector.ClientNetworkConnector;
import factory.GameFactory;
import java.util.Map;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import model.board.Game;
import model.event.BombsToUpdateEvent;
import model.event.ClientInitial;
import model.event.ConnectionResponseEvent;
import model.event.ConnectionResponseType;
import model.event.Event;
import model.event.GameFinishedEvent;
import model.event.GameSettingsUpdateEvent;
import model.event.GameStartedEvent;
import model.event.PlayerConnectingEvent;
import model.event.ServerEvent;
import model.player.Player;
import model.player.PlayerType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import service.DelayerService;
import view.BoardScreen;
import view.ClientJoinScreen;
import view.EndScreen;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lservice/server/Client;", "", "frame", "Ljavax/swing/JFrame;", "startGameSettings", "Lkotlin/Function0;", "", "updatePlayers", "Lkotlin/Function1;", "", "", "Lmodel/player/PlayerType;", "(Ljavax/swing/JFrame;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "boardScreen", "Lview/BoardScreen;", "clientJoinScreen", "Lview/ClientJoinScreen;", "game", "Lmodel/board/Game;", "name", "onLoading", "connect", "handleInit", "gameEvent", "Lmodel/event/GameStartedEvent;", "handleMessage", "serverEvent", "Lmodel/event/ServerEvent;", "onBombsUpdate", "Lmodel/event/BombsToUpdateEvent;", "onConnect", "clientInitial", "Lmodel/event/ClientInitial;", "onConnectionResponse", "Lmodel/event/ConnectionResponseEvent;", "onGameStarted", "start", "status", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Client.kt\nservice/server/Client\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class Client {
    @NotNull
    private final JFrame frame;
    @NotNull
    private final Function0<Unit> startGameSettings;
    @NotNull
    private final Function1<Map<String, ? extends PlayerType>, Unit> updatePlayers;
    private String name;
    @NotNull
    private final BoardScreen boardScreen;
    private Function0<Unit> onLoading;
    @Nullable
    private Game game;
    @NotNull
    private final ClientJoinScreen clientJoinScreen;

    public Client(@NotNull JFrame frame, @NotNull Function0<Unit> startGameSettings, @NotNull Function1<? super Map<String, ? extends PlayerType>, Unit> updatePlayers) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(startGameSettings, "startGameSettings");
        Intrinsics.checkNotNullParameter(updatePlayers, "updatePlayers");
        this.frame = frame;
        this.startGameSettings = startGameSettings;
        this.updatePlayers = updatePlayers;
        this.boardScreen = new BoardScreen();
        this.clientJoinScreen = new ClientJoinScreen(this.frame);
    }

    public final void start(@NotNull String status2) {
        Intrinsics.checkNotNullParameter(status2, "status");
        this.clientJoinScreen.start((Function1<? super ClientInitial, Unit>)new Function1<ClientInitial, Unit>((Object)this){

            public final void invoke(@NotNull ClientInitial p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Client.access$onConnect((Client)this.receiver, p0);
            }
        }, status2);
    }

    public static /* synthetic */ void start$default(Client client2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        client2.start(string);
    }

    private final void onConnect(ClientInitial clientInitial) {
        this.name = clientInitial.getName();
        this.onLoading = clientInitial.getOnShowLoading();
        ClientNetworkConnector.INSTANCE.start((Function1<? super ServerEvent, Unit>)new Function1<ServerEvent, Unit>((Object)this){

            public final void invoke(@NotNull ServerEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Client.access$handleMessage((Client)this.receiver, p0);
            }
        }, new Function0<Unit>((Object)this){

            public final void invoke() {
                Client.access$connect((Client)this.receiver);
            }
        }, clientInitial.getIp());
    }

    private final void connect() {
        String string = this.name;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("name");
            string = null;
        }
        ClientNetworkConnector.INSTANCE.sendToServer(new PlayerConnectingEvent(string));
    }

    private final void handleMessage(ServerEvent serverEvent) {
        ServerEvent serverEvent2 = serverEvent;
        if (serverEvent2 instanceof ConnectionResponseEvent) {
            this.onConnectionResponse((ConnectionResponseEvent)serverEvent);
        } else if (serverEvent2 instanceof GameStartedEvent) {
            this.onGameStarted((GameStartedEvent)serverEvent);
        } else if (serverEvent2 instanceof BombsToUpdateEvent) {
            this.onBombsUpdate((BombsToUpdateEvent)serverEvent);
        } else if (serverEvent2 instanceof GameFinishedEvent) {
            new EndScreen(((GameFinishedEvent)serverEvent).getWinnerName(), ((GameFinishedEvent)serverEvent).getWinnerColor(), this.frame);
            this.game = null;
        } else if (serverEvent2 instanceof GameSettingsUpdateEvent) {
            this.updatePlayers.invoke(((GameSettingsUpdateEvent)serverEvent).getNamesOfPlayers());
        }
    }

    private final void onGameStarted(GameStartedEvent serverEvent) {
        DelayerService.INSTANCE.bind(serverEvent.getExplosionTimeInMs(), serverEvent.getBotPlayingTimeInMs(), serverEvent.getExplosionDecrementInMs());
        this.handleInit(serverEvent);
    }

    private final void onBombsUpdate(BombsToUpdateEvent serverEvent) {
        block12: {
            Player player;
            Object object;
            Game it;
            if (this.game == null) break block12;
            Game game = this.game;
            if (game != null) {
                it = game;
                boolean bl = false;
                this.boardScreen.onFigureChanged(serverEvent, it);
            }
            Game game2 = this.game;
            Player player2 = game2 != null ? game2.getCurrent() : null;
            if (player2 != null) {
                player2.setCurrentPlayer(false);
            }
            if ((object = this.game) != null && (object = ((Game)object).getPlayers()) != null) {
                Object v5;
                block11: {
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        Player it2 = (Player)t;
                        boolean bl = false;
                        Player player3 = serverEvent.getCurrentPlayer();
                        if (!Intrinsics.areEqual(it2.getName(), player3 != null ? player3.getName() : null)) continue;
                        v5 = t;
                        break block11;
                    }
                    v5 = null;
                }
                player = v5;
            } else {
                player = null;
            }
            if (player != null) {
                player.setCurrentPlayer(true);
            }
            if (serverEvent.getDisconnecting()) {
                Object object2;
                Game game3 = this.game;
                if (game3 != null) {
                    it = game3;
                    boolean bl = false;
                    this.boardScreen.playerDisconnectedWhileGameIsRunning(serverEvent.getPlayerNameDisconnected(), it);
                }
                if ((object2 = this.game) != null && (object2 = ((Game)object2).getCurrent()) != null && (object2 = ((Player)object2).getName()) != null) {
                    Object it3 = object2;
                    boolean bl = false;
                    Game game4 = this.game;
                    Intrinsics.checkNotNull(game4);
                    this.boardScreen.updateInfoText(game4.getBoard(), (String)it3);
                }
            }
            if (serverEvent.getShouldStartNextRound()) {
                Game game5 = this.game;
                if (game5 != null) {
                    game5.startNextRound();
                }
            }
        }
    }

    private final void onConnectionResponse(ConnectionResponseEvent serverEvent) {
        if (WhenMappings.$EnumSwitchMapping$0[serverEvent.getResponseType().ordinal()] == 1) {
            Function0<Unit> function0 = this.onLoading;
            if (function0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("onLoading");
                function0 = null;
            }
            function0.invoke();
            this.startGameSettings.invoke();
        } else {
            this.start(serverEvent.getResponseType().toString());
        }
    }

    private final void handleInit(GameStartedEvent gameEvent) {
        Game game = this.game = GameFactory.INSTANCE.create(gameEvent.getDimension(), gameEvent.getWalls(), gameEvent.getPlayers());
        Intrinsics.checkNotNull(game);
        game.getPlayers().get(0).setCurrentPlayer(true);
        Game game2 = this.game;
        Intrinsics.checkNotNull(game2);
        Function1 function1 = new Function1<Event, Unit>((Object)ClientNetworkConnector.INSTANCE){

            public final void invoke(@NotNull Event p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((ClientNetworkConnector)this.receiver).sendToServer(p0);
            }
        };
        String string = this.name;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("name");
            string = null;
        }
        this.boardScreen.start(game2, this.frame, function1, gameEvent, string);
    }

    public static final /* synthetic */ void access$onConnect(Client $this, ClientInitial clientInitial) {
        $this.onConnect(clientInitial);
    }

    public static final /* synthetic */ void access$handleMessage(Client $this, ServerEvent serverEvent) {
        $this.handleMessage(serverEvent);
    }

    public static final /* synthetic */ void access$connect(Client $this) {
        $this.connect();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionResponseType.values().length];
            try {
                nArray[ConnectionResponseType.VALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

