/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.support.hierarchical.CompositeLock;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.NopLock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.SingleLock;

class LockManager {
    private static final Comparator<ExclusiveResource> COMPARATOR = Comparator.comparing(ExclusiveResource::getKey, LockManager.globalKeyFirst().thenComparing(Comparator.naturalOrder())).thenComparing(ExclusiveResource::getLockMode);
    private final Map<String, ReadWriteLock> locksByKey = new ConcurrentHashMap<String, ReadWriteLock>();

    LockManager() {
    }

    private static Comparator<String> globalKeyFirst() {
        return Comparator.comparing(key2 -> !"org.junit.platform.engine.support.hierarchical.ExclusiveResource.GLOBAL_KEY".equals(key2));
    }

    ResourceLock getLockForResources(Collection<ExclusiveResource> resources2) {
        if (resources2.size() == 1) {
            return this.getLockForResource(CollectionUtils.getOnlyElement(resources2));
        }
        List<Lock> locks = this.getDistinctSortedLocks(resources2);
        return this.toResourceLock(locks);
    }

    ResourceLock getLockForResource(ExclusiveResource resource2) {
        return new SingleLock(this.toLock(resource2));
    }

    private List<Lock> getDistinctSortedLocks(Collection<ExclusiveResource> resources2) {
        Map resourcesByKey = resources2.stream().sorted(COMPARATOR).distinct().collect(Collectors.groupingBy(ExclusiveResource::getKey, LinkedHashMap::new, Collectors.toList()));
        return resourcesByKey.values().stream().map(resourcesWithSameKey -> (ExclusiveResource)resourcesWithSameKey.get(0)).map(this::toLock).collect(Collectors.toList());
    }

    private Lock toLock(ExclusiveResource resource2) {
        ReadWriteLock lock = this.locksByKey.computeIfAbsent(resource2.getKey(), key2 -> new ReentrantReadWriteLock());
        return resource2.getLockMode() == ExclusiveResource.LockMode.READ ? lock.readLock() : lock.writeLock();
    }

    private ResourceLock toResourceLock(List<Lock> locks) {
        switch (locks.size()) {
            case 0: {
                return NopLock.INSTANCE;
            }
            case 1: {
                return new SingleLock(locks.get(0));
            }
        }
        return new CompositeLock(locks);
    }
}

