/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.0")
public class TestExecutionResult {
    private static final TestExecutionResult SUCCESSFUL_RESULT = new TestExecutionResult(Status.SUCCESSFUL, null);
    private final Status status;
    private final Throwable throwable;

    public static TestExecutionResult successful() {
        return SUCCESSFUL_RESULT;
    }

    public static TestExecutionResult aborted(Throwable throwable) {
        return new TestExecutionResult(Status.ABORTED, throwable);
    }

    public static TestExecutionResult failed(Throwable throwable) {
        return new TestExecutionResult(Status.FAILED, throwable);
    }

    private TestExecutionResult(Status status2, Throwable throwable) {
        this.status = Preconditions.notNull(status2, "Status must not be null");
        this.throwable = throwable;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public String toString() {
        return new ToStringBuilder(this).append("status", (Object)this.status).append("throwable", this.throwable).toString();
    }

    public static enum Status {
        SUCCESSFUL,
        ABORTED,
        FAILED;

    }
}

