/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.function.Function;

final class CloseablePath
implements Closeable {
    private static final String FILE_URI_SCHEME = "file";
    private static final String JAR_URI_SCHEME = "jar";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String JAR_URI_SEPARATOR = "!";
    private static final Closeable NULL_CLOSEABLE = () -> {};
    private final Path path;
    private final Closeable delegate;

    static CloseablePath create(URI uri2) throws IOException, URISyntaxException {
        if (JAR_URI_SCHEME.equals(uri2.getScheme())) {
            String[] parts = uri2.toString().split(JAR_URI_SEPARATOR);
            String jarUri = parts[0];
            String jarEntry2 = parts[1];
            return CloseablePath.createForJarFileSystem(new URI(jarUri), fileSystem -> fileSystem.getPath(jarEntry2, new String[0]));
        }
        if (uri2.getScheme().equals(FILE_URI_SCHEME) && uri2.getPath().endsWith(JAR_FILE_EXTENSION)) {
            return CloseablePath.createForJarFileSystem(new URI("jar:" + uri2), fileSystem -> fileSystem.getRootDirectories().iterator().next());
        }
        return new CloseablePath(Paths.get(uri2), NULL_CLOSEABLE);
    }

    private static CloseablePath createForJarFileSystem(URI jarUri, Function<FileSystem, Path> pathProvider) throws IOException {
        FileSystem fileSystem = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
        Path path = pathProvider.apply(fileSystem);
        return new CloseablePath(path, fileSystem);
    }

    private CloseablePath(Path path, Closeable delegate2) {
        this.path = path;
        this.delegate = delegate2;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

