/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public final class AnnotationConsumerInitializer {
    private static final Predicate<Method> isAnnotationConsumerAcceptMethod = method2 -> method2.getName().equals("accept") && method2.getParameterCount() == 1 && method2.getParameterTypes()[0].isAnnotation();

    private AnnotationConsumerInitializer() {
    }

    public static <T> T initialize(AnnotatedElement annotatedElement, T instance) {
        if (instance instanceof AnnotationConsumer) {
            Method method2 = ReflectionUtils.findMethods(instance.getClass(), isAnnotationConsumerAcceptMethod, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP).get(0);
            Class<?> annotationType = method2.getParameterTypes()[0];
            Annotation annotation = (Annotation)AnnotationUtils.findAnnotation(annotatedElement, annotationType).orElseThrow(() -> new JUnitException(instance.getClass().getName() + " must be used with an annotation of type " + annotationType.getName()));
            AnnotationConsumerInitializer.initializeAnnotationConsumer((AnnotationConsumer)instance, annotation);
        }
        return instance;
    }

    private static <A extends Annotation> void initializeAnnotationConsumer(AnnotationConsumer<A> instance, A annotation) {
        try {
            instance.accept(annotation);
        }
        catch (Exception ex) {
            throw new JUnitException("Failed to initialize AnnotationConsumer: " + instance, ex);
        }
    }
}

