/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.conversions;

import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.Conversion;

public class TrimConversion
implements Conversion<String, String> {
    private final int length;

    public TrimConversion() {
        this.length = -1;
    }

    public TrimConversion(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Maximum trim length must be positive");
        }
        this.length = length;
    }

    @Override
    public String execute(String input2) {
        if (input2 == null) {
            return null;
        }
        if (input2.length() == 0) {
            return input2;
        }
        if (this.length != -1) {
            int begin;
            for (begin = 0; begin < input2.length() && input2.charAt(begin) <= ' '; ++begin) {
            }
            if (begin == input2.length()) {
                return "";
            }
            int end2 = begin + (this.length < input2.length() ? this.length : input2.length()) - 1;
            if (end2 >= input2.length()) {
                end2 = input2.length() - 1;
            }
            while (input2.charAt(end2) <= ' ') {
                --end2;
            }
            return input2.substring(begin, end2 + 1);
        }
        return input2.trim();
    }

    @Override
    public String revert(String input2) {
        return this.execute(input2);
    }
}

