/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.routine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.AbstractParser;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.AbstractWriter;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.CommonParserSettings;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.CommonSettings;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.CommonWriterSettings;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.IterableResult;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ParsingContext;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ResultIterator;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.TextWritingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.ColumnMapper;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.ColumnMapping;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.AbstractRowProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.BeanListProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.BeanProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.BeanWriterProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.RowProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.RowWriterProcessor;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.routine.InputDimension;

public abstract class AbstractRoutines<P extends CommonParserSettings<?>, W extends CommonWriterSettings<?>> {
    private boolean keepResourcesOpen = false;
    private Writer previousOutput;
    private ColumnMapping columnMapper = new ColumnMapping();
    private final String routineDescription;
    private P parserSettings;
    private W writerSettings;

    protected abstract AbstractParser<P> createParser(P var1);

    protected abstract AbstractWriter<W> createWriter(Writer var1, W var2);

    protected abstract P createDefaultParserSettings();

    protected abstract W createDefaultWriterSettings();

    public AbstractRoutines(String routineDescription) {
        this(routineDescription, null, null);
    }

    public AbstractRoutines(String routineDescription, P parserSettings) {
        this(routineDescription, parserSettings, null);
    }

    public AbstractRoutines(String routineDescription, W writerSettings) {
        this(routineDescription, null, writerSettings);
    }

    public AbstractRoutines(String routineDescription, P parserSettings, W writerSettings) {
        this.routineDescription = routineDescription;
        this.parserSettings = parserSettings;
        this.writerSettings = writerSettings;
    }

    private void validateWriterSettings() {
        if (this.writerSettings == null) {
            this.writerSettings = this.createDefaultWriterSettings();
        }
    }

    private void validateParserSettings() {
        if (this.parserSettings == null) {
            this.parserSettings = this.createDefaultParserSettings();
            ((CommonParserSettings)this.parserSettings).setLineSeparatorDetectionEnabled(true);
        }
    }

    public final P getParserSettings() {
        this.validateParserSettings();
        return this.parserSettings;
    }

    public final void setParserSettings(P parserSettings) {
        this.parserSettings = parserSettings;
    }

    public final W getWriterSettings() {
        this.validateWriterSettings();
        return this.writerSettings;
    }

    public final void setWriterSettings(W writerSettings) {
        this.writerSettings = writerSettings;
    }

    protected void adjustColumnLengths(String[] headers2, int[] lengths) {
    }

    public final void write(ResultSet rs, File output2) {
        this.write(rs, output2, (Charset)null);
    }

    public final void write(ResultSet rs, File output2, String encoding) {
        this.write(rs, output2, Charset.forName(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(ResultSet rs, File output2, Charset encoding) {
        Writer writer = ArgumentUtils.newWriter(output2, encoding);
        try {
            this.write(rs, writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error closing file: '" + output2.getAbsolutePath() + "'", e);
            }
        }
    }

    public final void write(ResultSet rs, OutputStream output2) {
        this.write(rs, ArgumentUtils.newWriter(output2));
    }

    public final void write(ResultSet rs, OutputStream output2, String encoding) {
        this.write(rs, ArgumentUtils.newWriter(output2, encoding));
    }

    public final void write(ResultSet rs, OutputStream output2, Charset encoding) {
        this.write(rs, ArgumentUtils.newWriter(output2, encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(ResultSet rs, Writer output2) {
        this.validateWriterSettings();
        boolean hasWriterProcessor = ((CommonWriterSettings)this.writerSettings).getRowWriterProcessor() != null;
        AbstractWriter<W> writer = null;
        long rowCount = 0L;
        Object[] row = null;
        try {
            try {
                ResultSetMetaData md = rs.getMetaData();
                int columns = md.getColumnCount();
                String[] headers2 = new String[columns];
                int[] lengths = new int[columns];
                for (int i2 = 1; i2 <= columns; ++i2) {
                    headers2[i2 - 1] = md.getColumnLabel(i2);
                    int precision = md.getPrecision(i2);
                    int scale = md.getScale(i2);
                    int length = precision != 0 && scale != 0 ? precision + scale + 2 : precision + scale;
                    lengths[i2 - 1] = length;
                }
                String[] userProvidedHeaders = ((CommonSettings)this.writerSettings).getHeaders();
                if (userProvidedHeaders == null) {
                    ((CommonSettings)this.writerSettings).setHeaders(headers2);
                } else {
                    headers2 = userProvidedHeaders;
                }
                this.adjustColumnLengths(headers2, lengths);
                writer = this.createWriter(output2, this.writerSettings);
                if (((CommonWriterSettings)this.writerSettings).isHeaderWritingEnabled()) {
                    writer.writeHeaders();
                }
                row = new Object[columns];
                while (rs.next()) {
                    for (int i3 = 1; i3 <= columns; ++i3) {
                        row[i3 - 1] = rs.getObject(i3);
                    }
                    if (hasWriterProcessor) {
                        writer.processRecord(row);
                    } else {
                        writer.writeRow(row);
                    }
                    ++rowCount;
                }
            }
            finally {
                if (!this.keepResourcesOpen) {
                    rs.close();
                }
            }
        }
        catch (Exception e) {
            throw new TextWritingException("Error writing data from result set", rowCount, row, (Throwable)e);
        }
        finally {
            this.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseAndWrite(Reader input2, Writer output2) {
        this.setRowWriterProcessor(null);
        this.setRowProcessor(this.createWritingRowProcessor(output2));
        try {
            AbstractParser<P> parser = this.createParser(this.parserSettings);
            parser.parse(input2);
        }
        finally {
            ((CommonParserSettings)this.parserSettings).setRowProcessor(null);
        }
    }

    private void setRowWriterProcessor(RowWriterProcessor rowWriterProcessor) {
        this.validateWriterSettings();
        ((CommonWriterSettings)this.writerSettings).setRowWriterProcessor(rowWriterProcessor);
    }

    private void setRowProcessor(RowProcessor rowProcessor) {
        this.validateParserSettings();
        ((CommonParserSettings)this.parserSettings).setRowProcessor(rowProcessor);
    }

    private RowProcessor createWritingRowProcessor(final Writer output2) {
        return new RowProcessor(){
            private AbstractWriter<W> writer;

            @Override
            public void processStarted(ParsingContext context) {
                this.writer = AbstractRoutines.this.createWriter(output2, AbstractRoutines.this.writerSettings);
            }

            @Override
            public void rowProcessed(String[] row, ParsingContext context) {
                this.writer.writeRow(row);
            }

            @Override
            public void processEnded(ParsingContext context) {
                AbstractRoutines.this.close(this.writer);
            }
        };
    }

    private void close(AbstractWriter writer) {
        if (writer != null) {
            if (!this.keepResourcesOpen) {
                writer.close();
            } else {
                writer.flush();
            }
        }
    }

    public <T> void writeAll(Iterable<T> elements, Class<T> beanType, File output2, String ... headers2) {
        this.writeAll(elements, beanType, ArgumentUtils.newWriter(output2), headers2);
    }

    public <T> void writeAll(Iterable<T> elements, Class<T> beanType, File output2, String encoding, String[] headers2) {
        this.writeAll(elements, beanType, ArgumentUtils.newWriter(output2, encoding), headers2);
    }

    public <T> void writeAll(Iterable<T> elements, Class<T> beanType, File output2, Charset encoding, String ... headers2) {
        this.writeAll(elements, beanType, ArgumentUtils.newWriter(output2, encoding), headers2);
    }

    public <T> void writeAll(Iterable<T> elements, Class<T> beanType, OutputStream output2, String ... headers2) {
        this.writeAll(elements, beanType, ArgumentUtils.newWriter(output2), headers2);
    }

    public <T> void writeAll(Iterable<T> elements, Class<T> beanType, OutputStream output2, String encoding, String[] headers2) {
        this.writeAll(elements, beanType, ArgumentUtils.newWriter(output2, encoding), headers2);
    }

    public <T> void writeAll(Iterable<T> elements, Class<T> beanType, OutputStream output2, Charset encoding, String ... headers2) {
        this.writeAll(elements, beanType, ArgumentUtils.newWriter(output2, encoding), headers2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeAll(Iterable<T> elements, Class<T> beanType, Writer output2, String ... headers2) {
        BeanWriterProcessor<T> processor = new BeanWriterProcessor<T>(beanType);
        processor.setColumnMapper(this.columnMapper);
        this.setRowWriterProcessor(processor);
        try {
            if (headers2.length > 0) {
                ((CommonSettings)this.writerSettings).setHeaders(headers2);
                ((CommonWriterSettings)this.writerSettings).setHeaderWritingEnabled(true);
            }
            if (this.keepResourcesOpen && this.previousOutput == output2) {
                ((CommonWriterSettings)this.writerSettings).setHeaderWritingEnabled(false);
            }
            AbstractWriter<W> writer = this.createWriter(output2, this.writerSettings);
            if (this.keepResourcesOpen) {
                writer.processRecords(elements);
                this.previousOutput = output2;
            } else {
                writer.processRecordsAndClose(elements);
            }
        }
        finally {
            ((CommonWriterSettings)this.writerSettings).setRowWriterProcessor(null);
        }
    }

    public <T> List<T> parseAll(Class<T> beanType, File input2, int expectedBeanCount) {
        return this.parseAll(beanType, ArgumentUtils.newReader(input2), expectedBeanCount);
    }

    public <T> List<T> parseAll(Class<T> beanType, File input2, String encoding, int expectedBeanCount) {
        return this.parseAll(beanType, ArgumentUtils.newReader(input2, encoding), expectedBeanCount);
    }

    public <T> List<T> parseAll(Class<T> beanType, File input2, Charset encoding, int expectedBeanCount) {
        return this.parseAll(beanType, ArgumentUtils.newReader(input2, encoding), expectedBeanCount);
    }

    public <T> List<T> parseAll(Class<T> beanType, InputStream input2, int expectedBeanCount) {
        return this.parseAll(beanType, ArgumentUtils.newReader(input2), expectedBeanCount);
    }

    public <T> List<T> parseAll(Class<T> beanType, InputStream input2, String encoding, int expectedBeanCount) {
        return this.parseAll(beanType, ArgumentUtils.newReader(input2, encoding), expectedBeanCount);
    }

    public <T> List<T> parseAll(Class<T> beanType, InputStream input2, Charset encoding, int expectedBeanCount) {
        return this.parseAll(beanType, ArgumentUtils.newReader(input2, encoding), expectedBeanCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> parseAll(Class<T> beanType, Reader input2, int expectedBeanCount) {
        BeanListProcessor<T> processor = new BeanListProcessor<T>(beanType, expectedBeanCount);
        processor.setColumnMapper(this.columnMapper);
        this.setRowProcessor(processor);
        try {
            this.createParser(this.parserSettings).parse(input2);
            List list = processor.getBeans();
            return list;
        }
        finally {
            ((CommonParserSettings)this.parserSettings).setRowProcessor(null);
        }
    }

    public <T> List<T> parseAll(Class<T> beanType, File input2) {
        return this.parseAll(beanType, input2, 0);
    }

    public <T> List<T> parseAll(Class<T> beanType, File input2, String encoding) {
        return this.parseAll(beanType, input2, encoding, 0);
    }

    public <T> List<T> parseAll(Class<T> beanType, File input2, Charset encoding) {
        return this.parseAll(beanType, input2, encoding, 0);
    }

    public <T> List<T> parseAll(Class<T> beanType, InputStream input2) {
        return this.parseAll(beanType, input2, 0);
    }

    public <T> List<T> parseAll(Class<T> beanType, InputStream input2, String encoding) {
        return this.parseAll(beanType, input2, encoding, 0);
    }

    public <T> List<T> parseAll(Class<T> beanType, InputStream input2, Charset encoding) {
        return this.parseAll(beanType, input2, encoding, 0);
    }

    public <T> List<T> parseAll(Class<T> beanType, Reader input2) {
        return this.parseAll(beanType, input2, 0);
    }

    public <T> IterableResult<T, ParsingContext> iterate(Class<T> beanType, File input2) {
        return this.iterate(beanType, ArgumentUtils.newReader(input2));
    }

    public <T> IterableResult<T, ParsingContext> iterate(Class<T> beanType, File input2, String encoding) {
        return this.iterate(beanType, ArgumentUtils.newReader(input2, encoding));
    }

    public <T> IterableResult<T, ParsingContext> iterate(Class<T> beanType, File input2, Charset encoding) {
        return this.iterate(beanType, ArgumentUtils.newReader(input2, encoding));
    }

    public <T> IterableResult<T, ParsingContext> iterate(Class<T> beanType, InputStream input2) {
        return this.iterate(beanType, ArgumentUtils.newReader(input2));
    }

    public <T> IterableResult<T, ParsingContext> iterate(Class<T> beanType, InputStream input2, String encoding) {
        return this.iterate(beanType, ArgumentUtils.newReader(input2, encoding));
    }

    public <T> IterableResult<T, ParsingContext> iterate(Class<T> beanType, InputStream input2, Charset encoding) {
        return this.iterate(beanType, ArgumentUtils.newReader(input2, encoding));
    }

    public <T> IterableResult<T, ParsingContext> iterate(Class<T> beanType, final Reader input2) {
        final Object[] beanHolder = new Object[1];
        BeanProcessor processor = new BeanProcessor<T>(beanType){

            @Override
            public void beanProcessed(T bean, ParsingContext context) {
                beanHolder[0] = bean;
            }

            @Override
            public void processEnded(ParsingContext context) {
                super.processEnded(context);
                AbstractRoutines.this.parserSettings.setRowProcessor(null);
            }
        };
        processor.setColumnMapper(this.columnMapper);
        this.setRowProcessor(processor);
        return new IterableResult<T, ParsingContext>(){
            private ParsingContext context;

            @Override
            public ParsingContext getContext() {
                return this.context;
            }

            @Override
            public ResultIterator<T, ParsingContext> iterator() {
                final AbstractParser<CommonParserSettings> parser = AbstractRoutines.this.createParser(AbstractRoutines.this.parserSettings);
                parser.beginParsing(input2);
                this.context = parser.getContext();
                return new ResultIterator<T, ParsingContext>(){
                    String[] row;

                    @Override
                    public boolean hasNext() {
                        return beanHolder[0] != null || this.row != null || (this.row = parser.parseNext()) != null;
                    }

                    @Override
                    public T next() {
                        Object out2 = beanHolder[0];
                        if (out2 == null && this.hasNext()) {
                            out2 = beanHolder[0];
                        }
                        beanHolder[0] = null;
                        this.row = null;
                        return out2;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Can't remove beans");
                    }

                    @Override
                    public ParsingContext getContext() {
                        return context;
                    }
                };
            }
        };
    }

    public String toString() {
        return this.routineDescription;
    }

    public InputDimension getInputDimension(File input2) {
        return this.getInputDimension(ArgumentUtils.newReader(input2));
    }

    public InputDimension getInputDimension(File input2, String encoding) {
        return this.getInputDimension(ArgumentUtils.newReader(input2, encoding));
    }

    public InputDimension getInputDimension(InputStream input2) {
        return this.getInputDimension(ArgumentUtils.newReader(input2));
    }

    public InputDimension getInputDimension(InputStream input2, String encoding) {
        return this.getInputDimension(ArgumentUtils.newReader(input2, encoding));
    }

    public InputDimension getInputDimension(Reader input2) {
        final InputDimension out2 = new InputDimension();
        this.setRowProcessor(new AbstractRowProcessor(){
            int lastColumn;

            @Override
            public void rowProcessed(String[] row, ParsingContext context) {
                if (this.lastColumn < row.length) {
                    this.lastColumn = row.length;
                }
            }

            @Override
            public void processEnded(ParsingContext context) {
                out2.rows = context.currentRecord() + 1L;
                out2.columns = this.lastColumn;
            }
        });
        P settings = this.getParserSettings();
        ((CommonSettings)settings).setMaxCharsPerColumn(-1);
        if (((CommonSettings)settings).getMaxColumns() < 1000000) {
            ((CommonSettings)settings).setMaxColumns(1000000);
        }
        ((CommonSettings)settings).selectIndexes(new Integer[0]);
        ((CommonParserSettings)settings).setColumnReorderingEnabled(false);
        this.createParser(settings).parse(input2);
        return out2;
    }

    public boolean getKeepResourcesOpen() {
        return this.keepResourcesOpen;
    }

    public void setKeepResourcesOpen(boolean keepResourcesOpen) {
        this.keepResourcesOpen = keepResourcesOpen;
    }

    public ColumnMapper getColumnMapper() {
        return this.columnMapper;
    }

    public void setColumnMapper(ColumnMapper columnMapper) {
        this.columnMapper = columnMapper == null ? new ColumnMapping() : (ColumnMapping)columnMapper.clone();
    }
}

